/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.UnitPropagationListener;

public abstract class HTClause
implements Propagatable,
Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] middleLits;
    protected final ILits voc;
    protected int head;
    protected int tail;

    public HTClause(IVecInt ps, ILits voc) {
        assert (ps.size() > 1);
        this.head = ps.get(0);
        this.tail = ps.last();
        int size = ps.size() - 2;
        assert (size > 0);
        this.middleLits = new int[size];
        System.arraycopy(ps.toArray(), 1, this.middleLits, 0, size);
        ps.clear();
        assert (ps.size() == 0);
        this.voc = voc;
        this.activity = 0.0;
    }

    public void calcReason(int p, IVecInt outReason) {
        int[] mylits;
        if (this.voc.isFalsified(this.head)) {
            outReason.push(LiteralsUtils.neg(this.head));
        }
        int[] nArray = mylits = this.middleLits;
        int n = mylits.length;
        int n2 = 0;
        while (n2 < n) {
            int mylit = nArray[n2];
            if (this.voc.isFalsified(mylit)) {
                outReason.push(LiteralsUtils.neg(mylit));
            }
            ++n2;
        }
        if (this.voc.isFalsified(this.tail)) {
            outReason.push(LiteralsUtils.neg(this.tail));
        }
    }

    public void remove(UnitPropagationListener upl) {
        this.voc.watches(LiteralsUtils.neg(this.head)).remove(this);
        this.voc.watches(LiteralsUtils.neg(this.tail)).remove(this);
    }

    public boolean simplify() {
        if (this.voc.isSatisfied(this.head) || this.voc.isSatisfied(this.tail)) {
            return true;
        }
        int[] nArray = this.middleLits;
        int n = this.middleLits.length;
        int n2 = 0;
        while (n2 < n) {
            int middleLit = nArray[n2];
            if (this.voc.isSatisfied(middleLit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        if (this.head == LiteralsUtils.neg(p)) {
            int[] mylits = this.middleLits;
            int temphead = 0;
            while (temphead < mylits.length && this.voc.isFalsified(mylits[temphead])) {
                ++temphead;
            }
            assert (temphead <= mylits.length);
            if (temphead == mylits.length) {
                this.voc.watch(p, this);
                return s.enqueue(this.tail, this);
            }
            this.head = mylits[temphead];
            mylits[temphead] = LiteralsUtils.neg(p);
            this.voc.watch(LiteralsUtils.neg(this.head), this);
            return true;
        }
        assert (this.tail == LiteralsUtils.neg(p));
        int[] mylits = this.middleLits;
        int temptail = mylits.length - 1;
        while (temptail >= 0 && this.voc.isFalsified(mylits[temptail])) {
            --temptail;
        }
        assert (-1 <= temptail);
        if (-1 == temptail) {
            this.voc.watch(p, this);
            return s.enqueue(this.head, this);
        }
        this.tail = mylits[temptail];
        mylits[temptail] = LiteralsUtils.neg(p);
        this.voc.watch(LiteralsUtils.neg(this.tail), this);
        return true;
    }

    public boolean locked() {
        return this.voc.getReason(this.head) == this || this.voc.getReason(this.tail) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append(Lits.toString(this.head));
        stb.append("[");
        stb.append(this.voc.valueToString(this.head));
        stb.append("]");
        stb.append(" ");
        int[] nArray = this.middleLits;
        int n = this.middleLits.length;
        int n2 = 0;
        while (n2 < n) {
            int middleLit = nArray[n2];
            stb.append(Lits.toString(middleLit));
            stb.append("[");
            stb.append(this.voc.valueToString(middleLit));
            stb.append("]");
            stb.append(" ");
            ++n2;
        }
        stb.append(Lits.toString(this.tail));
        stb.append("[");
        stb.append(this.voc.valueToString(this.tail));
        stb.append("]");
        return stb.toString();
    }

    public int get(int i) {
        if (i == 0) {
            return this.head;
        }
        if (i == this.middleLits.length + 1) {
            return this.tail;
        }
        return this.middleLits[i - 1];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.middleLits.length + 2;
    }

    public void assertConstraint(UnitPropagationListener s) {
        assert (this.voc.isUnassigned(this.head));
        boolean ret = s.enqueue(this.head, this);
        assert (ret);
    }

    public void assertConstraintIfNeeded(UnitPropagationListener s) {
        if (this.voc.isFalsified(this.tail)) {
            boolean ret = s.enqueue(this.head, this);
            assert (ret);
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.middleLits, 0, tmp, 1, this.middleLits.length);
        tmp[0] = this.head;
        tmp[tmp.length - 1] = this.tail;
        return tmp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            HTClause wcl = (HTClause)obj;
            if (wcl.head != this.head || wcl.tail != this.tail) {
                return false;
            }
            if (this.middleLits.length != wcl.middleLits.length) {
                return false;
            }
            int[] nArray = this.middleLits;
            int n = this.middleLits.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int lit = nArray[n2];
                boolean ok = false;
                int[] nArray2 = wcl.middleLits;
                int n3 = wcl.middleLits.length;
                int n4 = 0;
                while (n4 < n3) {
                    int lit2 = nArray2[n4];
                    if (lit == lit2) {
                        ok = true;
                        break;
                    }
                    ++n4;
                }
                if (!ok) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long sum = this.head + this.tail;
        int[] nArray = this.middleLits;
        int n = this.middleLits.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            sum += (long)p;
            ++n2;
        }
        return (int)sum / this.middleLits.length;
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int p, IVecInt trail, IVecInt outReason) {
        this.calcReason(p, outReason);
    }
}

