/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.time.Duration;
import org.eclipse.swt.widgets.Display;

public class Throttler {
    private final Runnable timerExec;
    private final Display display;
    private volatile boolean scheduled;

    public Throttler(Display display, Duration minWaitTime, Runnable runnable) {
        this.display = display;
        if (minWaitTime.isNegative()) {
            throw new IllegalArgumentException("Minimum wait time must be positive");
        }
        if (minWaitTime.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Minimum wait time must be smaller than 2147483647");
        }
        int minWaitBetweenRunMillis = (int)minWaitTime.toMillis();
        this.timerExec = () -> {
            if (!display.isDisposed()) {
                display.timerExec(minWaitBetweenRunMillis, () -> {
                    this.scheduled = false;
                    runnable.run();
                });
            }
        };
    }

    public void throttledExec() {
        if (!this.scheduled && !this.display.isDisposed()) {
            this.scheduled = true;
            if (Thread.currentThread() == this.display.getThread()) {
                this.timerExec.run();
            } else {
                this.display.asyncExec(this.timerExec);
            }
        }
    }
}

