/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private static final String DEBUG_PREFIX = "certificate checker";
    private Map<IArtifactDescriptor, File> artifacts = new HashMap<IArtifactDescriptor, File>();
    private final IProvisioningAgent agent;

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new HashMap<IArtifactDescriptor, File>();
    }

    public IStatus start() {
        BundleContext context = EngineActivator.getContext();
        ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            IStatus iStatus = this.checkCertificates(verifierFactory);
            return iStatus;
        }
        finally {
            context.ungetService(contentFactoryRef);
        }
    }

    private IStatus checkCertificates(SignedContentFactory verifierFactory) {
        Certificate[][] unTrustedCertificateChains;
        StringBuilder message;
        int n2;
        int n3;
        Object[] objectArray;
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.class);
        ArrayList<Certificate> untrustedCertificates = new ArrayList<Certificate>();
        HashMap<IArtifactDescriptor, Collection> untrustedPGPArtifacts = new HashMap<IArtifactDescriptor, Collection>();
        HashMap untrustedPGPKeys = new HashMap();
        HashMap<IArtifactDescriptor, Iterator<Object>> unsigned = new HashMap<IArtifactDescriptor, Iterator<Object>>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        HashMap<Certificate, Collection> untrustedArtifacts = new HashMap<Certificate, Collection>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.isEmpty() || serviceUI == null) {
            return status;
        }
        for (Map.Entry<IArtifactDescriptor, File> artifact : this.artifacts.entrySet()) {
            Iterator<Object> artifactFile = artifact.getValue();
            try {
                SignedContent content = verifierFactory.getSignedContent((File)((Object)artifactFile));
                if (content.isSigned()) {
                    SignerInfo[] signerInfo = content.getSignerInfos();
                    if (!Arrays.stream(signerInfo).noneMatch(SignerInfo::isTrusted)) continue;
                    objectArray = signerInfo;
                    n3 = signerInfo.length;
                    n2 = 0;
                    while (n2 < n3) {
                        SignerInfo element = objectArray[n2];
                        if (!element.isTrusted()) {
                            Certificate[] certificateChain = element.getCertificateChain();
                            if (!untrustedCertificates.contains(certificateChain[0])) {
                                untrustedCertificates.add(certificateChain[0]);
                                untrustedChain.add(certificateChain);
                            }
                            if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED) {
                                untrustedArtifacts.computeIfAbsent(certificateChain[0], key -> new ArrayList()).add(artifactFile);
                            }
                        }
                        ++n2;
                    }
                    continue;
                }
                Collection signers = PGPSignatureVerifier.getSigners((IArtifactDescriptor)artifact.getKey());
                if (!signers.isEmpty()) {
                    if (!signers.stream().noneMatch(this::isTrusted)) continue;
                    untrustedPGPArtifacts.putIfAbsent(artifact.getKey(), signers);
                    signers.forEach(signer -> {
                        boolean bl = untrustedPGPKeys.computeIfAbsent(new PGPPublicKeyEntry((PGPPublicKey)signer), key -> new HashSet()).add((IArtifactDescriptor)artifact.getKey());
                    });
                    continue;
                }
                unsigned.put(artifact.getKey(), artifactFile);
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNSIGNED && !unsigned.isEmpty()) {
            message = new StringBuilder("The following artifacts are unsigned:\n");
            for (File file : unsigned.values()) {
                message.append(NLS.bind((String)"  {0}\n", (Object)file.getPath()));
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedCertificates.isEmpty()) {
            message = new StringBuilder("The following certificates are untrusted:\n");
            for (Certificate certificate : untrustedArtifacts.keySet()) {
                message.append(String.valueOf(certificate.toString()) + "\n");
                message.append("  used by the following artifacts:\n");
                for (File file : (Collection)untrustedArtifacts.get(certificate)) {
                    message.append(NLS.bind((String)"    {0}\n", (Object)file.getPath()));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedPGPKeys.isEmpty()) {
            message = new StringBuilder("The following PGP Keys are untrusted:\n");
            for (Map.Entry entry2 : untrustedPGPKeys.entrySet()) {
                message.append(String.valueOf(((PGPPublicKeyEntry)entry2.getKey()).key.getKeyID()) + "\n");
                message.append("  used by the following artifacts:\n");
                for (IArtifactDescriptor artifact : (Collection)entry2.getValue()) {
                    message.append(NLS.bind((String)"    {0}\n", (Object)artifact.getArtifactKey()));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        String policy = this.getUnsignedContentPolicy();
        if (!unsigned.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsigned));
        }
        String[] stringArray = "allow".equals(policy) || unsigned.isEmpty() ? null : (String[])unsigned.values().stream().map(Object::toString).toArray(String[]::new);
        Certificate[][] certificateArray = unTrustedCertificateChains = untrustedCertificates.isEmpty() ? null : (Certificate[][])untrustedChain.toArray(n -> new Certificate[n][]);
        if (stringArray == null && unTrustedCertificateChains == null && untrustedPGPArtifacts.isEmpty()) {
            return status;
        }
        UIServices.TrustInfo trustInfo = serviceUI.getTrustInfo(unTrustedCertificateChains, (Collection)untrustedPGPKeys.keySet().stream().map(entry -> entry.key).collect(Collectors.toUnmodifiableList()), stringArray);
        if (!unsigned.isEmpty() && !trustInfo.trustUnsignedContent()) {
            return Status.CANCEL_STATUS;
        }
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        if (unTrustedCertificateChains != null && trustedCertificates == null) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustedCertificates != null) {
            objectArray = trustedCertificates;
            n3 = trustedCertificates.length;
            n2 = 0;
            while (n2 < n3) {
                SignerInfo trustedCertificate = objectArray[n2];
                untrustedCertificates.remove(trustedCertificate);
                ++n2;
            }
        }
        Collection trustedPGPKeys = trustInfo.getTrustedPGPKeys();
        untrustedPGPArtifacts.values().removeIf(pgpKeys -> !Collections.disjoint(pgpKeys, trustedPGPKeys));
        trustedPGPKeys.stream().map(PGPPublicKeyEntry::new).forEach(untrustedPGPKeys::remove);
        if (!untrustedCertificates.isEmpty() || !untrustedPGPKeys.isEmpty()) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustInfo.persistTrust()) {
            return this.persistTrustedCertificates(trustedCertificates);
        }
        return status;
    }

    /*
     * Loose catch block
     */
    private IStatus persistTrustedCertificates(Certificate[] trustedCertificates) {
        if (trustedCertificates == null) {
            return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        ServiceTracker trustEngineTracker = new ServiceTracker(EngineActivator.getContext(), TrustEngine.class, null);
        trustEngineTracker.open();
        Object[] trustEngines = trustEngineTracker.getServices();
        try {
            if (trustEngines == null) {
                return null;
            }
            Certificate[] certificateArray = trustedCertificates;
            int n = trustedCertificates.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate trustedCertificate = certificateArray[n2];
                Object[] objectArray = trustEngines;
                int n3 = trustEngines.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object engine = objectArray[n4];
                    TrustEngine trustEngine = (TrustEngine)engine;
                    if (!trustEngine.isReadOnly()) {
                        try {
                            trustEngine.addTrustAnchor(trustedCertificate, trustedCertificate.toString());
                            break;
                        }
                        catch (IOException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                        catch (GeneralSecurityException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                    }
                    ++n4;
                }
                ++n2;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            trustEngineTracker.close();
        }
        return Status.OK_STATUS;
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void add(Map<IArtifactDescriptor, File> toAdd) {
        this.artifacts.putAll(toAdd);
    }

    private boolean isTrusted(PGPPublicKey pgppublickey) {
        return false;
    }

    private static class PGPPublicKeyEntry {
        public final PGPPublicKey key;

        public PGPPublicKeyEntry(PGPPublicKey key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PGPPublicKeyEntry)) {
                return false;
            }
            return this.key.getKeyID() == ((PGPPublicKeyEntry)obj).key.getKeyID();
        }

        public int hashCode() {
            return Long.hashCode(this.key.getKeyID());
        }
    }
}

