/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.UserValidationDialog;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.internal.provisional.security.ui.X509CertificateViewDialog;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.p2.core.DelegatingUIServices;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class P2ServiceUI
extends DelegatingUIServices {
    public UIServices.AuthenticationInfo getUsernamePassword(final String location) {
        UIServices delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getUsernamePassword(location);
        }
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication()) {
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String message = NLS.bind((String)ProvUIMessages.ServiceUI_LoginDetails, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(P2ServiceUI.this.getShell(), ProvUIMessages.ServiceUI_LoginRequired, null, message);
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    public UIServices.AuthenticationInfo getUsernamePassword(final String location, final UIServices.AuthenticationInfo previousInfo) {
        Shell shell;
        UIServices delegate = this.getDelegate();
        if (delegate != null) {
            delegate.getUsernamePassword(location);
        }
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && (shell = this.getShell()) != null) {
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String message = null;
                    message = previousInfo.saveResult() ? NLS.bind((String)ProvUIMessages.ProvUIMessages_SavedNotAccepted_EnterFor_0, (Object)location) : NLS.bind((String)ProvUIMessages.ProvUIMessages_NotAccepted_EnterFor_0, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(previousInfo, shell, ProvUIMessages.ServiceUI_LoginRequired, null, message);
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    private boolean suppressAuthentication() {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            return job.getProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER) != null;
        }
        return false;
    }

    public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, final String[] unsignedDetail) {
        boolean trustUnsigned = true;
        boolean persistTrust = false;
        Certificate[] trusted = new Certificate[]{};
        final Shell shell = this.getShell();
        if (shell != null && unsignedDetail != null && unsignedDetail.length > 0) {
            final boolean[] result = new boolean[1];
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    OkCancelErrorDialog dialog = new OkCancelErrorDialog(shell, ProvUIMessages.ServiceUI_warning_title, null, this.createStatus(), 2);
                    result[0] = dialog.open() == 0;
                }

                private IStatus createStatus() {
                    MultiStatus parent = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ServiceUI_unsigned_message, null);
                    int i = 0;
                    while (i < unsignedDetail.length) {
                        parent.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui", unsignedDetail[i]));
                        ++i;
                    }
                    return parent;
                }
            });
            trustUnsigned = result[0];
        }
        if (!trustUnsigned) {
            return new CertificateConfirmer.TrustInfoWithPolicy(trusted, persistTrust, trustUnsigned, false);
        }
        final AtomicBoolean remember = new AtomicBoolean();
        final AtomicBoolean always = new AtomicBoolean();
        if (shell != null && untrustedChains != null && untrustedChains.length > 0) {
            final Object[] result = new Object[1];
            final TreeNode[] input = this.createTreeNodes(untrustedChains);
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    CertificateLabelProvider labelProvider = new CertificateLabelProvider();
                    TreeNodeContentProvider contentProvider = new TreeNodeContentProvider();
                    TrustCertificateDialog trustCertificateDialog = new TrustCertificateDialog(shell, input, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider){

                        protected void configureShell(Shell shell) {
                            Layout layout;
                            Image[] defaultImages = 1.getDefaultImages();
                            if (defaultImages.length > 0) {
                                ArrayList<Image> nonDisposedImages = new ArrayList<Image>(defaultImages.length);
                                Image[] imageArray = defaultImages;
                                int n = defaultImages.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Image defaultImage = imageArray[n2];
                                    if (defaultImage != null && !defaultImage.isDisposed()) {
                                        nonDisposedImages.add(defaultImage);
                                    }
                                    ++n2;
                                }
                                if (!nonDisposedImages.isEmpty()) {
                                    Image[] array = new Image[nonDisposedImages.size()];
                                    nonDisposedImages.toArray(array);
                                    shell.setImages(array);
                                }
                            }
                            if ((layout = this.getLayout()) != null) {
                                shell.setLayout(layout);
                            }
                            shell.setText(ProvUIMessages.TrustCertificateDialog_Title);
                        }

                        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                            if (18 == id) {
                                ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
                                ++((GridLayout)parent.getLayout()).numColumns;
                                final Button rememberButton = new Button(parent, 32);
                                rememberButton.setText(Messages.P2ServiceUI_certs_rememberAccepted);
                                rememberButton.setFont(JFaceResources.getDialogFont());
                                GridData data = new GridData(768);
                                rememberButton.setLayoutData((Object)data);
                                rememberButton.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        remember.set(rememberButton.getSelection());
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                        remember.set(rememberButton.getSelection());
                                    }
                                });
                            } else if (id == 0) {
                                ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
                                ++((GridLayout)parent.getLayout()).numColumns;
                                final Button alwaysButton = new Button(parent, 32);
                                alwaysButton.setText(Messages.P2ServiceUI_certs_alwaysAccept);
                                alwaysButton.setFont(JFaceResources.getDialogFont());
                                GridData data = new GridData(768);
                                alwaysButton.setLayoutData((Object)data);
                                alwaysButton.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        always.set(alwaysButton.getSelection());
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                        always.set(alwaysButton.getSelection());
                                    }
                                });
                            }
                            return super.createButton(parent, id, label, defaultButton);
                        }
                    };
                    trustCertificateDialog.open();
                    Object[] dialogResult = trustCertificateDialog.getResult();
                    Certificate[] values = new Certificate[dialogResult == null ? 0 : dialogResult.length];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = (Certificate)((TreeNode)dialogResult[i]).getValue();
                        ++i;
                    }
                    result[0] = values;
                }
            });
            trusted = (Certificate[])result[0];
        }
        return new CertificateConfirmer.TrustInfoWithPolicy(trusted, remember.get(), trustUnsigned, always.get());
    }

    private TreeNode[] createTreeNodes(Certificate[][] certificates) {
        TreeNode[] children = new TreeNode[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            TreeNode head;
            TreeNode parent = head = new TreeNode((Object)certificates[i][0]);
            children[i] = head;
            int j = 0;
            while (j < certificates[i].length) {
                TreeNode node = new TreeNode((Object)certificates[i][j]);
                node.setParent(parent);
                parent.setChildren(new TreeNode[]{node});
                parent = node;
                ++j;
            }
            ++i;
        }
        return children;
    }

    protected Shell getShell() {
        try {
            final Shell shell = UIUtil.getShell();
            final Shell[] result = new Shell[]{shell};
            if (shell != null) {
                UIUtil.syncExec((Control)shell, (Runnable)new Runnable(){

                    public void run() {
                        Composite parent = shell.getParent();
                        while (parent != null) {
                            if (parent instanceof Shell) {
                                result[0] = (Shell)parent;
                            }
                            parent = parent.getParent();
                        }
                        Shell[] shellArray = result[0].getShells();
                        int n = shellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell child = shellArray[n2];
                            if (child.isVisible() && child.getData() instanceof Dialog) {
                                result[0] = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                });
            }
            return result[0];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    static class OkCancelErrorDialog
    extends ErrorDialog {
        public OkCancelErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }

    private static class TrustCertificateDialog
    extends SelectionDialog {
        private Object inputElement;
        private IStructuredContentProvider contentProvider;
        private ILabelProvider labelProvider;
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
        CheckboxTableViewer listViewer;
        private TreeViewer certificateChainViewer;
        private Button detailsButton;
        protected TreeNode parentElement;
        protected Object selectedCertificate;

        public TrustCertificateDialog(Shell parentShell, Object input, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parentShell);
            this.inputElement = input;
            this.contentProvider = contentProvider;
            this.labelProvider = labelProvider;
            this.setTitle(ProvUIMessages.TrustCertificateDialog_Title);
            this.setMessage(ProvUIMessages.TrustCertificateDialog_Message);
            this.setShellStyle(0x870 | TrustCertificateDialog.getDefaultOrientation());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = this.createUpperDialogArea(parent);
            this.certificateChainViewer = new TreeViewer(composite, 2048);
            GridLayout layout = new GridLayout();
            this.certificateChainViewer.getTree().setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            this.certificateChainViewer.getTree().setLayoutData((Object)data);
            this.certificateChainViewer.setAutoExpandLevel(-1);
            this.certificateChainViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
            this.certificateChainViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
            this.certificateChainViewer.addSelectionChangedListener(this.getChainSelectionListener());
            if (this.inputElement instanceof Object[]) {
                StructuredSelection selection = null;
                Object[] nodes = (Object[])this.inputElement;
                if (nodes.length > 0) {
                    selection = new StructuredSelection(nodes[0]);
                    this.certificateChainViewer.setInput((Object)new TreeNode[]{(TreeNode)nodes[0]});
                    this.selectedCertificate = nodes[0];
                }
                this.listViewer.setSelection(selection);
            }
            this.listViewer.addDoubleClickListener(this.getDoubleClickListener());
            this.listViewer.addSelectionChangedListener(this.getParentSelectionListener());
            this.createButtons(composite);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, ProvUIMessages.TrustCertificateDialog_AcceptSelectedButtonLabel, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            super.getOkButton().setEnabled(false);
        }

        private void createButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 0);
            buttonComposite.setLayout((Layout)new RowLayout());
            this.detailsButton = new Button(buttonComposite, 0);
            this.detailsButton.setText(ProvUIMessages.TrustCertificateDialog_Details);
            this.detailsButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    Object o = TrustCertificateDialog.this.selectedCertificate;
                    if (TrustCertificateDialog.this.selectedCertificate instanceof TreeNode) {
                        o = ((TreeNode)TrustCertificateDialog.this.selectedCertificate).getValue();
                    }
                    if (o instanceof X509Certificate) {
                        X509Certificate cert = (X509Certificate)o;
                        X509CertificateViewDialog certificateDialog = new X509CertificateViewDialog(TrustCertificateDialog.this.getShell(), cert);
                        certificateDialog.open();
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
            Button exportButton = new Button(buttonComposite, 0);
            exportButton.setText(ProvUIMessages.TrustCertificateDialog_Export);
            exportButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    block9: {
                        Object o = TrustCertificateDialog.this.selectedCertificate;
                        if (TrustCertificateDialog.this.selectedCertificate instanceof TreeNode) {
                            o = ((TreeNode)TrustCertificateDialog.this.selectedCertificate).getValue();
                        }
                        if (o instanceof X509Certificate) {
                            X509Certificate cert = (X509Certificate)o;
                            FileDialog destination = new FileDialog(TrustCertificateDialog.this.detailsButton.getShell(), 8192);
                            destination.setFilterExtensions(new String[]{"*.der"});
                            destination.setText(ProvUIMessages.TrustCertificateDialog_Export);
                            String path = destination.open();
                            if (path == null) {
                                return;
                            }
                            File destinationFile = new File(path);
                            FileOutputStream output = null;
                            try {
                                output = new FileOutputStream(destinationFile);
                                output.write(cert.getEncoded());
                            }
                            catch (IOException ex) {
                                ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                                IOUtil.closeSilent((Closeable)output);
                                break block9;
                            }
                            catch (CertificateEncodingException ex) {
                                try {
                                    ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                                }
                                catch (Throwable throwable) {
                                    IOUtil.closeSilent(output);
                                    throw throwable;
                                }
                                IOUtil.closeSilent((Closeable)output);
                                break block9;
                            }
                            IOUtil.closeSilent((Closeable)output);
                        }
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }

        private Composite createUpperDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)composite);
            this.createMessageArea(composite);
            this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            GridData data = new GridData(1808);
            data.heightHint = 250;
            data.widthHint = 300;
            this.listViewer.getTable().setLayoutData((Object)data);
            this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.addSelectionButtons(composite);
            this.listViewer.setInput(this.inputElement);
            if (!this.getInitialElementSelections().isEmpty()) {
                this.checkInitialSelections();
            }
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void checkInitialSelections() {
            Iterator itemsToCheck = this.getInitialElementSelections().iterator();
            while (itemsToCheck.hasNext()) {
                this.listViewer.setChecked(itemsToCheck.next(), true);
            }
        }

        private void addSelectionButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
            Button selectButton = this.createButton(buttonComposite, 18, ProvUIMessages.TrustCertificateDialog_SelectAll, false);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TrustCertificateDialog.this.listViewer.setAllChecked(true);
                    TrustCertificateDialog.this.getOkButton().setEnabled(true);
                }
            };
            selectButton.addSelectionListener((SelectionListener)listener);
            Button deselectButton = this.createButton(buttonComposite, 19, ProvUIMessages.TrustCertificateDialog_DeselectAll, false);
            listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TrustCertificateDialog.this.listViewer.setAllChecked(false);
                    TrustCertificateDialog.this.getOkButton().setEnabled(false);
                }
            };
            deselectButton.addSelectionListener((SelectionListener)listener);
        }

        private ISelectionChangedListener getChainSelectionListener() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection) {
                        TrustCertificateDialog.this.selectedCertificate = ((StructuredSelection)selection).getFirstElement();
                    }
                }
            };
        }

        public TreeViewer getCertificateChainViewer() {
            return this.certificateChainViewer;
        }

        private IDoubleClickListener getDoubleClickListener() {
            return new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    Object selectedElement = selection.getFirstElement();
                    if (selectedElement instanceof TreeNode) {
                        TreeNode treeNode = (TreeNode)selectedElement;
                        X509CertificateViewDialog certificateViewDialog = new X509CertificateViewDialog(TrustCertificateDialog.this.getShell(), (X509Certificate)treeNode.getValue());
                        certificateViewDialog.open();
                    }
                }
            };
        }

        private ISelectionChangedListener getParentSelectionListener() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection) {
                        TreeNode firstElement = (TreeNode)((StructuredSelection)selection).getFirstElement();
                        TrustCertificateDialog.this.getCertificateChainViewer().setInput((Object)new TreeNode[]{firstElement});
                        TrustCertificateDialog.this.getOkButton().setEnabled(TrustCertificateDialog.this.listViewer.getChecked((Object)firstElement));
                        TrustCertificateDialog.this.getCertificateChainViewer().refresh();
                    }
                }
            };
        }

        protected void okPressed() {
            Object[] children = this.contentProvider.getElements(this.inputElement);
            if (children != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (this.listViewer.getChecked(element)) {
                        list.add(element);
                    }
                    ++n2;
                }
                this.setResult(list);
            }
            super.okPressed();
        }
    }
}

