/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.newresource;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class BasicNewResourceWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;

    protected BasicNewResourceWizard() {
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void init(IWorkbench theWorkbench, IStructuredSelection currentSelection) {
        this.workbench = theWorkbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/new_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal(newResource, this.getWorkbench().getActiveWorkbenchWindow());
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        IViewReference ref;
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ref = iViewReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++n2;
        }
        iViewReferenceArray = page.getEditorReferences();
        n = iViewReferenceArray.length;
        n2 = 0;
        while (n2 < n) {
            ref = iViewReferenceArray[n2];
            if (ref.getPart(false) != null) {
                parts.add(ref.getPart(false));
            }
            ++n2;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = (ISetSelectionTarget)Adapters.adapt((Object)part, ISetSelectionTarget.class);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(() -> BasicNewResourceWizard.lambda$0(finalTarget, (ISelection)selection));
        }
    }

    private static /* synthetic */ void lambda$0(ISetSelectionTarget iSetSelectionTarget, ISelection iSelection) {
        iSetSelectionTarget.selectReveal(iSelection);
    }
}

