/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;

public class ContentFormatter
implements IContentFormatter {
    private static final String PARTITIONING = "__formatter_partitioning";
    private Map<String, IFormattingStrategy> fStrategies;
    private boolean fIsPartitionAware = true;
    private String[] fPartitionManagingCategories;
    private List<PositionReference> fOverlappingPositionReferences;
    private IPositionUpdater fPartitioningUpdater;
    private String fPartitioning = "__dftl_partitioning";
    private IDocument fDocument;
    private String[] fExternalPartitonManagingCategories;
    private boolean fNeedsComputation = true;

    public void setFormattingStrategy(IFormattingStrategy strategy, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap<String, IFormattingStrategy>();
        }
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
        }
    }

    @Deprecated
    public void setPartitionManagingPositionCategories(String[] categories) {
        this.fExternalPartitonManagingCategories = TextUtilities.copy((String[])categories);
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public void enablePartitionAwareFormatting(boolean enable) {
        this.fIsPartitionAware = enable;
    }

    @Override
    public IFormattingStrategy getFormattingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return this.fStrategies.get(contentType);
    }

    @Override
    public void format(IDocument document, IRegion region) {
        this.fNeedsComputation = true;
        this.fDocument = document;
        try {
            if (this.fIsPartitionAware) {
                this.formatPartitions(region);
            } else {
                this.formatRegion(region);
            }
        }
        finally {
            this.fNeedsComputation = true;
            this.fDocument = null;
        }
    }

    private void formatPartitions(IRegion region) {
        this.addPartitioningUpdater();
        try {
            TypedPosition[] ranges = this.getPartitioning(region);
            if (ranges != null) {
                this.start(ranges, this.getIndentation(region.getOffset()));
                this.format(ranges);
                this.stop(ranges);
            }
        }
        catch (BadLocationException badLocationException) {}
        this.removePartitioningUpdater();
    }

    private void formatRegion(IRegion region) {
        IFormattingStrategy strategy = this.getFormattingStrategy("__dftl_partition_content_type");
        if (strategy != null) {
            strategy.formatterStarts(this.getIndentation(region.getOffset()));
            this.format(strategy, new TypedPosition(region.getOffset(), region.getLength(), "__dftl_partition_content_type"));
            strategy.formatterStops();
        }
    }

    private TypedPosition[] getPartitioning(IRegion region) throws BadLocationException {
        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)this.fPartitioning, (int)region.getOffset(), (int)region.getLength(), (boolean)false);
        TypedPosition[] positions = new TypedPosition[regions.length];
        int i = 0;
        while (i < regions.length) {
            positions[i] = new TypedPosition(regions[i]);
            try {
                this.fDocument.addPosition(PARTITIONING, (Position)positions[i]);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++i;
        }
        return positions;
    }

    private void start(TypedPosition[] regions, String indentation) {
        TypedPosition[] typedPositionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            TypedPosition region = typedPositionArray[n2];
            IFormattingStrategy s = this.getFormattingStrategy(region.getType());
            if (s != null) {
                s.formatterStarts(indentation);
            }
            ++n2;
        }
    }

    private void format(TypedPosition[] ranges) {
        TypedPosition[] typedPositionArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            TypedPosition range = typedPositionArray[n2];
            IFormattingStrategy s = this.getFormattingStrategy(range.getType());
            if (s != null) {
                this.format(s, range);
            }
            ++n2;
        }
    }

    private void format(IFormattingStrategy strategy, TypedPosition region) {
        try {
            int offset = region.getOffset();
            int length = region.getLength();
            String content = this.fDocument.get(offset, length);
            int[] positions = this.getAffectedPositions(offset, length);
            String formatted = strategy.format(content, this.isLineStart(offset), this.getIndentation(offset), positions);
            if (formatted != null && !formatted.equals(content)) {
                RemoveAffectedPositions first = new RemoveAffectedPositions();
                this.fDocument.insertPositionUpdater((IPositionUpdater)first, 0);
                UpdateAffectedPositions last = new UpdateAffectedPositions(positions, offset);
                this.fDocument.addPositionUpdater((IPositionUpdater)last);
                this.fDocument.replace(offset, length, formatted);
                this.fDocument.removePositionUpdater((IPositionUpdater)first);
                this.fDocument.removePositionUpdater((IPositionUpdater)last);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void stop(TypedPosition[] regions) {
        TypedPosition[] typedPositionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            TypedPosition region = typedPositionArray[n2];
            IFormattingStrategy s = this.getFormattingStrategy(region.getType());
            if (s != null) {
                s.formatterStops();
            }
            ++n2;
        }
    }

    private void addPartitioningUpdater() {
        this.fPartitioningUpdater = new NonDeletingPositionUpdater(PARTITIONING);
        this.fDocument.addPositionCategory(PARTITIONING);
        this.fDocument.addPositionUpdater(this.fPartitioningUpdater);
    }

    private void removePartitioningUpdater() {
        try {
            this.fDocument.removePositionUpdater(this.fPartitioningUpdater);
            this.fDocument.removePositionCategory(PARTITIONING);
            this.fPartitioningUpdater = null;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    private String[] getPartitionManagingCategories() {
        if (this.fNeedsComputation) {
            this.fNeedsComputation = false;
            this.fPartitionManagingCategories = TextUtilities.computePartitionManagingCategories((IDocument)this.fDocument);
            if (this.fPartitionManagingCategories == null) {
                this.fPartitionManagingCategories = this.fExternalPartitonManagingCategories;
            }
        }
        return this.fPartitionManagingCategories;
    }

    private boolean ignoreCategory(String category) {
        if (PARTITIONING.equals(category)) {
            return true;
        }
        String[] categories = this.getPartitionManagingCategories();
        if (categories != null) {
            String[] stringArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (cat.equals(category)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void determinePositionsToUpdate(int offset, int length) {
        String[] categories = this.fDocument.getPositionCategories();
        if (categories != null) {
            String[] stringArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (!this.ignoreCategory(cat)) {
                    try {
                        Position[] positions;
                        Position[] positionArray = positions = this.fDocument.getPositions(cat);
                        int n3 = positions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Position p = positionArray[n4];
                            if (p.overlapsWith(offset, length)) {
                                if (offset < p.getOffset()) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, true, cat));
                                }
                                if (p.getOffset() + p.getLength() < offset + length) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, false, cat));
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
                ++n2;
            }
        }
    }

    private int[] getAffectedPositions(int offset, int length) {
        this.fOverlappingPositionReferences = new ArrayList<PositionReference>();
        this.determinePositionsToUpdate(offset, length);
        Collections.sort(this.fOverlappingPositionReferences);
        int[] positions = new int[this.fOverlappingPositionReferences.size()];
        int i = 0;
        while (i < positions.length) {
            PositionReference r = this.fOverlappingPositionReferences.get(i);
            positions[i] = r.getCharacterPosition() - offset;
            ++i;
        }
        return positions;
    }

    private void removeAffectedPositions(IDocument document) {
        int size = this.fOverlappingPositionReferences.size();
        int i = 0;
        while (i < size) {
            PositionReference r = this.fOverlappingPositionReferences.get(i);
            try {
                document.removePosition(r.getCategory(), r.getPosition());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++i;
        }
    }

    protected void updateAffectedPositions(IDocument document, int[] positions, int offset) {
        if (document != this.fDocument) {
            return;
        }
        if (positions.length == 0) {
            return;
        }
        int i = 0;
        while (i < positions.length) {
            PositionReference r = this.fOverlappingPositionReferences.get(i);
            if (r.refersToOffset()) {
                r.setOffset(offset + positions[i]);
            } else {
                r.setLength(offset + positions[i] - r.getOffset());
            }
            Position p = r.getPosition();
            String category = r.getCategory();
            if (!document.containsPosition(category, p.offset, p.length)) {
                try {
                    if (this.positionAboutToBeAdded(document, category, p)) {
                        document.addPosition(r.getCategory(), p);
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
            }
            ++i;
        }
        this.fOverlappingPositionReferences = null;
    }

    protected boolean positionAboutToBeAdded(IDocument document, String category, Position position) {
        return true;
    }

    private String getIndentation(int offset) {
        try {
            int start = this.fDocument.getLineOfOffset(offset);
            int end = start = this.fDocument.getLineOffset(start);
            char c = this.fDocument.getChar(end);
            while ('\t' == c || ' ' == c) {
                c = this.fDocument.getChar(++end);
            }
            return this.fDocument.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean isLineStart(int offset) throws BadLocationException {
        int start = this.fDocument.getLineOfOffset(offset);
        return (start = this.fDocument.getLineOffset(start)) == offset;
    }

    class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        protected NonDeletingPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }
    }

    static class PositionReference
    implements Comparable<PositionReference> {
        protected Position fPosition;
        protected boolean fRefersToOffset;
        protected String fCategory;

        protected PositionReference(Position position, boolean refersToOffset, String category) {
            this.fPosition = position;
            this.fRefersToOffset = refersToOffset;
            this.fCategory = category;
        }

        protected int getOffset() {
            return this.fPosition.getOffset();
        }

        protected void setOffset(int offset) {
            this.fPosition.setOffset(offset);
        }

        protected int getLength() {
            return this.fPosition.getLength();
        }

        protected void setLength(int length) {
            this.fPosition.setLength(length);
        }

        protected boolean refersToOffset() {
            return this.fRefersToOffset;
        }

        protected String getCategory() {
            return this.fCategory;
        }

        protected Position getPosition() {
            return this.fPosition;
        }

        protected int getCharacterPosition() {
            if (this.fRefersToOffset) {
                return this.getOffset();
            }
            return this.getOffset() + this.getLength();
        }

        @Override
        public int compareTo(PositionReference r) {
            return this.getCharacterPosition() - r.getCharacterPosition();
        }
    }

    class RemoveAffectedPositions
    implements IPositionUpdater {
        RemoveAffectedPositions() {
        }

        public void update(DocumentEvent event) {
            ContentFormatter.this.removeAffectedPositions(event.getDocument());
        }
    }

    class UpdateAffectedPositions
    implements IPositionUpdater {
        private int[] fPositions;
        private int fOffset;

        public UpdateAffectedPositions(int[] positions, int offset) {
            this.fPositions = positions;
            this.fOffset = offset;
        }

        public void update(DocumentEvent event) {
            ContentFormatter.this.updateAffectedPositions(event.getDocument(), this.fPositions, this.fOffset);
        }
    }
}

