/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileContainer;
import org.eclipse.oomph.p2.core.ProfileCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileCreatorImpl
extends HashMap<String, String>
implements ProfileCreator {
    private static final long serialVersionUID = 1L;
    private final ProfileContainer container;
    private final String profileID;
    private final String profileType;

    public ProfileCreatorImpl(ProfileContainer container, String profileID, String profileType) {
        this.container = container;
        this.profileID = profileID;
        this.profileType = profileType;
    }

    @Override
    public ProfileContainer getContainer() {
        return this.container;
    }

    @Override
    public String getProfileID() {
        return this.profileID;
    }

    public String getProfileType() {
        return this.profileType;
    }

    @Override
    public boolean is(String property) {
        return "true".equals(this.get(property));
    }

    @Override
    public File getFile(String property) {
        String value = (String)this.get(property);
        if (value != null) {
            return new File(value);
        }
        return null;
    }

    @Override
    public ProfileCreator setFile(String property, File value) {
        if (value != null) {
            this.put(property, value.getAbsolutePath());
        } else {
            this.remove(property);
        }
        return this;
    }

    @Override
    public ProfileCreator set(String property, boolean value) {
        return this.set(property, value ? "true" : null);
    }

    @Override
    public ProfileCreator set(String property, String value) {
        if (value != null) {
            this.put(property, value);
        } else {
            this.remove(property);
        }
        return this;
    }

    @Override
    public File getReferencer() {
        return this.getFile("org.eclipse.oomph.p2.profile.referencer");
    }

    @Override
    public ProfileCreator setReferencer(File value) {
        return this.setFile("org.eclipse.oomph.p2.profile.referencer", value);
    }

    @Override
    public File getConfigurationFolder() {
        return this.getFile("org.eclipse.equinox.p2.configurationFolder");
    }

    @Override
    public ProfileCreator setConfigurationFolder(File value) {
        return this.setFile("org.eclipse.equinox.p2.configurationFolder", value);
    }

    @Override
    public File getCacheFolder() {
        return this.getFile("org.eclipse.equinox.p2.cache");
    }

    @Override
    public ProfileCreator setCacheFolder(File value) {
        return this.setFile("org.eclipse.equinox.p2.cache", value);
    }

    @Override
    public File getInstallFolder() {
        return this.getFile("org.eclipse.equinox.p2.installFolder");
    }

    @Override
    public ProfileCreator setInstallFolder(File value) {
        return this.setFile("org.eclipse.equinox.p2.installFolder", value);
    }

    @Override
    public boolean isInstallFeatures() {
        return this.is("org.eclipse.update.install.features");
    }

    @Override
    public ProfileCreator setInstallFeatures(boolean value) {
        return this.set("org.eclipse.update.install.features", value);
    }

    @Override
    public boolean isRoaming() {
        return this.is("org.eclipse.equinox.p2.roaming");
    }

    @Override
    public ProfileCreator setRoaming(boolean value) {
        return this.set("org.eclipse.equinox.p2.roaming", value);
    }

    @Override
    public String getName() {
        return (String)this.get("org.eclipse.equinox.p2.name");
    }

    @Override
    public ProfileCreator setName(String value) {
        return this.set("org.eclipse.equinox.p2.name", value);
    }

    @Override
    public String getDescription() {
        return (String)this.get("org.eclipse.equinox.p2.description");
    }

    @Override
    public ProfileCreator setDescription(String value) {
        return this.set("org.eclipse.equinox.p2.description", value);
    }

    @Override
    public String getEnvironments() {
        return (String)this.get("org.eclipse.equinox.p2.environments");
    }

    @Override
    public ProfileCreator setEnvironments(String value) {
        return this.set("org.eclipse.equinox.p2.environments", value);
    }

    @Override
    public Map<String, Set<String>> getEnvironmentsMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String value = this.getEnvironments();
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int pos = token.indexOf(61);
                String k = token.substring(0, pos).trim();
                String v = token.substring(pos + 1).trim();
                HashSet<String> values = (HashSet<String>)map.get(k);
                if (values == null) {
                    values = new HashSet<String>();
                    map.put(k, values);
                }
                values.add(v);
            }
        }
        return map;
    }

    @Override
    public ProfileCreator setEnvironmentsMap(Map<String, Set<String>> map) {
        StringBuilder builder = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                String key = entry.getKey();
                Set<String> values = entry.getValue();
                if (values == null) continue;
                for (String value : values) {
                    if (builder.length() != 0) {
                        builder.append(',');
                    }
                    builder.append(key);
                    builder.append('=');
                    builder.append(value);
                }
            }
        }
        if (builder.length() != 0) {
            this.setEnvironments(builder.toString());
        } else {
            this.setEnvironments(null);
        }
        return this;
    }

    @Override
    public ProfileCreator addEnvironmentValue(String key, String value) {
        Map<String, Set<String>> map = this.getEnvironmentsMap();
        Set<String> values = map.get(key);
        if (values == null) {
            values = new HashSet<String>();
            map.put(key, values);
        }
        if (values.add(value)) {
            this.setEnvironmentsMap(map);
        }
        return this;
    }

    @Override
    public ProfileCreator removeEnvironmentValue(String key, String value) {
        Map<String, Set<String>> map = this.getEnvironmentsMap();
        Set<String> values = map.get(key);
        if (values != null && values.remove(value)) {
            this.setEnvironmentsMap(map);
        }
        return this;
    }

    @Override
    public ProfileCreator addOS(String value) {
        return this.addEnvironmentValue("osgi.os", value);
    }

    @Override
    public ProfileCreator removeOS(String value) {
        return this.removeEnvironmentValue("osgi.os", value);
    }

    @Override
    public ProfileCreator addWS(String value) {
        return this.addEnvironmentValue("osgi.ws", value);
    }

    @Override
    public ProfileCreator removeWS(String value) {
        return this.removeEnvironmentValue("osgi.ws", value);
    }

    @Override
    public ProfileCreator addArch(String value) {
        return this.addEnvironmentValue("osgi.arch", value);
    }

    @Override
    public ProfileCreator removeArch(String value) {
        return this.removeEnvironmentValue("osgi.arch", value);
    }

    @Override
    public String getLanguages() {
        return (String)this.get("org.eclipse.equinox.p2.nl");
    }

    @Override
    public ProfileCreator setLanguages(String value) {
        return this.set("org.eclipse.equinox.p2.nl", value);
    }

    @Override
    public Set<String> getLanguageSet() {
        HashSet<String> set = new HashSet<String>();
        String value = this.getLanguages();
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                set.add(token);
            }
        }
        return set;
    }

    @Override
    public ProfileCreator setLanguageSet(Set<String> set) {
        StringBuilder builder = new StringBuilder();
        if (set != null) {
            for (String value : set) {
                if (builder.length() != 0) {
                    builder.append(',');
                }
                builder.append(value);
            }
        }
        if (builder.length() != 0) {
            this.setLanguages(builder.toString());
        } else {
            this.setLanguages(null);
        }
        return this;
    }

    @Override
    public ProfileCreator addLanguage(String value) {
        Set<String> set = this.getLanguageSet();
        set.add(value);
        return this.setLanguageSet(set);
    }

    @Override
    public ProfileCreator removeLanguage(String value) {
        Set<String> set = this.getLanguageSet();
        set.remove(value);
        return this.setLanguageSet(set);
    }

    @Override
    public Profile create() {
        this.set("org.eclipse.oomph.p2.profile.type", this.profileType);
        return this.doCreateProfile();
    }

    protected abstract Profile doCreateProfile();
}

