/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.impl.RequirementImpl;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogGenerator
implements IApplication {
    private static final String JAVA_VERSION_PREFIX = "addJvmArg(jvmArg:-Dosgi.requiredJavaVersion=";
    private static final String PACKAGES = "http://download.eclipse.org/technology/epp/packages";
    private static final String HTTPS_PACKAGES = "https://download.eclipse.org/technology/epp/packages";
    private static final String RELEASES = "http://download.eclipse.org/releases";
    private static final String ICON_URL_PREFIX = "http://www.eclipse.org/downloads/images/";
    private static final URI PACKAGES_URI = URI.createURI((String)"https://www.eclipse.org/downloads/packages/release/");
    private static final URI ECLIPSE_PROJECT_URI = URI.createURI((String)"http://download.eclipse.org/eclipse/updates");
    private static final URI ECLIPSE_BRANDING_NOTIFICATION_URI = URI.createURI((String)"https://www.eclipse.org/setups/donate/?scope=${scope}&campaign=2020-09");
    private static final String ICON_DEFAULT = "http://www.eclipse.org/downloads/images/committers.png";
    private static final Map<String, String> ICONS = new HashMap<String, String>();
    private static final String ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID = "org.eclipse.sdk.ide";
    private static final String ECLIPSE_PLATFORM_SDK_PRODUCT_ID = "eclipse.platform.sdk";
    private static final List<String> PRODUCT_IDS = Arrays.asList("epp.package.java", "epp.package.jee", "epp.package.cpp", "epp.package.javascript", "epp.package.php", "epp.package.committers", "epp.package.dsl", "epp.package.modeling", "epp.package.rcp", "epp.package.testing", "epp.package.parallel", "epp.package.scout", "epp.package.rust", "org.eclipse.platform.ide", "org.eclipse.sdk.ide", "epp.package.reporting", "epp.package.android", "epp.package.automotive");
    private static final String ALL_PRODUCT_ID = "all";
    private static final List<String> SPECIAL_PRODUCT_IDS = Arrays.asList("org.eclipse.platform.ide");
    private static final Set<String> EXCLUDED_IDS = new HashSet<String>(Arrays.asList("epp.package.mobile"));
    private static final String EPP_INSTALL_ROOTS_FILTER = "(org.eclipse.epp.install.roots=true)";
    private static final boolean IS_RANGE_NARROW = Boolean.FALSE;
    private static final String JUSTJ_JRES = "https://download.eclipse.org/justj/jres";
    private URI outputLocation;
    private String stagingTrain;
    private boolean stagingEPPLocationIsActual;
    private boolean latestReleased;
    private boolean stagingUseComposite;
    private boolean brandingNotification;
    private List<String> compositeTrains = new ArrayList<String>();
    private URI stagingEPPLocation;
    private URI stagingTrainLocation;
    private URI stagingEclipePlatformLocation;
    private URI eppSiteURI;
    private final Map<String, Map<URI, Map<String, URI>>> sites = new LinkedHashMap<String, Map<URI, Map<String, URI>>>();
    private final IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
    private final Map<String, IMetadataRepository> eppMetaDataRepositories = new HashMap<String, IMetadataRepository>();
    private final Map<String, IMetadataRepository> platformMetaDataRepositories = new HashMap<String, IMetadataRepository>();
    private final Map<String, List<TrainAndVersion>> trainsAndVersions = new HashMap<String, List<TrainAndVersion>>();
    private final Map<String, String> labels = new HashMap<String, String>();
    private final Map<String, Product> products = new LinkedHashMap<String, Product>();
    private String emfRepositoryLocation;
    private final String[] TRAINS = this.getTrains();
    private URIConverter uriConverter;

    public Object start(IApplicationContext context) throws Exception {
        System.out.println("user.home=" + System.getProperty("user.home"));
        this.uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        String[] arguments = (String[])context.getArguments().get("application.args");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String option = arguments[i];
                if ("-outputLocation".equals(option)) {
                    this.outputLocation = URI.createURI((String)arguments[++i]);
                } else if ("-staging".equals(option)) {
                    this.stagingTrain = arguments[++i];
                    this.stagingEPPLocation = URI.createURI((String)arguments[++i]);
                    this.stagingTrainLocation = URI.createURI((String)arguments[++i]);
                    if (i + 1 < arguments.length && !arguments[i + 1].startsWith("-")) {
                        this.stagingEclipePlatformLocation = URI.createURI((String)arguments[++i]);
                    }
                } else if ("-actual".equals(option)) {
                    this.stagingEPPLocationIsActual = true;
                } else if ("-latestReleased".equals(option)) {
                    this.latestReleased = true;
                } else if ("-useComposite".equals(option)) {
                    if (i + 1 < arguments.length && Arrays.asList(this.getTrains()).contains(arguments[i + 1])) {
                        do {
                            this.compositeTrains.add(arguments[++i]);
                        } while (i + 1 < arguments.length && Arrays.asList(this.getTrains()).contains(arguments[i + 1]));
                    } else {
                        this.stagingUseComposite = true;
                    }
                } else if ("-brandingNotification".equals(option)) {
                    this.brandingNotification = true;
                } else if ("-siteURI".equals(option)) {
                    this.eppSiteURI = URI.createURI((String)arguments[++i]);
                }
                ++i;
            }
        }
        ICONS.put("reporting", "http://www.eclipse.org/downloads/images/birt-icon_48x48.png");
        ICONS.put("cpp", "http://www.eclipse.org/downloads/images/cdt.png");
        ICONS.put("automotive", "http://www.eclipse.org/downloads/images/classic.jpg");
        ICONS.put("standard", ICON_DEFAULT);
        ICONS.put("committers", ICON_DEFAULT);
        ICONS.put("android", ICON_DEFAULT);
        ICONS.put("dsl", "http://www.eclipse.org/downloads/images/dsl-package_42.png");
        ICONS.put("java", "http://www.eclipse.org/downloads/images/java.png");
        ICONS.put("jee", "http://www.eclipse.org/downloads/images/javaee.png");
        ICONS.put("modeling", "http://www.eclipse.org/downloads/images/modeling.png");
        ICONS.put("parallel", "http://www.eclipse.org/downloads/images/parallel.png");
        ICONS.put("php", "http://www.eclipse.org/downloads/images/php.png");
        ICONS.put("rcp", "http://www.eclipse.org/downloads/images/rcp.png");
        ICONS.put("scout", "http://www.eclipse.org/downloads/images/scout.jpg");
        ICONS.put("testing", "http://www.eclipse.org/downloads/images/testing.png");
        ICONS.put("mobile", "http://www.eclipse.org/downloads/images/mobile.jpg");
        ICONS.put("rust", "http://www.eclipse.org/downloads/images/corrosion.png");
        this.generate();
        return null;
    }

    public void stop() {
    }

    private String[] getTrains() {
        return new String[]{"juno", "kepler", "luna", "mars", "neon", "oxygen", "photon", "2018-09", "2018-12", "2019-03", "2019-06", "2019-09", "2019-12", "2020-03", "2020-06", "2020-09"};
    }

    private URI getEclipsePlatformSite(String train) {
        String[] trains = this.getTrains();
        int i = 0;
        while (i < trains.length) {
            if (trains[i].equals(train)) {
                if (train.equals(this.stagingTrain) && this.stagingEclipePlatformLocation != null) {
                    return this.stagingEclipePlatformLocation;
                }
                String versionSegment = "4." + (i + 2);
                if (i + 1 == trains.length && !this.isLatestReleased()) {
                    versionSegment = String.valueOf(versionSegment) + "-I-builds";
                }
                return ECLIPSE_PROJECT_URI.appendSegment(versionSegment);
            }
            ++i;
        }
        throw new RuntimeException("Invalid train: " + train);
    }

    private int compareTrains(String train1, String train2) {
        String[] trains = this.getTrains();
        int train1Index = -1;
        int train2Index = -1;
        int i = 0;
        while (i < trains.length) {
            String train = trains[i];
            if (train1.equals(train)) {
                train1Index = i;
            }
            if (train2.equals(train)) {
                train2Index = i;
            }
            ++i;
        }
        return train1Index - train2Index;
    }

    private String getMostRecentTrain() {
        String[] trains = this.getTrains();
        return trains[trains.length - 1];
    }

    private String getMostRecentReleasedTrain() {
        String[] trains = this.getTrains();
        return trains[trains.length - (this.isLatestReleased() ? 1 : 2)];
    }

    private String[] getRootIUs() {
        return new String[]{"org.eclipse.platform.feature.group", "org.eclipse.rcp.feature.group", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group"};
    }

    private boolean isLatestReleased() {
        return this.latestReleased;
    }

    public void generate() {
        this.getPackageBrandingSites();
        try {
            ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
            productCatalog.setName("org.eclipse.products");
            productCatalog.setLabel("Eclipse.org");
            productCatalog.setDescription("The catalog of products available as <a href='https://www.eclipse.org/downloads/'>packaged downloads</a> at Eclipse.org.");
            EMap<String, String> brandingInfos = this.getBrandingInfos((Scope)productCatalog);
            brandingInfos.put((Object)"readmePath", (Object)"readme/readme_eclipse.html");
            Annotation statsSending = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/StatsSending");
            statsSending.getDetails().put((Object)"uri", (Object)"http://download.eclipse.org/stats/oomph");
            productCatalog.getAnnotations().add((Object)statsSending);
            InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
            installationTask.setID("installation");
            productCatalog.getSetupTasks().add((Object)installationTask);
            productCatalog.getSetupTasks().addAll(this.createOomphP2Task(null));
            this.emfRepositoryLocation = this.trimEmptyTrailingSegment(URI.createURI((String)this.loadLatestRepository(this.manager, null, URI.createURI((String)"http://download.eclipse.org/modeling/emf/emf/builds/release/latest"), true).getLocation().toString())).toString();
            new RepositoryLoader(this).perform(this.TRAINS);
            System.out.println("#################################################################################################################");
            System.out.println();
            ArrayList<String> ids = new ArrayList<String>(this.trainsAndVersions.keySet());
            Collections.sort(ids, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    int result = this.getLatestTrain(id2) - this.getLatestTrain(id1);
                    if (result == 0) {
                        String label1 = StringUtil.safe((String)((String)ProductCatalogGenerator.this.labels.get(id1)));
                        String label2 = StringUtil.safe((String)((String)ProductCatalogGenerator.this.labels.get(id2)));
                        result = label1.compareTo(label2);
                    }
                    return result;
                }

                private int getLatestTrain(String id) {
                    List list = (List)ProductCatalogGenerator.this.trainsAndVersions.get(id);
                    TrainAndVersion lastEntry = (TrainAndVersion)list.get(list.size() - 1);
                    String lastTrain = lastEntry.getTrain();
                    int i = 0;
                    while (i < ProductCatalogGenerator.this.TRAINS.length) {
                        String train = ProductCatalogGenerator.this.TRAINS[i];
                        if (train == lastTrain) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException();
                }
            });
            for (String id : ids) {
                this.products.put(id, null);
            }
            new ProductGenerator(this).perform(ids);
            EList products = productCatalog.getProducts();
            products.addAll(this.products.values());
            UniqueEList productIDs = new UniqueEList(PRODUCT_IDS);
            for (Product product : products) {
                productIDs.add(product.getName());
            }
            ECollections.sort((EList)products, (Comparator)new Comparator<Product>((List)productIDs){
                private final /* synthetic */ List val$productIDs;
                {
                    this.val$productIDs = list;
                }

                @Override
                public int compare(Product product1, Product product2) {
                    int index1 = this.val$productIDs.indexOf(product1.getName());
                    int index2 = this.val$productIDs.indexOf(product2.getName());
                    return index1 - index2;
                }
            });
            System.out.println("#################################################################################################################");
            System.out.println();
            if (IS_RANGE_NARROW) {
                this.checkVersionRanges(productCatalog);
            }
            this.postProcess(productCatalog);
            if (this.brandingNotification) {
                this.addBrandingNotificationAnnotations(productCatalog);
            }
            Resource resource = new BaseResourceFactoryImpl().createResource(this.outputLocation == null ? URI.createURI((String)"org.eclipse.products.setup") : this.outputLocation);
            resource.getContents().add((Object)productCatalog);
            if (this.outputLocation != null) {
                URI jresURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.jres.setup");
                Resource jresResource = new BaseResourceFactoryImpl().createResource(jresURI);
                Macro jreMacro = this.getJREs();
                jresResource.getContents().add((Object)jreMacro);
                jresResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                for (Product product : new ArrayList(products)) {
                    EclipseIniTask eclipseIniTask;
                    if (ALL_PRODUCT_ID.equals(product.getName())) {
                        products.remove((Object)product);
                        URI allProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.all.product.setup");
                        Resource allProductResource = new BaseResourceFactoryImpl().createResource(allProductURI);
                        eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                        eclipseIniTask.setVm(true);
                        eclipseIniTask.setOption("-Xmx");
                        eclipseIniTask.setValue("5g");
                        product.getSetupTasks().add((Object)eclipseIniTask);
                        allProductResource.getContents().add((Object)product);
                        allProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                    }
                    if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(product.getName())) continue;
                    products.remove((Object)product);
                    URI eclipsePlatformSDKProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.platform.sdk.product.setup");
                    Resource eclipsePlatformSDKProductResource = new BaseResourceFactoryImpl().createResource(eclipsePlatformSDKProductURI);
                    eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                    eclipseIniTask.setVm(true);
                    eclipseIniTask.setOption("-Xmx");
                    eclipseIniTask.setValue("3g");
                    product.getSetupTasks().add((Object)eclipseIniTask);
                    eclipsePlatformSDKProductResource.getContents().add((Object)product);
                    eclipsePlatformSDKProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                }
                resource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<SetupTask> createOomphP2Task(String emfRepository) {
        ArrayList<SetupTask> result = new ArrayList<SetupTask>();
        Requirement oomphRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.oomph.setup.feature.group");
        Repository oomphRepository = P2Factory.eINSTANCE.createRepository("${oomph.update.url}");
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.getRequirements().add((Object)oomphRequirement);
        p2Task.getRepositories().add((Object)oomphRepository);
        result.add((SetupTask)p2Task);
        if (emfRepository != null) {
            VariableTask emfVariable = SetupFactory.eINSTANCE.createVariableTask();
            emfVariable.setName("oomph.emf.update.url");
            emfVariable.setValue(emfRepository);
            emfVariable.setLabel("Oomph's EMF Repository Location");
            emfVariable.setDescription("The location of the EMF repository for satisifying Oomph's dependencies on EMF");
            result.add((SetupTask)emfVariable);
            p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("${oomph.emf.update.url}"));
        }
        return result;
    }

    private void generateProduct(String id) {
        String label = this.labels.get(id);
        String p2TaskLabel = this.stripIncubating(label);
        List<TrainAndVersion> list = this.trainsAndVersions.get(id);
        int size = list.size();
        TrainAndVersion latestTrainAndVersion = list.get(size - 1);
        String latestTrain = latestTrainAndVersion.getTrain();
        String latestTrainLabel = this.getTrainLabel(latestTrain);
        Version latestVersion = latestTrainAndVersion.getVersion();
        Map<String, Set<IInstallableUnit>> latestTrainsIUs = latestTrainAndVersion.getIUs();
        boolean discontinued = latestTrain != this.getMostRecentTrain() && latestTrain != this.getMostRecentReleasedTrain();
        boolean latestUnreleased = latestTrain == this.getMostRecentTrain() && !this.isLatestReleased();
        StringBuilder log = new StringBuilder();
        log.append(label).append(" (").append(id).append(')').append('\n');
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName(id);
        this.setProductLabel(product, label);
        this.attachBrandingInfos(log, product, discontinued);
        this.products.put(id, product);
        if (ALL_PRODUCT_ID.equals(id) || ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
            product.getSetupTasks().addAll(this.createOomphP2Task(ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id) ? this.emfRepositoryLocation : null));
        }
        String eclipseVersionPrefix = "";
        if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
            Version version = latestTrainAndVersion.getIUs().values().iterator().next().iterator().next().getVersion();
            eclipseVersionPrefix = version.getSegment(0) + "." + version.getSegment(1) + " - ";
        }
        this.addProductVersion(log, product, latestVersion, VersionSegment.MAJOR, latestTrainAndVersion.getTrainURI(), latestTrainAndVersion.getEPPURI(), latestTrain, "latest", "Latest (" + eclipseVersionPrefix + latestTrainLabel + ")", String.valueOf(p2TaskLabel) + " (" + eclipseVersionPrefix + latestTrainLabel + ")", latestTrainsIUs, this.emfRepositoryLocation);
        if (!latestUnreleased || size != 1) {
            int offset = 1;
            if (latestUnreleased && size > 1) {
                ++offset;
            }
            TrainAndVersion releasedTrainAndVersion = list.get(size - offset);
            String releasedTrain = releasedTrainAndVersion.getTrain();
            String releasedTrainLabel = this.getTrainLabel(releasedTrain);
            Version releasedVersion = releasedTrainAndVersion.getVersion();
            if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
                Version version = releasedTrainAndVersion.getIUs().values().iterator().next().iterator().next().getVersion();
                eclipseVersionPrefix = version.getSegment(0) + "." + version.getSegment(1) + " - ";
            }
            this.addProductVersion(log, product, releasedVersion, IS_RANGE_NARROW ? VersionSegment.MINOR : VersionSegment.MAJOR, releasedTrainAndVersion.getTrainURI(), releasedTrainAndVersion.getEPPURI(), releasedTrain, "latest.released", "Latest Release (" + eclipseVersionPrefix + releasedTrainLabel + ")", String.valueOf(p2TaskLabel) + " (" + eclipseVersionPrefix + releasedTrainLabel + ")", releasedTrainAndVersion.getIUs(), this.emfRepositoryLocation);
        }
        int i = 0;
        while (i < size) {
            TrainAndVersion entry = list.get(size - i - 1);
            String train = entry.getTrain();
            String trainLabel = this.getTrainLabel(train);
            Version version = entry.getVersion();
            String name = train;
            if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
                Version eclipseVersion = entry.getIUs().values().iterator().next().iterator().next().getVersion();
                name = eclipseVersion.getSegment(0) + "." + eclipseVersion.getSegment(1);
                trainLabel = String.valueOf(name) + " - " + trainLabel;
            }
            this.addProductVersion(log, product, version, IS_RANGE_NARROW ? VersionSegment.MINOR : VersionSegment.MAJOR, entry.getTrainURI(), entry.getEPPURI(), train, name, trainLabel, String.valueOf(p2TaskLabel) + " (" + trainLabel + ")", entry.getIUs(), this.emfRepositoryLocation);
            ++i;
        }
        System.out.println(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(String train) throws ProvisionException, URISyntaxException {
        Object value;
        String id;
        Object label;
        Object latestLocation;
        IMetadataRepository latestEPPMetaDataRepository;
        StringBuilder log = new StringBuilder();
        URI originalEPPURI = URI.createURI((String)("http://download.eclipse.org/technology/epp/packages/" + train));
        URI eppURI = this.uriConverter.normalize(originalEPPURI);
        log.append(eppURI);
        boolean isStaging = train.equals(this.stagingTrain);
        if (isStaging) {
            log.append(" -> ").append(this.stagingEPPLocation);
        }
        URI effectiveEPPURI = isStaging ? this.stagingEPPLocation : eppURI;
        IMetadataRepository eppMetaDataRepository = this.manager.loadRepository(new java.net.URI(effectiveEPPURI.toString()), null);
        IMetadataRepository iMetadataRepository = latestEPPMetaDataRepository = isStaging && this.stagingUseComposite || this.compositeTrains.contains(train) || !this.isLatestReleased() ? eppMetaDataRepository : this.getLatestRepository(this.manager, eppMetaDataRepository);
        if (latestEPPMetaDataRepository != eppMetaDataRepository) {
            latestLocation = URI.createURI((String)latestEPPMetaDataRepository.getLocation().toString());
            log.append(" -> ").append(latestLocation);
            URI relativeLocation = URI.createURI((String)latestLocation.toString()).deresolve(URI.createURI((String)effectiveEPPURI.toString()).appendSegment(""));
            if (relativeLocation.isRelative()) {
                URI actualLatestEPPURI = URI.createURI((String)URI.createURI((String)eppURI.toString()).appendSegments(relativeLocation.segments()).toString());
                try {
                    this.manager.loadRepository(new java.net.URI(actualLatestEPPURI.toString()), null);
                    log.append(" -> ").append(actualLatestEPPURI);
                    eppURI = this.trimEmptyTrailingSegment(actualLatestEPPURI);
                }
                catch (Throwable throwable) {}
            }
        } else if (isStaging && this.stagingEPPLocationIsActual) {
            eppURI = this.stagingEPPLocation;
            log.append(" -> ").append(this.stagingEPPLocation);
        }
        log.append('\n');
        latestLocation = this.eppMetaDataRepositories;
        synchronized (latestLocation) {
            this.eppMetaDataRepositories.put(train, eppMetaDataRepository);
        }
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        URI releaseURI = URI.createURI((String)("http://download.eclipse.org/releases/" + train));
        log.append(releaseURI);
        IMetadataRepository releaseMetaDataRepository = this.loadLatestRepository(this.manager, originalEPPURI, isStaging ? this.stagingTrainLocation : releaseURI, !this.compositeTrains.contains(train) && (!isStaging || !this.stagingUseComposite));
        if (this.compositeTrains.contains(train) || isStaging && this.stagingUseComposite) {
            URI latestURI = this.trimEmptyTrailingSegment(URI.createURI((String)releaseMetaDataRepository.getLocation().toString()));
            if (!latestURI.equals(releaseURI)) {
                releaseURI = latestURI.trimSegments(1);
            }
        } else {
            releaseURI = this.trimEmptyTrailingSegment(URI.createURI((String)releaseMetaDataRepository.getLocation().toString()));
        }
        log.append(" -> ").append(releaseURI).append('\n');
        log.append(this.generateEclipsePlatformProduct(train));
        this.generateFullTrainProduct(train, releaseMetaDataRepository, releaseURI);
        String mostRecentTrain = this.getMostRecentTrain();
        HashSet<String> requirements = new HashSet<String>();
        for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            IInstallableUnit existingIU;
            String fragment = iInstallableUnit.getProperty("org.eclipse.equinox.p2.type.fragment");
            if ("true".equals(fragment)) continue;
            label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name");
            if (label == null || ((String)label).startsWith("%") || ((String)label).equals("Uncategorized")) {
                requirements.add(iInstallableUnit.getId());
            }
            if ("epp.package.standard".equals(id = iInstallableUnit.getId())) {
                label = "Eclipse Standard";
            }
            if ((existingIU = (IInstallableUnit)ius.get(id)) != null) continue;
            ius.put(id, iInstallableUnit);
            Map<String, String> map = this.labels;
            synchronized (map) {
                String existingLabel = this.labels.get(id);
                if (existingLabel == null || train.equals(mostRecentTrain)) {
                    this.labels.put(id, (String)label);
                }
            }
        }
        for (IInstallableUnit iInstallableUnit : ius.values()) {
            for (IRequirement requirement : iInstallableUnit.getRequirements()) {
                IRequiredCapability capability;
                IMatchExpression filter;
                if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) != null && EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter)) || !"org.eclipse.equinox.p2.iu".equals(capability.getNamespace())) continue;
                requirements.add(capability.getName());
            }
        }
        ius.keySet().removeAll(requirements);
        for (String string : SPECIAL_PRODUCT_IDS) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)string)), null))) {
                id = iu.getId();
                String label2 = iu.getProperty("org.eclipse.equinox.p2.name");
                ius.put(id, iu);
                value = this.labels;
                synchronized (value) {
                    this.labels.put(id, label2);
                }
            }
        }
        block19: for (Map.Entry entry : ius.entrySet()) {
            String id2 = (String)entry.getKey();
            label = this.labels.get(id2);
            IInstallableUnit iu = (IInstallableUnit)entry.getValue();
            Version version = iu.getVersion();
            log.append("  ").append((String)label).append("  --  ").append(id2).append(" ").append(version).append('\n');
            HashMap<String, Set<IInstallableUnit>> versionIUs = new HashMap<String, Set<IInstallableUnit>>();
            this.gatherReleaseIUs(versionIUs, iu, releaseMetaDataRepository, eppMetaDataRepository);
            this.filterRoots(versionIUs);
            Map<String, List<TrainAndVersion>> map = this.trainsAndVersions;
            synchronized (map) {
                List<TrainAndVersion> list = this.trainsAndVersions.get(id2);
                if (list == null) {
                    list = new ArrayList<TrainAndVersion>();
                    this.trainsAndVersions.put(id2, list);
                }
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
                        continue block19;
                    }
                    ++i;
                }
                list.add(new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
            }
        }
        System.out.println(log.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateEclipsePlatformProduct(String train) throws ProvisionException, URISyntaxException {
        StringBuilder log = new StringBuilder();
        URI eclipsePlatformSite = this.getEclipsePlatformSite(train);
        log.append(eclipsePlatformSite + " -> ");
        IMetadataRepository repository = this.loadLatestRepository(this.manager, null, eclipsePlatformSite, true);
        log.append(repository.getLocation() + "\n");
        TreeMap<String, Set<IInstallableUnit>> versionIUs = new TreeMap<String, Set<IInstallableUnit>>();
        IQuery query = QueryUtil.createCompoundQuery(Arrays.asList(QueryUtil.createIUQuery((String)ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID), QueryUtil.createLatestIUQuery()), (boolean)true);
        Object ide = null;
        for (Object iu : P2Util.asIterable((IQueryResult)repository.query(query, null))) {
            String id = iu.getId();
            CollectionUtil.add(versionIUs, (Object)id, (Object)iu);
            ide = iu;
        }
        if (ide != null) {
            Object iu;
            iu = this.labels;
            synchronized (iu) {
                this.labels.put(ECLIPSE_PLATFORM_SDK_PRODUCT_ID, "Eclipse SDK");
            }
            iu = this.platformMetaDataRepositories;
            synchronized (iu) {
                this.platformMetaDataRepositories.put(train, repository);
            }
            URI releaseURI = eclipsePlatformSite.toString().contains("I-builds") ? eclipsePlatformSite : URI.createURI((String)repository.getLocation().toString());
            Map<String, List<TrainAndVersion>> map = this.trainsAndVersions;
            synchronized (map) {
                List<TrainAndVersion> list = this.trainsAndVersions.get(ECLIPSE_PLATFORM_SDK_PRODUCT_ID);
                if (list == null) {
                    list = new ArrayList<TrainAndVersion>();
                    this.trainsAndVersions.put(ECLIPSE_PLATFORM_SDK_PRODUCT_ID, list);
                }
                boolean added = false;
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    list.add(new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
                }
            }
        }
        return log.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFullTrainProduct(String train, IMetadataRepository releaseMetaDataRepository, URI releaseURI) {
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        HashSet<IInstallableUnit> categories = new HashSet<IInstallableUnit>();
        HashSet<Object> categorizedIUs = new HashSet<Object>();
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            boolean isIncludedCategory;
            String id = iu.getId();
            IInstallableUnit existingIU = (IInstallableUnit)ius.get(id);
            if (existingIU == null) {
                ius.put(id, iu);
            }
            boolean bl = isIncludedCategory = "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"EclipseRT Target Platform Components".equals(id);
            if (!isIncludedCategory) continue;
            categories.add(iu);
            categorizedIUs.add(id);
        }
        categorizedIUs.addAll(SPECIAL_PRODUCT_IDS);
        ius.keySet().retainAll(categorizedIUs);
        TreeMap<String, Set<IInstallableUnit>> versionIUs = new TreeMap<String, Set<IInstallableUnit>>();
        for (IInstallableUnit iu : ius.values()) {
            String id = iu.getId();
            CollectionUtil.add(versionIUs, (Object)id, (Object)iu);
        }
        Map<String, List<TrainAndVersion>> map = this.labels;
        synchronized (map) {
            this.labels.put(ALL_PRODUCT_ID, "Eclipse Eierlegende Wollmilchsau");
        }
        map = this.trainsAndVersions;
        synchronized (map) {
            List<TrainAndVersion> list = this.trainsAndVersions.get(ALL_PRODUCT_ID);
            if (list == null) {
                list = new ArrayList<TrainAndVersion>();
                this.trainsAndVersions.put(ALL_PRODUCT_ID, list);
            }
            for (String specialProductID : SPECIAL_PRODUCT_IDS) {
                IInstallableUnit ide = (IInstallableUnit)ius.get(specialProductID);
                boolean added = false;
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (added) continue;
                list.add(new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
            }
        }
    }

    private URI trimEmptyTrailingSegment(URI uri) throws URISyntaxException {
        if (uri.hasTrailingPathSeparator()) {
            return uri.trimSegments(1);
        }
        return uri;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        try {
            File agentLocation = File.createTempFile("test-", "-agent");
            agentLocation.delete();
            agentLocation.mkdirs();
            AgentImpl agent = new AgentImpl(null, agentLocation);
            IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
            return manager;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private IMetadataRepository getLatestRepository(IMetadataRepositoryManager manager, IMetadataRepository repository) throws URISyntaxException, ProvisionException {
        IMetadataRepository result = repository;
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = manager.loadRepository(childURI = new java.net.URI(this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString())).toString()), null);
                String value = (String)childRepository.getProperties().get("p2.timestamp");
                long timestamp = Long.parseLong(value);
                if (timestamp <= latest || childURI.toString().endsWith("categories")) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private IMetadataRepository loadLatestRepository(IMetadataRepositoryManager manager, URI eppURI, URI releaseURI, boolean loadLatestChild) throws URISyntaxException, ProvisionException {
        IMetadataRepository releaseMetaDataRepository;
        IMetadataRepository result = releaseMetaDataRepository = manager.loadRepository(new java.net.URI(this.uriConverter.normalize(releaseURI).toString()), null);
        if (loadLatestChild && releaseMetaDataRepository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)releaseMetaDataRepository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository;
                String value;
                long timestamp;
                String trimmedChildURI = this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString())).toString();
                if (trimmedChildURI.startsWith(PACKAGES) || trimmedChildURI.startsWith(HTTPS_PACKAGES) || (timestamp = Long.parseLong(value = (String)(childRepository = manager.loadRepository(childURI = new java.net.URI(trimmedChildURI), null)).getProperties().get("p2.timestamp"))) <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private void addIntegrationVersions(ProductCatalog productCatalog) {
        List<String> trains = Arrays.asList(this.getTrains());
        int platformVersion = trains.indexOf(this.getMostRecentTrain()) - trains.indexOf("neon") + 6;
        for (Product product : productCatalog.getProducts()) {
            if (!SPECIAL_PRODUCT_IDS.contains(product.getName())) continue;
            EList versions = product.getVersions();
            ProductVersion version = (ProductVersion)versions.get(0);
            ProductVersion integrationVersion = (ProductVersion)EcoreUtil.copy((EObject)version);
            integrationVersion.setName("integration");
            integrationVersion.setLabel(version.getLabel().replace("Latest", "Integration"));
            P2Task p2Task = (P2Task)integrationVersion.getSetupTasks().get(0);
            p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("http://download.eclipse.org/eclipse/updates/4." + platformVersion + "-I-builds"));
            versions.add(0, (Object)integrationVersion);
        }
    }

    private void checkVersionRanges(ProductCatalog productCatalog) {
        if (!this.isLatestReleased()) {
            for (Product product : productCatalog.getProducts()) {
                EList versions = product.getVersions();
                if (versions.size() <= 3) continue;
                ProductVersion latestReleaseVersion = (ProductVersion)versions.get(1);
                ProductVersion latestDevelopmentVersion = (ProductVersion)versions.get(2);
                if (!this.getMostRecentTrain().equals(latestDevelopmentVersion.getName())) continue;
                P2Task latestReleaseP2Task = (P2Task)latestReleaseVersion.getSetupTasks().get(0);
                P2Task latestDevelopmentP2Task = (P2Task)latestDevelopmentVersion.getSetupTasks().get(0);
                block1: for (Requirement developmentRequirement : latestDevelopmentP2Task.getRequirements()) {
                    String name = developmentRequirement.getName();
                    for (Requirement releaseRequirement : latestReleaseP2Task.getRequirements()) {
                        VersionRange releaseVersionRange;
                        if (!name.equals(releaseRequirement.getName())) continue;
                        VersionRange developmentVersionRange = developmentRequirement.getVersionRange();
                        if (!developmentVersionRange.equals((Object)(releaseVersionRange = releaseRequirement.getVersionRange()))) continue block1;
                        Version minimumVersion = developmentVersionRange.getMinimum();
                        Version maximumVersion = developmentVersionRange.getMaximum();
                        if (!(minimumVersion instanceof OSGiVersion) || !(maximumVersion instanceof OSGiVersion)) continue block1;
                        OSGiVersion minimum = (OSGiVersion)minimumVersion;
                        OSGiVersion maximum = (OSGiVersion)maximumVersion;
                        int major = minimum.getMajor();
                        if (major != maximum.getMajor()) continue block1;
                        developmentRequirement.setVersionRange(new VersionRange((Version)minimum, true, Version.createOSGi((int)major, (int)(maximum.getMinor() + 1), (int)0), false));
                        continue block1;
                    }
                }
            }
        }
    }

    private void postProcess(ProductCatalog productCatalog) {
        Iterator it = productCatalog.getProducts().iterator();
        while (it.hasNext()) {
            Product product = (Product)it.next();
            String id = product.getName();
            if (EXCLUDED_IDS.contains(id)) {
                it.remove();
            }
            if (!"epp.package.standard".equals(id)) continue;
            for (ProductVersion version : product.getVersions()) {
                if (!version.getLabel().contains("Mars")) continue;
                P2Task task = (P2Task)version.getSetupTasks().get(0);
                Requirement requirement = (Requirement)task.getRequirements().get(0);
                requirement.setName("epp.package.committers");
            }
        }
    }

    private void addBrandingNotificationAnnotations(ProductCatalog productCatalog) {
        EMap<String, String> productCatalogBrandingInfos = this.getBrandingInfos((Scope)productCatalog);
        productCatalogBrandingInfos.put((Object)"notificationURI", (Object)ECLIPSE_BRANDING_NOTIFICATION_URI.toString());
        productCatalogBrandingInfos.put((Object)"notificationLabel", (Object)"DONATE");
        productCatalogBrandingInfos.put((Object)"notificationTooltip", (Object)"Donate to the Eclipse Community");
        productCatalogBrandingInfos.put((Object)"notificationAnimationStyle", (Object)"REPEAT");
        for (Product product : productCatalog.getProducts()) {
            String productName = product.getName();
            boolean foreignCatalog = ALL_PRODUCT_ID.equals(productName) || ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName);
            EMap<String, String> productBrandingInfos = this.getBrandingInfos((Scope)product);
            if (foreignCatalog) {
                productBrandingInfos.put((Object)"notificationURI", (Object)ECLIPSE_BRANDING_NOTIFICATION_URI.toString());
                productBrandingInfos.put((Object)"notificationLabel", (Object)"DONATE");
                productBrandingInfos.put((Object)"notificationAnimationStyle", (Object)"REPEAT");
            }
            productBrandingInfos.put((Object)"notificationTooltip", (Object)("Donate to the Eclipse Community for the " + product.getLabel()));
            if (!Boolean.FALSE.booleanValue()) continue;
            for (ProductVersion productVersion : product.getVersions()) {
                EMap<String, String> productVersionBrandingInfos = this.getBrandingInfos((Scope)productVersion);
                productVersionBrandingInfos.put((Object)"notificationColor", (Object)"color://rgb/12/184/198");
                productBrandingInfos.put((Object)"notificationScope", (Object)(String.valueOf(product.getLabel()) + " - " + productVersion.getLabel()));
            }
        }
    }

    private void gatherReleaseIUs(Map<String, Set<IInstallableUnit>> releaseIUs, IInstallableUnit iu, IMetadataRepository releaseMetaDataRepository, IMetadataRepository eppMetaDataRepository) {
        for (IRequirement requirement : iu.getRequirements()) {
            String value;
            IMatchExpression filter;
            IRequiredCapability capability;
            String capabilityName;
            if (!(requirement instanceof IRequiredCapability) || !(capabilityName = (capability = (IRequiredCapability)requirement).getName()).endsWith(".feature.group") || (filter = capability.getFilter()) != null && EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))) continue;
            CompoundQueryable queriable = new CompoundQueryable(new IQueryable[]{releaseMetaDataRepository, eppMetaDataRepository});
            IQuery query = QueryUtil.createIUQuery((String)capabilityName, (VersionRange)capability.getRange());
            for (IInstallableUnit requiredIU : P2Util.asIterable((IQueryResult)queriable.query(query, null))) {
                if (!CollectionUtil.add(releaseIUs, (Object)capabilityName, (Object)requiredIU)) continue;
                this.gatherReleaseIUs(releaseIUs, requiredIU, releaseMetaDataRepository, eppMetaDataRepository);
            }
        }
    }

    private void filterRoots(Map<String, Set<IInstallableUnit>> releaseIUs) {
        Iterator<Map.Entry<String, Set<IInstallableUnit>>> it = releaseIUs.entrySet().iterator();
        while (it.hasNext()) {
            String id = it.next().getKey();
            if (id.endsWith("feature.group") && !id.startsWith("org.eclipse.epp") && !id.endsWith("epp.feature.group")) continue;
            it.remove();
        }
    }

    private void addProductVersion(StringBuilder log, Product product, Version version, VersionSegment versionSegment, URI trainURI, URI eppURI, String train, String name, String label, String p2TaskLabel, Map<String, Set<IInstallableUnit>> ius, String emfRepositoryLocation) {
        log.append("  ").append(label);
        ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
        productVersion.setName(name);
        productVersion.setLabel(label);
        product.getVersions().add((Object)productVersion);
        if (train == this.getMostRecentReleasedTrain() && !name.contains("latest")) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status", (String)"current");
        } else if (train != this.getMostRecentTrain() && train != this.getMostRecentReleasedTrain() && BaseUtil.getAnnotation((ModelElement)product, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status") == null) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status", (String)"outdated");
        }
        String productName = product.getName();
        VersionRange versionRange = this.createVersionRange(version, versionSegment);
        Repository packageRepository = null;
        if (eppURI != null) {
            packageRepository = P2Factory.eINSTANCE.createRepository();
            if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) && !ALL_PRODUCT_ID.equals(productName) && !SPECIAL_PRODUCT_IDS.contains(productName) && train.equals(this.stagingTrain)) {
                try {
                    IMetadataRepository eppMetadataRepository = this.manager.loadRepository(new java.net.URI(eppURI.toString()), null);
                    if (!eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null).iterator().hasNext()) {
                        eppURI = eppURI.trimSegments(1);
                        trainURI = trainURI.trimSegments(1);
                        log.append(" {missing}");
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            URI actualEPPURI = this.uriConverter.getURIMap().values().contains(eppURI) ? URI.createURI((String)("http://download.eclipse.org/technology/epp/packages/" + this.getMostRecentReleasedTrain())) : eppURI;
            packageRepository.setURL(actualEPPURI.toString());
        }
        Repository releaseRepository = P2Factory.eINSTANCE.createRepository();
        releaseRepository.setURL(trainURI.toString());
        if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            releaseRepository.getAnnotations().add((Object)BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/ReleaseTrain"));
        }
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.setLabel(p2TaskLabel);
        if (!ALL_PRODUCT_ID.equals(productName) && !ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(productName);
            requirement.setVersionRange(versionRange);
            p2Task.getRequirements().add((Object)requirement);
            this.addRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
            this.addAdditionalInstallRootIURequirements((EList<Requirement>)p2Task.getRequirements(), productName, train, ius);
        } else {
            this.addAllRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
        }
        if (!SPECIAL_PRODUCT_IDS.contains(productName) && packageRepository != null) {
            p2Task.getRepositories().add((Object)packageRepository);
        }
        p2Task.getRepositories().add((Object)releaseRepository);
        if (this.compareTrains(train, "luna") < 0) {
            Repository emfRepository = P2Factory.eINSTANCE.createRepository(emfRepositoryLocation);
            p2Task.getRepositories().add((Object)emfRepository);
        }
        productVersion.getSetupTasks().add((Object)p2Task);
        String idPrefix = "tooling" + (SPECIAL_PRODUCT_IDS.contains(productName) || ALL_PRODUCT_ID.equals(productName) ? "epp.package.java" : (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) ? "org.eclipse.platform.sdk" : productName)) + ".ini.";
        Version maxJavaVersion = null;
        if (train.compareTo("neon") >= 0) {
            maxJavaVersion = Version.create((String)"1.8.0");
        }
        IMetadataRepository metadDataRepository = ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) ? this.platformMetaDataRepositories.get(train) : this.eppMetaDataRepositories.get(train);
        Object javaVersion = this.getRequiredJavaVersion(metadDataRepository, idPrefix);
        if (maxJavaVersion == null || javaVersion != null && maxJavaVersion.compareTo(javaVersion) < 0) {
            maxJavaVersion = javaVersion;
        }
        if (maxJavaVersion == null && ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            idPrefix = "toolingepp.package.java.ini.";
            maxJavaVersion = this.getRequiredJavaVersion(this.eppMetaDataRepositories.get(train), idPrefix);
        }
        if (maxJavaVersion != null) {
            javaVersion = maxJavaVersion.toString();
            while (((String)javaVersion).endsWith(".0")) {
                javaVersion = ((String)javaVersion).substring(0, ((String)javaVersion).length() - 2);
            }
            productVersion.setRequiredJavaVersion((String)javaVersion);
            log.append(" --> Java ").append((String)javaVersion);
        }
        Map<URI, Map<String, URI>> releases = this.sites.get(train);
        String productLabel = product.getLabel();
        String key = this.getKey(productLabel);
        Object siteURI = null;
        if (releases != null) {
            for (Map.Entry<URI, Map<String, URI>> productEntry : releases.entrySet()) {
                Map<String, URI> productLocations = productEntry.getValue();
                siteURI = productLocations.get(key);
                if (siteURI != null) continue;
                siteURI = product.getName().startsWith("epp.") || ALL_PRODUCT_ID.equals(product.getName()) ? productEntry.getKey() : URI.createURI((String)"https://download.eclipse.org/eclipse/downloads/");
                log.append(" No version specific branding site -> ").append(siteURI);
            }
        }
        if (siteURI != null) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"siteURI", (String)siteURI.toString());
            if (this.isIncubating((URI)siteURI)) {
                BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"incubating", (String)"true");
            }
        }
        BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"shortcut", (String)(String.valueOf(product.getLabel().replaceAll(" \\(.+\\)", "")) + " - " + label.replaceAll(" \\(.+\\)", "")));
        log.append('\n');
    }

    private Version getRequiredJavaVersion(IMetadataRepository metadDataRepository, String idPrefix) {
        Version maxJavaVersion = null;
        if (metadDataRepository != null) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)metadDataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                String id = iu.getId();
                if (!id.startsWith(idPrefix)) continue;
                Version javaVersion = this.getRequiredJavaVersion(iu);
                if (maxJavaVersion != null && (javaVersion == null || maxJavaVersion.compareTo((Object)javaVersion) >= 0)) continue;
                maxJavaVersion = javaVersion;
            }
        }
        return maxJavaVersion;
    }

    private Version getRequiredJavaVersion(IInstallableUnit iu) {
        Version maxJavaVersion = null;
        Collection touchpointDatas = iu.getTouchpointData();
        if (touchpointDatas != null) {
            for (ITouchpointData touchpointData : touchpointDatas) {
                int pos;
                String body;
                ITouchpointInstruction instruction = touchpointData.getInstruction("configure");
                if (instruction == null || (body = instruction.getBody()) == null || (pos = body.indexOf(JAVA_VERSION_PREFIX)) == -1) continue;
                Version javaVersion = Version.parseVersion((String)body.substring(pos += JAVA_VERSION_PREFIX.length(), body.indexOf(41, pos)));
                if (maxJavaVersion != null && maxJavaVersion.compareTo((Object)javaVersion) >= 0) continue;
                maxJavaVersion = javaVersion;
            }
        }
        return maxJavaVersion;
    }

    private String getKey(String productLabel) {
        if (productLabel.contains("Eierlegende")) {
            return "All";
        }
        if (productLabel.contains("JavaScript")) {
            return "JavaScript";
        }
        if (productLabel.contains("Enterprise") || productLabel.contains(" EE ") || productLabel.contains("Web")) {
            return "EE";
        }
        if (productLabel.contains("Java Developer")) {
            return "Java";
        }
        if (productLabel.contains("Mobile")) {
            return "Mobile";
        }
        if (productLabel.contains("C/C++")) {
            return "C";
        }
        if (productLabel.contains("Scout")) {
            return "Scout";
        }
        if (productLabel.contains("Parallel")) {
            return "Parallel";
        }
        if (productLabel.contains(" Report ")) {
            return "Report";
        }
        if (productLabel.contains("Automotive")) {
            return "Automotive";
        }
        if (productLabel.contains("DSL")) {
            return "DSL";
        }
        if (productLabel.contains("Modeling")) {
            return "Modeling";
        }
        if (productLabel.contains("Testers")) {
            return "Testers";
        }
        if (productLabel.contains("RCP")) {
            return "RCP";
        }
        if (productLabel.contains("Standard") || productLabel.contains("Committers")) {
            return "Committers";
        }
        if (productLabel.contains("PHP")) {
            return "PHP";
        }
        if (productLabel.contains("Classic")) {
            return "Classic";
        }
        if (productLabel.contains("SOA")) {
            return "SOA";
        }
        if (productLabel.equals("Eclipse Platform")) {
            return "Platform";
        }
        if (productLabel.equals("Eclipse SDK")) {
            return "SDK";
        }
        if (productLabel.contains("Android")) {
            return "Android";
        }
        if (productLabel.contains("Rust")) {
            return "Rust";
        }
        if (productLabel.contains("Scientific")) {
            return "Scientific";
        }
        throw new RuntimeException("No key for " + productLabel);
    }

    private VersionRange createVersionRange(Version version, VersionSegment versionSegment) {
        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment);
        if (versionSegment == VersionSegment.MAJOR) {
            VersionRange minorVersionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR);
            versionRange = new VersionRange(minorVersionRange.getMinimum(), true, versionRange.getMaximum(), false);
        }
        return versionRange;
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        String[] stringArray = this.getRootIUs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iu = stringArray[n2];
            Set<IInstallableUnit> rootIUs = ius.get(iu);
            if (rootIUs != null) {
                this.addRootIURequirements(requirements, versionSegment, iu, rootIUs);
            }
            ++n2;
        }
    }

    private void addAllRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        for (Map.Entry<String, Set<IInstallableUnit>> entry : ius.entrySet()) {
            this.addRootIURequirements(requirements, versionSegment, entry.getKey(), entry.getValue());
        }
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, String id, Set<IInstallableUnit> rootIUs) {
        VersionRange range = null;
        for (IInstallableUnit rootIU : rootIUs) {
            boolean isCategory = "true".equalsIgnoreCase(rootIU.getProperty("org.eclipse.equinox.p2.type.category"));
            if (isCategory) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName(id);
                requirement.setVersionRange(VersionRange.emptyRange);
                if (id.equals("Linux Tools")) {
                    requirement.setFilter("(osgi.os=linux)");
                }
                requirements.add((Object)requirement);
                return;
            }
            Version version = rootIU.getVersion();
            VersionRange versionRange = this.createVersionRange(version, versionSegment);
            if (range != null) continue;
            range = versionRange;
        }
        if (range != null) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(id);
            requirement.setVersionRange(range);
            requirements.add((Object)requirement);
        }
    }

    private void addAdditionalInstallRootIURequirements(EList<Requirement> requirements, String productName, String train, Map<String, Set<IInstallableUnit>> ius) {
        Set<String> rootInstallIUs;
        IMetadataRepository eppMetadataRepository = this.eppMetaDataRepositories.get(train);
        IInstallableUnit maxProductIU = null;
        if (eppMetadataRepository != null) {
            for (IInstallableUnit productIU : eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null)) {
                if (maxProductIU != null && productIU.getVersion().compareTo((Object)maxProductIU.getVersion()) <= 0) continue;
                maxProductIU = productIU;
            }
        }
        if (maxProductIU != null && (rootInstallIUs = this.getRootInstallIUs(train, maxProductIU)) != null) {
            for (String id : rootInstallIUs) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName(id);
                requirements.add((Object)requirement);
            }
        }
    }

    private String getTrainLabel(String train) {
        return String.valueOf(Character.toString(Character.toUpperCase(train.charAt(0)))) + train.substring(1);
    }

    private void setProductLabel(Product product, String label) {
        product.setLabel(this.stripIncubating(label));
    }

    private String stripIncubating(String label) {
        return label.replaceFirst("(?i) \\(includes Incubating components\\)", "");
    }

    /*
     * Loose catch block
     */
    private void attachBrandingInfos(final StringBuilder log, final Product product, boolean discontinued) {
        String staticIconURL;
        String name = product.getName();
        if (discontinued) {
            this.getBrandingInfos((Scope)product).put((Object)"status", (Object)"discontinued");
        }
        if (name.equals("org.eclipse.platform.ide")) {
            product.setDescription("This package contains the absolute minimal IDE, suitable only as a base for installing other tools.");
            return;
        }
        if (name.equals(ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID)) {
            product.setDescription("This package contains the IDE provided by the Eclipse project's platform build.");
            return;
        }
        if (name.equals(ALL_PRODUCT_ID)) {
            product.setDescription("This package contains all categorized features of the release train. It can do <a href='https://en.wiktionary.org/wiki/eierlegende_Wollmilchsau'>everything</a>, but it's not pretty.");
        }
        if (name.equals(ECLIPSE_PLATFORM_SDK_PRODUCT_ID)) {
            product.setDescription("This package contains the IDE provided by the Eclipse project's platform build.");
        }
        if (name.startsWith("epp.package.")) {
            name = name.substring("epp.package.".length());
        }
        if ((staticIconURL = ICONS.get(name)) != null) {
            this.addImageURI(product, staticIconURL);
        }
        final String[] trains = this.getTrains();
        int i = trains.length;
        while (i >= 0) {
            InputStream in = null;
            final String branch = i == trains.length ? "master" : trains[i].toUpperCase();
            String url = "https://git.eclipse.org/c/epp/org.eclipse.epp.packages.git/plain/packages/org.eclipse.epp.package." + name + ".feature/epp.website.xml" + "?h=" + branch;
            try {
                in = new URL(url).openStream();
                log.append(url).append('\n');
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)in);
                XMLUtil.handleElementsByTagName((Element)rootElement, (String)"packageMetaData", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleElement(Element element) throws Exception {
                        String packageName;
                        if (staticIconURL != null) {
                            log.append(staticIconURL).append('\n');
                        } else {
                            String iconurl = element.getAttribute("iconurl");
                            if (iconurl != null) {
                                ProductCatalogGenerator.this.addImageURI(product, iconurl);
                                log.append(iconurl).append('\n');
                            }
                        }
                        if (!"epp.package.standard".equals(product.getName()) && (packageName = element.getAttribute("packageName")) != null) {
                            if (ProductCatalogGenerator.this.eppSiteURI != null && "master".equals(branch)) {
                                URI siteURI = URI.createURI((String)(ProductCatalogGenerator.this.eppSiteURI + "/" + packageName.replaceAll("[\\W&&[^ ]]", "").replace(" for ", " ").replaceAll(" +", "-").toLowerCase()));
                                String key = ProductCatalogGenerator.this.getKey(packageName);
                                String train = trains[trains.length - 1];
                                Map map = ProductCatalogGenerator.this.sites;
                                synchronized (map) {
                                    LinkedHashMap<String, URI> map2;
                                    LinkedHashMap<URI, LinkedHashMap<String, URI>> releaseLocations = (LinkedHashMap<URI, LinkedHashMap<String, URI>>)ProductCatalogGenerator.this.sites.get(train);
                                    if (releaseLocations == null) {
                                        releaseLocations = new LinkedHashMap<URI, LinkedHashMap<String, URI>>();
                                        ProductCatalogGenerator.this.sites.put(train, releaseLocations);
                                    }
                                    if ((map2 = (LinkedHashMap<String, URI>)releaseLocations.get(ProductCatalogGenerator.this.eppSiteURI)) == null) {
                                        releaseLocations.clear();
                                        map2 = new LinkedHashMap<String, URI>();
                                        releaseLocations.put(ProductCatalogGenerator.this.eppSiteURI, map2);
                                        map2.put(key, siteURI);
                                    }
                                    map2.put(key, siteURI);
                                }
                            }
                            ProductCatalogGenerator.this.setProductLabel(product, packageName);
                        }
                        XMLUtil.handleChildElements((Element)element, (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                            public void handleElement(Element childElement) throws Exception {
                                String description;
                                String localName = childElement.getLocalName();
                                if ("description".equals(localName) && (description = childElement.getTextContent()) != null) {
                                    product.setDescription(description.trim());
                                }
                            }
                        });
                    }
                });
            }
            catch (FileNotFoundException ex) {
                log.append(ex.getMessage()).append(" (FAILED)\n");
                IOUtil.closeSilent((Closeable)in);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                System.err.println("url=" + url);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeSilent(in);
                        throw throwable;
                    }
                }
                IOUtil.closeSilent((Closeable)in);
            }
            IOUtil.closeSilent((Closeable)in);
            return;
            --i;
        }
        if (staticIconURL != null) {
            log.append(staticIconURL).append('\n');
        }
    }

    private void addImageURI(Product product, String imageURI) {
        if (ICON_DEFAULT.equals(imageURI)) {
            return;
        }
        EMap<String, String> brandingInfos = this.getBrandingInfos((Scope)product);
        if (!brandingInfos.containsKey((Object)"imageURI")) {
            brandingInfos.put((Object)"imageURI", (Object)imageURI);
        }
    }

    private EMap<String, String> getBrandingInfos(Scope scope) {
        Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            scope.getAnnotations().add((Object)annotation);
        }
        return annotation.getDetails();
    }

    private void getPackageBrandingSites() {
        PackageLocationLoader packageLocationLoader = new PackageLocationLoader(this);
        LinkedHashSet<URI> locations = new LinkedHashSet<URI>();
        String[] stringArray = this.getTrains();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                String train = stringArray[n2];
                InputStream packages = null;
                try {
                    try {
                        URI packagesURI = PACKAGES_URI.trimSegments(1).appendSegment(train).appendSegment("");
                        URL packagesURL = new URL(packagesURI.toString());
                        packages = packagesURL.openStream();
                        List lines = IOUtil.readLines((InputStream)packages, (String)"UTF-8");
                        Pattern pattern = Pattern.compile("<li class=\"[0-9][^>]+><a href=\"([^\"]+)\"[^>]*>([\\w]+) Packages</a></li>");
                        for (String line : lines) {
                            Matcher matcher = pattern.matcher(line);
                            if (!matcher.find()) continue;
                            URI siteURI = URI.createURI((String)matcher.group(1)).resolve(PACKAGES_URI);
                            System.out.println(String.valueOf(train) + " -> " + siteURI);
                            LinkedHashMap releaseLocations = new LinkedHashMap();
                            LinkedHashMap packageLocations = new LinkedHashMap();
                            releaseLocations.put(siteURI, packageLocations);
                            this.sites.put(train, releaseLocations);
                            locations.add(siteURI);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        IOUtil.closeSilent(packages);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(packages);
                    throw throwable;
                }
                IOUtil.closeSilent((Closeable)packages);
            }
            ++n2;
        }
        URI releasePackages = URI.createURI((String)"http://download.eclipse.org/eclipse/downloads/");
        this.getPlatformPackageBrandingSites(releasePackages);
        this.getPlatformPackageBrandingSites(URI.createURI((String)"http://archive.eclipse.org/eclipse/downloads/"));
        packageLocationLoader.perform(locations);
    }

    private boolean isIncubating(URI siteURI) {
        return Pattern.compile("incubat", 2).matcher(siteURI.toString()).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeneralPackageBrandingSites(URI releasePackages) {
        block12: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("^\\s+<a href=\"([^\"]+)\" title=[^>]*>([^<]+)</a>\\s*$");
                    for (String line : lines) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageName = matcher.group(2);
                        String key = this.getKey(packageName);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(releasePackages);
                        }
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            block8: for (Map.Entry<String, Map<URI, Map<String, URI>>> releaseEntry : this.sites.entrySet()) {
                                for (Map.Entry<URI, Map<String, URI>> productEntry : releaseEntry.getValue().entrySet()) {
                                    if (!releasePackages.equals(productEntry.getKey())) continue;
                                    System.out.println(String.valueOf(releaseEntry.getKey()) + " -> " + packageName + " -> " + packageURI);
                                    productEntry.getValue().put(key, packageURI);
                                    break block8;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlatformPackageBrandingSites(URI releasePackages) {
        block11: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("<a href=\"([^\"]+)\"[^>]*>(4\\.[0-9.]+)[^<]*</a>");
                    for (String line : lines) {
                        int minorVersionIndex;
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageVersion = matcher.group(2);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(releasePackages);
                        }
                        int version = Integer.parseInt((minorVersionIndex = packageVersion.indexOf(46, 3)) == -1 ? packageVersion.substring(2) : packageVersion.substring(2, minorVersionIndex));
                        List<String> trains = Arrays.asList(this.getTrains());
                        int index = trains.indexOf("neon") - (6 - version);
                        if (index < 0 || index >= trains.size()) continue;
                        String train = trains.get(index);
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            Map<String, URI> packageLocations;
                            Iterator<Map<String, URI>> iterator;
                            Map<URI, Map<String, URI>> releaseLocations = this.sites.get(train);
                            if (releaseLocations != null && (iterator = releaseLocations.values().iterator()).hasNext() && !(packageLocations = iterator.next()).containsKey("Platform")) {
                                System.out.println(String.valueOf(train) + " -> " + packageVersion + " -> " + packageURI);
                                packageLocations.put("Platform", packageURI);
                                packageLocations.put("SDK", packageURI);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    private Set<String> getRootInstallIUs(String release, IInstallableUnit productIU) {
        TreeSet<String> rootInstallIUs = new TreeSet<String>();
        for (IRequirement requirement : productIU.getRequirements()) {
            String value;
            IRequiredCapability capability;
            IMatchExpression filter;
            if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) == null || !EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter)) || capability.getName().startsWith("org.eclipse.justj.")) continue;
            rootInstallIUs.add(capability.getName());
        }
        return rootInstallIUs;
    }

    private Macro getJREs() throws ProvisionException, URISyntaxException {
        Macro jreMacro = SetupFactory.eINSTANCE.createMacro();
        jreMacro.setName("jre");
        jreMacro.setLabel("JRE");
        jreMacro.setDescription("The JRE macro provides tasks for installing JREs from JustJ's p2 update sites");
        IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
        IMetadataRepository jreRepository = manager.loadRepository(new java.net.URI(JUSTJ_JRES), null);
        IQueryResult features = jreRepository.query(QueryUtil.createIUGroupQuery(), null);
        TreeSet ius = new TreeSet(Collections.reverseOrder());
        for (IInstallableUnit iu : features) {
            if (!iu.getId().endsWith(".full.feature.group")) continue;
            ius.add(iu);
        }
        TreeMap<Version, IInstallableUnit> jreVersions = new TreeMap<Version, IInstallableUnit>();
        for (IInstallableUnit iInstallableUnit : ius) {
            OSGiVersion osgiVersion;
            Version jreVersion;
            Version version = iInstallableUnit.getVersion();
            if (!(version instanceof OSGiVersion) || jreVersions.containsKey(jreVersion = Version.createOSGi((int)(osgiVersion = (OSGiVersion)version).getMajor(), (int)osgiVersion.getMinor(), (int)0))) continue;
            jreVersions.put(jreVersion, iInstallableUnit);
        }
        for (Map.Entry entry : jreVersions.entrySet()) {
            IInstallableUnit iu = (IInstallableUnit)entry.getValue();
            IMetadataRepository childRepository = this.findRepository(jreRepository, iu);
            System.out.println("jre=" + iu + " -> " + childRepository.getLocation());
            Requirement jreRequirement = P2Factory.eINSTANCE.createRequirement(iu.getId());
            Repository jreChildRepository = P2Factory.eINSTANCE.createRepository(childRepository.getLocation().toString());
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            p2Task.getRequirements().add((Object)jreRequirement);
            p2Task.getRepositories().add((Object)jreChildRepository);
            OSGiVersion osgiVersion = (OSGiVersion)iu.getVersion();
            Version jreVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro());
            p2Task.setLabel("JRE " + jreVersion);
            String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
            p2Task.setDescription(description);
            jreMacro.getSetupTasks().add((Object)p2Task);
        }
        return jreMacro;
    }

    private IMetadataRepository findRepository(IMetadataRepository repository, IInstallableUnit iu) throws URISyntaxException, ProvisionException {
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = this.manager.loadRepository(childURI = new java.net.URI(this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString())).toString()), null);
                if (childRepository.query(QueryUtil.createIUQuery((String)iu.getId(), (Version)iu.getVersion()), null).isEmpty()) continue;
                return this.findRepository(childRepository, iu);
            }
            throw new IllegalStateException("The iu " + iu + " is not found");
        }
        return repository;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageLocationLoader
    extends WorkerPool<PackageLocationLoader, URI, LoadJob> {
        private ProductCatalogGenerator generator;

        public PackageLocationLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(URI key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LoadJob
        extends WorkerPool.Worker<URI, PackageLocationLoader> {
            private LoadJob(PackageLocationLoader loader, URI uri, int id, boolean secondary) {
                super("Load " + uri, (WorkerPool)loader, (Object)uri, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                PackageLocationLoader.this.generator.getGeneralPackageBrandingSites((URI)this.getKey());
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProductGenerator
    extends WorkerPool<ProductGenerator, String, GenerateJob> {
        private ProductCatalogGenerator generator;

        public ProductGenerator(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected GenerateJob createWorker(String key, int workerID, boolean secondary) {
            return new GenerateJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GenerateJob
        extends WorkerPool.Worker<String, ProductGenerator> {
            private GenerateJob(ProductGenerator loader, String productID, int id, boolean secondary) {
                super("Load " + productID, (WorkerPool)loader, (Object)productID, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    ProductGenerator.this.generator.generateProduct((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryLoader
    extends WorkerPool<RepositoryLoader, String, LoadJob> {
        private ProductCatalogGenerator generator;

        public RepositoryLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(String key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LoadJob
        extends WorkerPool.Worker<String, RepositoryLoader> {
            private LoadJob(RepositoryLoader loader, String train, int id, boolean secondary) {
                super("Load " + train, (WorkerPool)loader, (Object)train, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    RepositoryLoader.this.generator.generate((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrainAndVersion {
        private final String train;
        private final Version version;
        private final Map<String, Set<IInstallableUnit>> ius;
        private final URI trainURI;
        private URI eppURI;

        public TrainAndVersion(String train, Version version, URI trainURI, URI eppURI, Map<String, Set<IInstallableUnit>> ius) {
            this.train = train;
            this.version = version;
            this.trainURI = trainURI;
            this.eppURI = eppURI;
            this.ius = ius;
        }

        public String getTrain() {
            return this.train;
        }

        public Version getVersion() {
            return this.version;
        }

        public URI getTrainURI() {
            return this.trainURI;
        }

        public URI getEPPURI() {
            return this.eppURI;
        }

        public Map<String, Set<IInstallableUnit>> getIUs() {
            return this.ius;
        }

        public String toString() {
            return this.train + "->" + this.version;
        }
    }
}

