/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.GeneralDropAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.RepositoryProvider;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.RepositoryManager;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryExplorer
extends ViewPart
implements SearchField.FilterHandler {
    public static final String ID = "org.eclipse.oomph.p2.ui.RepositoryExplorer";
    private static final IDialogSettings SETTINGS = P2UIPlugin.INSTANCE.getDialogSettings(RepositoryExplorer.class.getSimpleName());
    private static final int DND_OPERATIONS = 7;
    private static final Transfer[] DND_TRANSFERS = OomphTransferDelegate.asTransfers((List)OomphTransferDelegate.DELEGATES).toArray(new Transfer[OomphTransferDelegate.asTransfers((List)OomphTransferDelegate.DELEGATES).size()]);
    private static final String DEFAULT_CAPABILITY_NAMESPACE = "org.eclipse.equinox.p2.iu";
    private static final String CURRENT_NAMESPACE_KEY = "currentNamespace";
    private static final String EXPERT_MODE_KEY = "expertMode";
    private static final String CATEGORIZE_ITEMS_KEY = "categorizeItems";
    private static final String VERSION_SEGMENT_KEY = "versionSegment";
    private static final String COMPATIBLE_VERSION_KEY = "compatibleVersion";
    private static final String SOURCE_SUFFIX = ".source";
    private static final String FEATURE_SUFFIX = ".feature.group";
    private static final String SOURCE_FEATURE_SUFFIX = ".source.feature.group";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final Color WHITE = Display.getCurrent().getSystemColor(1);
    private final LoadJob loadJob = new LoadJob();
    private final AnalyzeJob analyzeJob = new AnalyzeJob();
    private final Mode categoriesMode = new CategoriesMode();
    private final Mode featuresMode = new FeaturesMode();
    private final Mode capabilitiesMode = new CapabilitiesMode();
    private final RepositoryFocusListener repositoryFocusListener = new RepositoryFocusListener();
    private final RepositoryHistoryListener repositoryHistoryListener = new RepositoryHistoryListener();
    private final VersionProvider versionProvider = new VersionProvider();
    private final CollapseAllAction collapseAllAction = new CollapseAllAction();
    private Color gray;
    private Composite container;
    private ComboViewer repositoryViewer;
    private CCombo repositoryCombo;
    private RepositoryProvider.Metadata repositoryProvider;
    private Composite selectorComposite;
    private Composite itemsComposite;
    private StructuredViewer itemsViewer;
    private CategoryItem itemsViewerInput;
    private TableViewer versionsViewer;
    private String currentNamespace = SETTINGS.get("currentNamespace");
    private boolean expertMode;
    private boolean categorizeItems;
    private boolean compatibleVersion;
    private Mode mode;
    private IQueryResult<IInstallableUnit> installableUnits;
    private String filter;

    public RepositoryExplorer() {
        if (this.currentNamespace == null) {
            this.currentNamespace = DEFAULT_CAPABILITY_NAMESPACE;
        }
        this.expertMode = SETTINGS.getBoolean(EXPERT_MODE_KEY);
        String value = SETTINGS.get(CATEGORIZE_ITEMS_KEY);
        this.categorizeItems = value == null || value.length() == 0 ? true : "true".equals(value);
        this.compatibleVersion = SETTINGS.getBoolean(COMPATIBLE_VERSION_KEY);
    }

    public void dispose() {
        this.gray.dispose();
        this.gray = null;
        this.disposeRepositoryProvider();
        super.dispose();
    }

    private void disposeRepositoryProvider() {
        if (this.repositoryProvider != null) {
            this.repositoryProvider.dispose();
            this.repositoryProvider = null;
        }
    }

    public void setFocus() {
        if (RepositoryManager.INSTANCE.getActiveRepository() != null) {
            this.repositoryCombo.setFocus();
        }
    }

    private void updateMode() {
        Mode mode;
        Mode mode2 = this.expertMode ? this.capabilitiesMode : (mode = this.categorizeItems ? this.categoriesMode : this.featuresMode);
        if (this.mode != mode) {
            this.mode = mode;
            GridLayout selectorLayout = new GridLayout();
            selectorLayout.marginWidth = 0;
            selectorLayout.marginHeight = 0;
            this.selectorComposite.setLayout((Layout)selectorLayout);
            mode.fillSelector(this.selectorComposite);
            this.selectorComposite.layout();
            this.selectorComposite.getParent().layout();
            mode.fillItems(this.itemsComposite);
            this.itemsComposite.layout();
            this.itemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.itemsViewer.getSelection();
                    if (selection.size() == 1) {
                        RepositoryExplorer.this.versionsViewer.setInput(selection.getFirstElement());
                    } else {
                        RepositoryExplorer.this.versionsViewer.setInput(null);
                    }
                }
            });
            this.analyzeJob.reschedule();
            this.collapseAllAction.updateEnablement();
        }
    }

    private void setItems(Item ... items) {
        if (!this.container.isDisposed()) {
            this.versionsViewer.setInput(null);
            this.itemsViewerInput = new CategoryItem();
            this.itemsViewerInput.setChildren(items);
            this.itemsViewer.setInput((Object)this.itemsViewerInput);
            if (this.itemsViewer instanceof TreeViewer && this.filter != null) {
                TreeViewer treeViewer = (TreeViewer)this.itemsViewer;
                treeViewer.expandAll();
            }
        }
    }

    private boolean isFiltered(String string) {
        return this.filter == null || string == null || string.toLowerCase().contains(this.filter);
    }

    public void handleFilter(String filter) {
        this.filter = filter == null || filter.length() == 0 ? null : filter.toLowerCase();
        this.analyzeJob.reschedule();
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.gray = new Color((Device)display, 75, 75, 75);
        this.container = new Composite(parent, 0);
        this.container.setBackground(WHITE);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.createRepositoriesArea(this.container);
        this.createItemsArea(this.container);
        this.createVersionsArea(this.container);
        this.updateMode();
        String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
        if (activeRepository == null) {
            this.repositoryFocusListener.focusLost(null);
        } else {
            this.repositoryCombo.setText(activeRepository);
            this.triggerLoad(activeRepository);
        }
        this.hookActions();
    }

    private static CCombo createCombo(Composite parent, int style, boolean grabExcessHorizontalSpace) {
        CCombo combo = new CCombo(parent, style);
        GridData layoutData = new GridData(4, 4, grabExcessHorizontalSpace, false);
        int increaseHeight = 0;
        String ws = Platform.getWS();
        if ("cocoa".equals(ws)) {
            increaseHeight = 7;
        } else if ("gtk".equals(ws)) {
            increaseHeight = 9;
        }
        if (increaseHeight != 0) {
            FontData[] fontData = combo.getFont().getFontData();
            layoutData.heightHint = fontData[0].getHeight() + increaseHeight;
        }
        combo.setLayoutData((Object)layoutData);
        return combo;
    }

    private void createRepositoriesArea(Composite container) {
        this.repositoryCombo = RepositoryExplorer.createCombo(container, 2048, true);
        this.repositoryCombo.setToolTipText("Repository location (type a URL, drop a repository or pick from the drop down history)");
        this.repositoryCombo.addFocusListener((FocusListener)this.repositoryFocusListener);
        this.repositoryCombo.addKeyListener((KeyListener)this.repositoryHistoryListener);
        this.repositoryViewer = new ComboViewer(this.repositoryCombo);
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repositoryViewer.setInput((Object)RepositoryManager.INSTANCE);
        this.repositoryViewer.addSelectionChangedListener((ISelectionChangedListener)this.repositoryHistoryListener);
        this.repositoryViewer.addDropSupport(7, DND_TRANSFERS, (DropTargetListener)new GeneralDropAdapter((Viewer)this.repositoryViewer, (EObject)P2Factory.eINSTANCE.createRepositoryList(), P2Package.Literals.REPOSITORY_LIST__REPOSITORIES, new GeneralDropAdapter.DroppedObjectHandler(){

            public void handleDroppedObject(Object object) throws Exception {
                Repository repository;
                String url;
                if (object instanceof Repository && !StringUtil.isEmpty((String)(url = (repository = (Repository)object).getURL()))) {
                    RepositoryExplorer.this.activateAndLoadRepository(url);
                }
            }
        }));
    }

    private void createItemsArea(Composite parent) {
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        Composite container = new Composite(parent, 0);
        container.setBackground(WHITE);
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        SearchField searchField = new SearchField(container, this){

            protected void finishFilter() {
                RepositoryExplorer.this.itemsViewer.getControl().setFocus();
                this.selectFirstLeaf(RepositoryExplorer.this.itemsViewerInput);
            }

            private void selectFirstLeaf(CategoryItem category) {
                Item[] children = category.getChildren();
                if (children != null && children.length != 0) {
                    Item firstChild = children[0];
                    if (firstChild instanceof CategoryItem) {
                        CategoryItem firstCategory = (CategoryItem)firstChild;
                        this.selectFirstLeaf(firstCategory);
                    } else {
                        RepositoryExplorer.this.itemsViewer.setSelection((ISelection)new StructuredSelection((Object)firstChild));
                    }
                }
            }
        };
        searchField.setLayoutData((Object)new GridData(4, 128, true, false));
        this.selectorComposite = new Composite(container, 0);
        this.selectorComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.selectorComposite.setBackground(WHITE);
        this.itemsComposite = new Composite(container, 0);
        this.itemsComposite.setBackground(WHITE);
        this.itemsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.itemsComposite.setLayout((Layout)new FillLayout());
    }

    private void createVersionsArea(Composite container) {
        Composite versionsComposite = new Composite(container, 0);
        versionsComposite.setBackground(WHITE);
        GridLayout gl_versionsComposite = new GridLayout(2, false);
        gl_versionsComposite.marginWidth = 0;
        gl_versionsComposite.marginHeight = 0;
        versionsComposite.setLayout((Layout)gl_versionsComposite);
        versionsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.versionsViewer = new TableViewer(versionsComposite, 2048);
        this.versionsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.versionsViewer.setContentProvider((IContentProvider)this.versionProvider);
        this.versionsViewer.setLabelProvider((IBaseLabelProvider)this.versionProvider);
        this.addDragSupport((StructuredViewer)this.versionsViewer);
        Composite versionsGroup = new Composite(versionsComposite, 0);
        versionsGroup.setBackground(WHITE);
        versionsGroup.setLayout((Layout)new GridLayout(1, false));
        versionsGroup.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Button compatibleButton = new Button(versionsGroup, 32);
        compatibleButton.setText("Compatible");
        compatibleButton.setToolTipText("Show compatible versions");
        compatibleButton.setSelection(this.compatibleVersion);
        final Button majorButton = this.addVersionSegmentButton(versionsGroup, "Major", "Show major versions", VersionSegment.MAJOR);
        final Button minorButton = this.addVersionSegmentButton(versionsGroup, "Minor", "Show minor versions", VersionSegment.MINOR);
        this.addVersionSegmentButton(versionsGroup, "Micro", "Show micro versions", VersionSegment.MICRO);
        this.addVersionSegmentButton(versionsGroup, "Qualifier", "Show qualified versions", VersionSegment.QUALIFIER);
        majorButton.setEnabled(!this.compatibleVersion);
        compatibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean compatible = compatibleButton.getSelection();
                if (RepositoryExplorer.this.compatibleVersion != compatible) {
                    RepositoryExplorer.this.compatibleVersion = compatible;
                    SETTINGS.put(RepositoryExplorer.COMPATIBLE_VERSION_KEY, RepositoryExplorer.this.compatibleVersion);
                    majorButton.setEnabled(!compatible);
                    if (compatible && RepositoryExplorer.this.versionProvider.getVersionSegment() == VersionSegment.MAJOR) {
                        majorButton.setSelection(false);
                        minorButton.setSelection(true);
                        RepositoryExplorer.this.versionProvider.setVersionSegment(VersionSegment.MINOR);
                    }
                }
            }
        });
    }

    private Button addVersionSegmentButton(Composite parent, String text, String toolTip, final VersionSegment versionSegment) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setToolTipText(toolTip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryExplorer.this.versionProvider.setVersionSegment(versionSegment);
            }
        });
        if (versionSegment == this.versionProvider.getVersionSegment()) {
            button.setSelection(true);
        }
        return button;
    }

    private void hookActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IContributionItem)new Separator("additions"));
        toolbarManager.add((IAction)this.collapseAllAction);
        toolbarManager.add((IAction)new Action("Refresh", P2UIPlugin.INSTANCE.getImageDescriptor("refresh")){
            {
                this.setToolTipText("Reload the active repository and refresh the tree");
            }

            public void run() {
                String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
                if (activeRepository != null) {
                    RepositoryExplorer.this.disposeRepositoryProvider();
                    RepositoryExplorer.this.triggerLoad(activeRepository);
                }
            }
        });
        toolbarManager.add((IContributionItem)new Separator("modes"));
        toolbarManager.add((IAction)new Action("Expert Mode", 2){
            {
                this.setImageDescriptor(P2UIPlugin.INSTANCE.getImageDescriptor("obj16/capability"));
                this.setChecked(RepositoryExplorer.this.expertMode);
            }

            public void run() {
                RepositoryExplorer.this.expertMode = this.isChecked();
                SETTINGS.put(RepositoryExplorer.EXPERT_MODE_KEY, RepositoryExplorer.this.expertMode);
                RepositoryExplorer.this.updateMode();
            }
        });
        toolbarManager.add((IContributionItem)new Separator("end"));
    }

    private void activateAndLoadRepository(String repository) {
        if (RepositoryManager.INSTANCE.setActiveRepository(repository)) {
            this.triggerLoad(repository);
        }
    }

    private void triggerLoad(String repository) {
        URI location;
        block5: {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                repository = manager.performStringSubstitution(repository);
            }
            catch (Exception exception) {}
            location = null;
            try {
                location = new URI(repository);
            }
            catch (URISyntaxException uRISyntaxException) {
                File folder = new File(repository);
                if (!folder.isDirectory()) break block5;
                location = folder.toURI();
            }
        }
        if (location != null) {
            this.loadJob.reschedule(location);
        }
    }

    private void addDragSupport(StructuredViewer viewer) {
        viewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)new GeneralDragAdapter((Viewer)viewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<EObject> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<EObject> result = new ArrayList<EObject>();
                IStructuredSelection ssel = (IStructuredSelection)selection;
                for (Object element : ssel) {
                    Item item;
                    String namespace;
                    VersionRange versionRange = VersionRange.emptyRange;
                    if (element instanceof VersionProvider.ItemVersion) {
                        VersionProvider.ItemVersion itemVersion = (VersionProvider.ItemVersion)element;
                        Version version = itemVersion.getVersion();
                        VersionSegment versionSegment = RepositoryExplorer.this.versionProvider.getVersionSegment();
                        versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment, RepositoryExplorer.this.compatibleVersion);
                        element = ((IStructuredSelection)RepositoryExplorer.this.itemsViewer.getSelection()).getFirstElement();
                    }
                    if (!(element instanceof Item) || (namespace = (item = (Item)element).getNamespace()) == null) continue;
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    requirement.setNamespace(namespace);
                    requirement.setName(item.getName());
                    requirement.setVersionRange(versionRange);
                    result.add((EObject)requirement);
                }
                return result;
            }
        }));
    }

    private static String[] sortStrings(Collection<String> c) {
        Object[] array = c.toArray(new String[c.size()]);
        Arrays.sort(array);
        return array;
    }

    private static String[] getMinimalFlavors(Set<String> flavors) {
        String[] flavorIDs = RepositoryExplorer.sortStrings(flavors);
        int start = 0;
        while (start < flavorIDs.length) {
            boolean changed = false;
            int i = start + 1;
            while (i < flavorIDs.length) {
                String flavorID = flavorIDs[i];
                if (flavorID.startsWith(flavorIDs[start])) {
                    flavors.remove(flavorID);
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                flavorIDs = RepositoryExplorer.sortStrings(flavors);
            }
            ++start;
        }
        return flavorIDs;
    }

    private static String getName(IInstallableUnit iu) {
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (StringUtil.isEmpty((String)name)) {
            return iu.getId();
        }
        return name;
    }

    private static boolean isCategory(IInstallableUnit iu) {
        return "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"));
    }

    private static boolean isFeature(IInstallableUnit iu) {
        return iu.getId().endsWith(FEATURE_SUFFIX);
    }

    public static boolean explore(String repository) {
        IWorkbenchPage page;
        IWorkbenchWindow window = UIUtil.WORKBENCH.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart view = page.findView(ID);
            if (view == null) {
                try {
                    view = page.showView(ID);
                }
                catch (PartInitException ex) {
                    P2UIPlugin.INSTANCE.log(ex);
                }
            }
            if (view instanceof RepositoryExplorer) {
                RepositoryExplorer explorer = (RepositoryExplorer)view;
                explorer.activateAndLoadRepository(repository);
                return true;
            }
        }
        return false;
    }

    private final class AnalyzeJob
    extends SafeJob {
        public AnalyzeJob() {
            super("Analyzing repository");
        }

        public void reschedule() {
            this.cancel();
            if (RepositoryExplorer.this.installableUnits != null) {
                this.schedule();
            }
        }

        protected void doSafe(IProgressMonitor monitor) throws Throwable {
            RepositoryExplorer.this.mode.analyzeInstallableUnits(monitor);
        }
    }

    private final class CapabilitiesMode
    extends Mode {
        private ComboViewer namespaceViewer;

        private CapabilitiesMode() {
        }

        public void fillSelector(Composite parent) {
            this.disposeChildren(parent);
            CCombo namespaceCombo = RepositoryExplorer.createCombo(parent, 0x800808, false);
            namespaceCombo.setToolTipText("Select the namespace of the capabilities to show");
            this.namespaceViewer = new ComboViewer(namespaceCombo);
            this.namespaceViewer.setSorter(new ViewerSorter());
            this.namespaceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.namespaceViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.namespaceViewer.setInput((Object)new String[]{RepositoryExplorer.this.currentNamespace});
            this.namespaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)CapabilitiesMode.this.namespaceViewer.getSelection();
                    String newNamespace = (String)selection.getFirstElement();
                    if (!ObjectUtil.equals((Object)newNamespace, (Object)RepositoryExplorer.this.currentNamespace)) {
                        SETTINGS.put(RepositoryExplorer.CURRENT_NAMESPACE_KEY, newNamespace);
                        RepositoryExplorer.this.currentNamespace = newNamespace;
                        RepositoryExplorer.this.analyzeJob.reschedule();
                    }
                }
            });
            this.namespaceViewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryExplorer.this.currentNamespace));
        }

        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TableViewer capabilitiesViewer = new TableViewer(parent, 268437506);
            capabilitiesViewer.setUseHashlookup(true);
            capabilitiesViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            capabilitiesViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
            RepositoryExplorer.this.addDragSupport((StructuredViewer)capabilitiesViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)capabilitiesViewer;
        }

        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashSet<String> flavors = new HashSet<String>();
            final HashSet<String> namespaces = new HashSet<String>();
            HashMap versions = new HashMap();
            for (IInstallableUnit iu : RepositoryExplorer.this.installableUnits) {
                for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                    Version version;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    String namespace = capability.getNamespace();
                    String name = capability.getName();
                    if ("org.eclipse.equinox.p2.flavor".equals(namespace)) {
                        flavors.add(name);
                    } else if (!"A.PDE.Target.Platform".equalsIgnoreCase(namespace)) {
                        namespaces.add(namespace);
                    }
                    if (!ObjectUtil.equals((Object)namespace, (Object)RepositoryExplorer.this.currentNamespace) || !RepositoryExplorer.this.isFiltered(name) || (version = capability.getVersion()) == null || Version.emptyVersion.equals(version)) continue;
                    CollectionUtil.add(versions, (Object)name, (Object)version);
                }
            }
            String[] flavorIDs = RepositoryExplorer.getMinimalFlavors(flavors);
            Iterator it = namespaces.iterator();
            block2: while (it.hasNext()) {
                String namespace = (String)it.next();
                int i = 0;
                while (i < flavorIDs.length) {
                    String flavor = flavorIDs[i];
                    if (namespace.startsWith(flavor)) {
                        it.remove();
                        continue block2;
                    }
                    ++i;
                }
            }
            if (!namespaces.contains(RepositoryExplorer.this.currentNamespace)) {
                String newCurrentNamespace = null;
                if (namespaces.contains(RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE)) {
                    newCurrentNamespace = RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE;
                } else if (!namespaces.isEmpty()) {
                    newCurrentNamespace = (String)namespaces.iterator().next();
                }
                if (newCurrentNamespace != null) {
                    RepositoryExplorer.this.currentNamespace = newCurrentNamespace;
                    this.analyzeInstallableUnits(monitor);
                    return;
                }
            }
            final CapabilityItem[] capabilityItems = new CapabilityItem[versions.size()];
            Iterator iterator = versions.keySet().iterator();
            int i = 0;
            while (i < capabilityItems.length) {
                String id = (String)iterator.next();
                CapabilityItem capabilityItem = new CapabilityItem();
                capabilityItem.setVersions((Set)versions.get(id));
                capabilityItem.setNamespace(RepositoryExplorer.this.currentNamespace);
                capabilityItem.setLabel(id);
                capabilityItems[i] = capabilityItem;
                ++i;
            }
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!RepositoryExplorer.this.container.isDisposed()) {
                        RepositoryExplorer.this.setItems(capabilityItems);
                        CapabilitiesMode.this.namespaceViewer.setInput((Object)namespaces);
                        CapabilitiesMode.this.namespaceViewer.getCCombo().pack();
                        RepositoryExplorer.this.selectorComposite.getParent().layout();
                        UIUtil.asyncExec((Runnable)new Runnable(){

                            public void run() {
                                if (!RepositoryExplorer.this.container.isDisposed() && RepositoryExplorer.this.currentNamespace != null) {
                                    CapabilitiesMode.this.namespaceViewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryExplorer.this.currentNamespace));
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private static final class CapabilityItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/capability");
        private static final Image FEATURE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactFeature");
        private static final Image PLUGIN_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactPlugin");
        private static final Image PACKAGE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("full/obj16/Requirement_Package");
        private String namespace;

        private CapabilityItem() {
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public Image getImage() {
            if (RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals(this.namespace)) {
                if (this.getLabel().endsWith(RepositoryExplorer.FEATURE_SUFFIX)) {
                    return FEATURE_IMAGE;
                }
                return PLUGIN_IMAGE;
            }
            if ("java.package".equals(this.namespace)) {
                return PACKAGE_IMAGE;
            }
            return IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CategoriesMode
    extends Mode {
        private CategoriesMode() {
        }

        @Override
        public void fillSelector(Composite parent) {
            this.fillCategorySelector(parent);
        }

        @Override
        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TreeViewer categoriesViewer = new TreeViewer(parent, 2050);
            categoriesViewer.setUseHashlookup(true);
            categoriesViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            categoriesViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
            RepositoryExplorer.this.addDragSupport((StructuredViewer)categoriesViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)categoriesViewer;
        }

        @Override
        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashMap<String, String> names = new HashMap<String, String>();
            HashMap<String, Set<IInstallableUnit>> ius = new HashMap<String, Set<IInstallableUnit>>();
            HashMap<String, Set<IRequirement>> categories = new HashMap<String, Set<IRequirement>>();
            for (IInstallableUnit iu : RepositoryExplorer.this.installableUnits) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                Iterator id = iu.getId();
                names.put((String)((Object)id), RepositoryExplorer.getName(iu));
                CollectionUtil.add(ius, id, (Object)iu);
                if (!RepositoryExplorer.isCategory(iu)) continue;
                CollectionUtil.addAll(categories, id, (Collection)iu.getRequirements());
            }
            HashSet<String> rootIDs = new HashSet<String>();
            for (String categoryID : categories.keySet()) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                rootIDs.add(categoryID);
            }
            for (Set requirements : categories.values()) {
                for (IRequirement requirement : requirements) {
                    IRequiredCapability requiredCapability;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    if (!(requirement instanceof IRequiredCapability) || !RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals((requiredCapability = (IRequiredCapability)requirement).getNamespace())) continue;
                    rootIDs.remove(requiredCapability.getName());
                }
            }
            HashSet<CategoryItem> rootCategories = new HashSet<CategoryItem>();
            for (String rootID : rootIDs) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                CategoryItem rootCategory = this.analyzeCategory(names, ius, categories, rootID, monitor);
                if (rootCategory == null) continue;
                rootCategories.add(rootCategory);
            }
            final CategoryItem[] roots = rootCategories.toArray(new CategoryItem[rootCategories.size()]);
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    RepositoryExplorer.this.setItems(roots);
                }
            });
        }

        private CategoryItem analyzeCategory(Map<String, String> names, Map<String, Set<IInstallableUnit>> ius, Map<String, Set<IRequirement>> categories, String categoryID, IProgressMonitor monitor) {
            HashMap<String, Item> children = new HashMap<String, Item>();
            HashMap versions = new HashMap();
            for (IRequirement iRequirement : categories.get(categoryID)) {
                IRequiredCapability requiredCapability;
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                if (!(iRequirement instanceof IRequiredCapability) || !RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals((requiredCapability = (IRequiredCapability)iRequirement).getNamespace())) continue;
                String requiredID = requiredCapability.getName();
                if (categories.containsKey(requiredID)) {
                    CategoryItem child = this.analyzeCategory(names, ius, categories, requiredID, monitor);
                    if (child == null) continue;
                    children.put(requiredID, child);
                    continue;
                }
                VersionRange range = requiredCapability.getRange();
                Item child = (Item)children.get(requiredID);
                Set<IInstallableUnit> set = ius.get(requiredID);
                for (IInstallableUnit iu : set) {
                    String name;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    Version version = iu.getVersion();
                    if (!range.isIncluded(version)) continue;
                    if (child == null && RepositoryExplorer.this.isFiltered(name = names.get(requiredID))) {
                        String mainID;
                        String mainName;
                        if (RepositoryExplorer.isFeature(iu)) {
                            if (requiredID.endsWith(RepositoryExplorer.SOURCE_FEATURE_SUFFIX) && ObjectUtil.equals((Object)name, (Object)(mainName = names.get(mainID = String.valueOf(requiredID.substring(0, requiredID.length() - RepositoryExplorer.SOURCE_FEATURE_SUFFIX.length())) + RepositoryExplorer.FEATURE_SUFFIX)))) {
                                name = String.valueOf(name) + " (Source)";
                            }
                            child = new FeatureItem(requiredID);
                        } else {
                            if (requiredID.endsWith(RepositoryExplorer.SOURCE_SUFFIX) && ObjectUtil.equals((Object)name, (Object)(mainName = names.get(mainID = requiredID.substring(0, requiredID.length() - RepositoryExplorer.SOURCE_SUFFIX.length()))))) {
                                name = String.valueOf(name) + " (Source)";
                            }
                            child = new PluginItem(requiredID);
                        }
                        child.setLabel(name);
                        children.put(requiredID, child);
                    }
                    if (child == null) continue;
                    CollectionUtil.add(versions, (Object)child, (Object)version);
                }
            }
            for (Map.Entry entry : versions.entrySet()) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                Item child = (Item)entry.getKey();
                if (!(child instanceof VersionedItem)) continue;
                VersionedItem versionedItem = (VersionedItem)child;
                versionedItem.setVersions((Set)entry.getValue());
            }
            if (children.isEmpty()) {
                return null;
            }
            CategoryItem categoryItem = new CategoryItem();
            categoryItem.setLabel(names.get(categoryID));
            categoryItem.setChildren(children.values().toArray(new Item[children.size()]));
            return categoryItem;
        }
    }

    private static final class CategoryItem
    extends Item {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/category");
        private Item[] children;

        private CategoryItem() {
        }

        public Image getImage() {
            return IMAGE;
        }

        public boolean hasChildren() {
            return this.children != null && this.children.length != 0;
        }

        public Item[] getChildren() {
            return this.children;
        }

        public void setChildren(Item[] children) {
            Arrays.sort(children);
            this.children = children;
        }

        public String getNamespace() {
            return null;
        }

        protected Integer getCategoryOrder() {
            return CATEGORY_ORDER;
        }
    }

    private final class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("Collapse All", P2UIPlugin.INSTANCE.getImageDescriptor("collapse-all"));
            this.setToolTipText("Collapse all tree items");
            this.updateEnablement();
        }

        public void updateEnablement() {
            this.setEnabled(RepositoryExplorer.this.itemsViewer instanceof TreeViewer);
        }

        public void run() {
            if (RepositoryExplorer.this.itemsViewer instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)RepositoryExplorer.this.itemsViewer;
                treeViewer.collapseAll();
            }
        }
    }

    private static final class ErrorItem
    extends Item {
        private final IStatus status;

        public ErrorItem(IStatus status) {
            this.status = status;
        }

        public Image getImage() {
            return UIUtil.getStatusImage((int)this.status.getSeverity());
        }

        public String getLabel() {
            return this.status.getMessage();
        }
    }

    private static final class FeatureItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactFeature");
        private final String id;

        public FeatureItem(String id) {
            this.id = id;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getName() {
            return this.id;
        }
    }

    private final class FeaturesMode
    extends Mode {
        private FeaturesMode() {
        }

        public void fillSelector(Composite parent) {
            this.fillCategorySelector(parent);
        }

        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TableViewer featuresViewer = new TableViewer(parent, 268437506);
            featuresViewer.setUseHashlookup(true);
            featuresViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            featuresViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
            RepositoryExplorer.this.addDragSupport((StructuredViewer)featuresViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)featuresViewer;
        }

        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashMap<String, String> names = new HashMap<String, String>();
            HashMap versions = new HashMap();
            for (IInstallableUnit iu : RepositoryExplorer.this.installableUnits) {
                String name;
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                String id = iu.getId();
                if (!id.endsWith(RepositoryExplorer.FEATURE_SUFFIX) || id.endsWith(RepositoryExplorer.SOURCE_FEATURE_SUFFIX) || !RepositoryExplorer.this.isFiltered(name = RepositoryExplorer.getName(iu))) continue;
                names.put(id, name);
                CollectionUtil.add(versions, (Object)id, (Object)iu.getVersion());
            }
            final FeatureItem[] featureItems = new FeatureItem[versions.size()];
            Iterator iterator = versions.keySet().iterator();
            int i = 0;
            while (i < featureItems.length) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                String id = (String)iterator.next();
                FeatureItem featureItem = new FeatureItem(id);
                featureItem.setVersions((Set)versions.get(id));
                featureItem.setLabel((String)names.get(id));
                featureItems[i] = featureItem;
                ++i;
            }
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    RepositoryExplorer.this.setItems(featureItems);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Item
    implements Comparable<Item> {
        protected static final Integer CATEGORY_ORDER = 0;
        protected static final Integer NON_CATEGORY_ORDER = 1;
        private String label;

        public abstract Image getImage();

        public String getNamespace() {
            return RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE;
        }

        public String getName() {
            return this.getLabel();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Item[] getChildren() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public String toString() {
            return this.label;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int compareTo(Item o) {
            Integer category2;
            Integer category1 = this.getCategoryOrder();
            int result = category1.compareTo(category2 = o.getCategoryOrder());
            if (result == 0) {
                String label1 = this.label.toLowerCase();
                String label2 = o.label.toLowerCase();
                result = label1.compareTo(label2);
            }
            return result;
        }

        protected Integer getCategoryOrder() {
            return NON_CATEGORY_ORDER;
        }
    }

    private final class ItemContentProvider
    implements ITreeContentProvider {
        private ItemContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object[] getChildren(Object element) {
            Object[] children = ((Item)element).getChildren();
            if (children != null) {
                return children;
            }
            return NO_ELEMENTS;
        }

        public boolean hasChildren(Object element) {
            return ((Item)element).hasChildren();
        }
    }

    private static final class ItemLabelProvider
    extends LabelProvider {
        private ItemLabelProvider() {
        }

        public Image getImage(Object element) {
            Item item = (Item)element;
            return item.getImage();
        }

        public String getText(Object element) {
            Item item = (Item)element;
            return item.getLabel();
        }
    }

    private final class LoadJob
    extends SafeJob {
        private URI location;

        public LoadJob() {
            super("Loading repository");
        }

        public void reschedule(URI location) {
            this.location = location;
            RepositoryExplorer.this.setItems(new Item[]{new LoadingItem(location)});
            this.cancel();
            this.schedule();
        }

        protected void doSafe(IProgressMonitor monitor) throws Throwable {
            RepositoryExplorer.this.analyzeJob.cancel();
            RepositoryExplorer.this.installableUnits = null;
            IMetadataRepositoryManager repositoryManager = P2Util.getAgentManager().getCurrentAgent().getMetadataRepositoryManager();
            if (RepositoryExplorer.this.repositoryProvider == null || !RepositoryExplorer.this.repositoryProvider.getLocation().equals(this.location)) {
                RepositoryExplorer.this.disposeRepositoryProvider();
                RepositoryExplorer.this.repositoryProvider = new RepositoryProvider.Metadata(repositoryManager, this.location);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
            IMetadataRepository repository = (IMetadataRepository)RepositoryExplorer.this.repositoryProvider.getRepository((IProgressMonitor)progress.newChild(100));
            if (repository instanceof CompositeMetadataRepository) {
                CompositeMetadataRepository compositeRepository = (CompositeMetadataRepository)repository;
                CompositeRepositoryState state = compositeRepository.toState();
                URI[] children = state.getChildren();
                final ArrayList<ErrorItem> errors = new ArrayList<ErrorItem>();
                HashSet<String> messages = new HashSet<String>();
                URI[] uRIArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    block7: {
                        URI child = uRIArray[n2];
                        try {
                            URI absolute = URIUtil.makeAbsolute((URI)child, (URI)this.location);
                            if (repositoryManager.loadRepository(absolute, null) == null) {
                                throw new ProvisionException("No repository found at " + absolute + ".");
                            }
                        }
                        catch (Exception ex) {
                            IStatus status = P2UIPlugin.INSTANCE.getStatus(ex);
                            if (!messages.add(status.getMessage())) break block7;
                            errors.add(new ErrorItem(status));
                        }
                    }
                    ++n2;
                }
                if (!errors.isEmpty()) {
                    UIUtil.asyncExec((Runnable)new Runnable(){

                        public void run() {
                            RepositoryExplorer.this.setItems(errors.toArray(new Item[errors.size()]));
                        }
                    });
                    return;
                }
            }
            RepositoryExplorer.this.installableUnits = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)progress.newChild(1));
            RepositoryExplorer.this.analyzeJob.reschedule();
        }
    }

    private static final class LoadingItem
    extends Item {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/repository");
        private final URI location;

        public LoadingItem(URI location) {
            this.location = location;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getLabel() {
            return "Loading " + this.location;
        }
    }

    private abstract class Mode {
        private Mode() {
        }

        protected final void disposeChildren(Composite parent) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }

        protected final void fillCategorySelector(Composite parent) {
            Control[] children = parent.getChildren();
            if (children.length == 1 && children[0] instanceof Button) {
                ((Button)children[0]).setSelection(RepositoryExplorer.this.categorizeItems);
                return;
            }
            this.disposeChildren(parent);
            final Button button = new Button(parent, 32);
            button.setText("Group items by category");
            button.setToolTipText("Whether to show items in categories or in a complete list");
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            button.setSelection(RepositoryExplorer.this.categorizeItems);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryExplorer.this.categorizeItems = button.getSelection();
                    SETTINGS.put(RepositoryExplorer.CATEGORIZE_ITEMS_KEY, RepositoryExplorer.this.categorizeItems);
                    RepositoryExplorer.this.updateMode();
                }
            });
        }

        public abstract void fillSelector(Composite var1);

        public abstract void fillItems(Composite var1);

        public abstract void analyzeInstallableUnits(IProgressMonitor var1);
    }

    private static final class PluginItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactPlugin");
        private final String id;

        public PluginItem(String id) {
            this.id = id;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getName() {
            return this.id;
        }
    }

    private final class RepositoryContentProvider
    implements IStructuredContentProvider,
    RepositoryManager.RepositoryManagerListener {
        public RepositoryContentProvider() {
            RepositoryManager.INSTANCE.addListener(this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            RepositoryManager.INSTANCE.removeListener(this);
        }

        public Object[] getElements(Object element) {
            return RepositoryManager.INSTANCE.getRepositories();
        }

        public void repositoriesChanged(RepositoryManager repositoryManager) {
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!RepositoryExplorer.this.container.isDisposed()) {
                        RepositoryExplorer.this.repositoryViewer.refresh();
                        UIUtil.asyncExec((Runnable)new Runnable(){

                            public void run() {
                                if (!RepositoryExplorer.this.container.isDisposed()) {
                                    String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
                                    if (activeRepository == null) {
                                        RepositoryExplorer.this.repositoryViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                        RepositoryExplorer.this.repositoryCombo.setText("");
                                    } else {
                                        StructuredSelection selection = new StructuredSelection((Object)activeRepository);
                                        RepositoryExplorer.this.repositoryViewer.setSelection((ISelection)selection);
                                        RepositoryExplorer.this.repositoryCombo.setText(activeRepository);
                                        RepositoryExplorer.this.repositoryCombo.setSelection(new Point(0, activeRepository.length()));
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }

        public void activeRepositoryChanged(RepositoryManager repositoryManager, String repository) {
        }
    }

    private final class RepositoryFocusListener
    implements FocusListener {
        private Color originalForeground;

        private RepositoryFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (this.originalForeground != null) {
                RepositoryExplorer.this.repositoryCombo.setText("");
                RepositoryExplorer.this.repositoryCombo.setForeground(this.originalForeground);
                this.originalForeground = null;
            }
        }

        public void focusLost(FocusEvent e) {
            String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
            if (activeRepository == null) {
                this.originalForeground = RepositoryExplorer.this.repositoryCombo.getForeground();
                RepositoryExplorer.this.repositoryCombo.setText("type repository url, drag and drop, or pick from list");
                RepositoryExplorer.this.repositoryCombo.setForeground(RepositoryExplorer.this.gray);
            } else if (!activeRepository.equals(RepositoryExplorer.this.repositoryCombo.getText())) {
                RepositoryExplorer.this.repositoryCombo.setText(activeRepository);
            }
        }
    }

    private final class RepositoryHistoryListener
    extends KeyAdapter
    implements ISelectionChangedListener {
        private boolean listVisible;
        private String listRepository;

        private RepositoryHistoryListener() {
        }

        public void keyReleased(KeyEvent e) {
            String repository;
            boolean currentListVisible = RepositoryExplorer.this.repositoryCombo.getListVisible();
            if (currentListVisible && !StringUtil.isEmpty((String)(repository = this.getSelectedRepository()))) {
                this.listRepository = repository;
            }
            if (currentListVisible && (e.keyCode == 127 || e.keyCode == 8)) {
                RepositoryManager.INSTANCE.removeRepository(this.listRepository);
            } else if (e.keyCode == 13 && this.listVisible && !currentListVisible) {
                this.selectRepository();
            }
            this.listVisible = currentListVisible;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.listVisible = RepositoryExplorer.this.repositoryCombo.getListVisible();
            if (!this.listVisible) {
                this.selectRepository();
            }
        }

        private void selectRepository() {
            String newRepository = this.getSelectedRepository();
            RepositoryExplorer.this.activateAndLoadRepository(newRepository);
        }

        private String getSelectedRepository() {
            IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.repositoryViewer.getSelection();
            return selection.isEmpty() ? RepositoryExplorer.this.repositoryCombo.getText() : (String)selection.getFirstElement();
        }
    }

    private abstract class SafeJob
    extends Job {
        public SafeJob(String name) {
            super(name);
        }

        protected final IStatus run(IProgressMonitor monitor) {
            try {
                this.doSafe(monitor);
                return Status.OK_STATUS;
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (Exception ex2) {
                CoreException ex2;
                Throwable cause;
                if (ex2 instanceof P2Exception && (cause = ex2.getCause()) instanceof CoreException) {
                    ex2 = (CoreException)cause;
                }
                final IStatus status = P2UIPlugin.INSTANCE.getStatus(ex2);
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        RepositoryExplorer.this.setItems(new Item[]{new ErrorItem(status)});
                    }
                });
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                return P2UIPlugin.INSTANCE.getStatus(t);
            }
        }

        protected abstract void doSafe(IProgressMonitor var1) throws Throwable;
    }

    private static final class VersionProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/version");
        private TableViewer versionsViewer;
        private VersionSegment versionSegment;

        public VersionProvider() {
            try {
                this.versionSegment = VersionSegment.get((String)SETTINGS.get(RepositoryExplorer.VERSION_SEGMENT_KEY));
            }
            catch (Exception exception) {}
            if (this.versionSegment == null) {
                this.versionSegment = VersionSegment.QUALIFIER;
            }
        }

        public VersionSegment getVersionSegment() {
            return this.versionSegment;
        }

        public void setVersionSegment(VersionSegment versionSegment) {
            if (this.versionSegment != versionSegment) {
                this.versionSegment = versionSegment;
                SETTINGS.put(RepositoryExplorer.VERSION_SEGMENT_KEY, versionSegment.getLiteral());
                if (this.versionsViewer != null) {
                    this.versionsViewer.refresh();
                }
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.versionsViewer = (TableViewer)viewer;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            VersionedItem versionedItem;
            Set<Version> versions;
            if (inputElement instanceof VersionedItem && (versions = (versionedItem = (VersionedItem)inputElement).getVersions()) != null) {
                HashSet<ItemVersion> itemVersions = new HashSet<ItemVersion>();
                for (Version version : versions) {
                    ItemVersion itemVersion = this.getItemVersion(version);
                    itemVersions.add(itemVersion);
                }
                Object[] array = itemVersions.toArray(new ItemVersion[itemVersions.size()]);
                Arrays.sort(array);
                return array;
            }
            return NO_ELEMENTS;
        }

        public Image getImage(Object element) {
            return IMAGE;
        }

        private ItemVersion getItemVersion(Version version) {
            int segments = version.getSegmentCount();
            if (segments == 0) {
                return new ItemVersion(version, "0.0.0");
            }
            segments = Math.min(segments, this.versionSegment.ordinal() + 1);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < segments) {
                String segment = version.getSegment(i).toString();
                if (StringUtil.isEmpty((String)segment)) break;
                if (builder.length() != 0) {
                    builder.append('.');
                }
                builder.append(segment);
                ++i;
            }
            version = Version.create((String)builder.toString());
            if (segments < 3) {
                builder.append(".x");
            }
            return new ItemVersion(version, builder.toString());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ItemVersion
        implements Comparable<ItemVersion> {
            private final Version version;
            private final String label;

            public ItemVersion(Version version, String label) {
                this.version = version;
                this.label = label;
            }

            public Version getVersion() {
                return this.version;
            }

            @Override
            public int compareTo(ItemVersion o) {
                return this.version.compareTo((Object)o.version);
            }

            public int hashCode() {
                return this.version.hashCode();
            }

            public boolean equals(Object obj) {
                return this.version.equals(((ItemVersion)obj).version);
            }

            public String toString() {
                return this.label;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class VersionedItem
    extends Item {
        private Set<Version> versions;

        private VersionedItem() {
        }

        public Set<Version> getVersions() {
            return this.versions;
        }

        public void setVersions(Set<Version> versions) {
            this.versions = versions;
        }
    }
}

