/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;

public abstract class AbstractAttribute
implements IOTConstants {
    protected char[] _name;
    protected byte[] _contents;
    protected int _contentsOffset;
    protected ConstantPool _constantPool;
    protected ClassFileStruct _reader;
    protected int _readOffset;
    protected int _structOffset;
    protected int[] _constantPoolOffsets;
    protected MethodInfo _methodInfo;
    protected static final boolean DEBUG = System.getProperty("ot.otdt.debug") != null;
    Throwable instantiationTime;

    protected AbstractAttribute(char[] name) {
        this._name = name;
        if (DEBUG) {
            this.instantiationTime = new Throwable("Attribute was created in this stack");
        }
    }

    public boolean nameEquals(char[] name) {
        return CharOperation.equals(this._name, name);
    }

    public boolean nameEquals(AbstractAttribute other) {
        return this.nameEquals(other._name);
    }

    public void merge(ModelElement model, AbstractAttribute other) {
        throw new InternalCompilerError("Merge not supported for Attribute " + new String(this._name));
    }

    public boolean setupForWriting() {
        return true;
    }

    public void write(ClassFile classFile) {
        this._contents = classFile.contents;
        this._contentsOffset = classFile.contentsOffset;
        this._constantPool = classFile.constantPool;
    }

    public void generate(byte[] target, int offset, ConstantPool constantPool) {
        ClassFile dummyClass = new ClassFile(){};
        dummyClass.contents = target;
        dummyClass.contentsOffset = offset;
        dummyClass.constantPool = constantPool;
        this.write(dummyClass);
    }

    int size() {
        throw new InternalCompilerError("Generate not supported for Attribute " + new String(this._name));
    }

    public abstract void evaluate(Binding var1, LookupEnvironment var2, char[][][] var3);

    public void checkBindingMismatch(Binding binding, int classKind) {
        Exception ex = null;
        if (!(binding instanceof ReferenceBinding) || !CharOperation.equals(((ReferenceBinding)binding).constantPoolName(), ((ClassFileReader)this._reader).getName())) {
            ex = new Exception("evaluating attribute with mismatching binding");
        } else {
            String className = new String(((ReferenceBinding)binding).readableName());
            switch (classKind) {
                case 0x1000000: {
                    if (((ReferenceBinding)binding).isRole()) break;
                    ex = new Exception("Need a role for this attribute, found " + className);
                    break;
                }
                case 65536: {
                    if (((ReferenceBinding)binding).isTeam()) break;
                    ex = new Exception("Need a team for this attribute, found " + className);
                }
            }
        }
        if (ex != null) {
            Config.logException("Error reading byte code attribute", ex);
        }
        if (ex != null && this.instantiationTime != null) {
            Config.logException("Instantiation time was", this.instantiationTime);
        }
    }

    private final void resizeByteArray() {
        int length = this._contents.length;
        int requiredSize = length + length;
        this._contents = new byte[requiredSize];
        System.arraycopy(this._contents, 0, this._contents, 0, length);
    }

    public void writeName(char[] name) {
        if (this._contentsOffset + 2 > this._contents.length) {
            this.resizeByteArray();
        }
        int valueIndex = this._constantPool.literalIndex(name);
        this._contents[this._contentsOffset++] = (byte)(valueIndex >> 8);
        this._contents[this._contentsOffset++] = (byte)valueIndex;
    }

    public void writeByte(byte b) {
        if (this._contentsOffset + 1 > this._contents.length) {
            this.resizeByteArray();
        }
        this._contents[this._contentsOffset++] = b;
    }

    protected void writeUnsignedShort(int value) {
        if (this._contentsOffset + 2 > this._contents.length) {
            this.resizeByteArray();
        }
        this._contents[this._contentsOffset++] = (byte)(value >>> 8);
        this._contents[this._contentsOffset++] = (byte)value;
    }

    protected void writeInt(int value) {
        if (this._contentsOffset + 4 > this._contents.length) {
            this.resizeByteArray();
        }
        this._contents[this._contentsOffset++] = (byte)(value >> 24);
        this._contents[this._contentsOffset++] = (byte)(value >> 16);
        this._contents[this._contentsOffset++] = (byte)(value >> 8);
        this._contents[this._contentsOffset++] = (byte)value;
    }

    protected void writeBack(ClassFile classFile) {
        classFile.contentsOffset = this._contentsOffset;
        classFile.contents = this._contents;
    }

    protected char[] consumeName() {
        int offset = this._reader.u2At(this._readOffset);
        this._readOffset += 2;
        int utf8Offset = this._constantPoolOffsets[offset] - this._structOffset;
        return this._reader.utf8At(utf8Offset + 3, this._reader.u2At(utf8Offset + 1));
    }

    protected int consumeShort() {
        int result = this._reader.u2At(this._readOffset);
        this._readOffset += 2;
        return result;
    }

    protected int consumeInt() {
        int result = (int)this._reader.u4At(this._readOffset);
        this._readOffset += 4;
        return result;
    }

    protected int consumeByte() {
        int result = this._reader.u1At(this._readOffset);
        ++this._readOffset;
        return result;
    }

    protected char[] toConstantPoolName(char[] name) {
        char[] constantPoolName = CharOperation.concat(name, new char[0]);
        CharOperation.replace(constantPoolName, '.', '/');
        return constantPoolName;
    }

    public boolean evaluate(MethodInfo info, MethodBinding methodBinding, LookupEnvironment environment) {
        return false;
    }

    public boolean evaluate(FieldBinding fieldBinding) {
        return false;
    }

    public void evaluateLateAttribute(ReferenceBinding type, int state) {
    }

    protected ReferenceBinding getResolvedType(LookupEnvironment environment, char[] constantPoolName, char[][][] missingTypeNames) {
        ReferenceBinding type = environment.getTypeFromConstantPoolName(constantPoolName, 0, -1, false, missingTypeNames);
        if (type instanceof UnresolvedReferenceBinding) {
            type = this.resolveReferenceType(environment, (UnresolvedReferenceBinding)type);
        }
        return type;
    }

    ReferenceBinding resolveReferenceType(LookupEnvironment environment, UnresolvedReferenceBinding type) {
        return type.resolve(environment, false);
    }
}

