/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CPTypeAnchorAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticBaseCallSurrogate;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticRoleFieldAccess;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CalloutImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;

public class ConstantPoolObjectReader
extends ClassFileStruct
implements ClassFileConstants {
    private LookupEnvironment _environment;
    private TypeModel _srcModel;

    public ConstantPoolObjectReader(RoleModel srcRole, byte[] reference, LookupEnvironment environment) {
        super(reference, srcRole.getConstantPoolOffsets(), 0);
        this._srcModel = srcRole;
        this._environment = environment;
    }

    public ConstantPoolObjectReader(MethodModel model, TypeModel srcModel, LookupEnvironment environment) {
        super(model.getBytes(), model.getConstantPoolOffsets(), 0);
        this._srcModel = srcModel;
        this._environment = environment;
    }

    public ConstantPoolObjectReader(byte[] bytes, int[] constantPoolOffsets, TypeModel srcModel, LookupEnvironment environment) {
        super(bytes, constantPoolOffsets, 0);
        this._srcModel = srcModel;
        this._environment = environment;
    }

    int getConstantPoolEntryType(int index) {
        int offset = this.constantPoolOffsets[index];
        return this.u1At(offset);
    }

    private int getConstantPoolStartPosition(int index) {
        int start = this.constantPoolOffsets[index];
        return start;
    }

    public ConstantPoolObject readConstantPoolObject(int ref, int length) {
        int type = this.getConstantPoolEntryType(ref);
        switch (type) {
            case 8: {
                return new ConstantPoolObject(type, this.getString(ref), ref);
            }
            case 3: {
                return new ConstantPoolObject(type, this.getInteger(ref));
            }
            case 4: {
                return new ConstantPoolObject(type, this.getFloat(ref));
            }
            case 5: {
                return new ConstantPoolObject(type, this.getLong(ref));
            }
            case 6: {
                return new ConstantPoolObject(type, this.getDouble(ref));
            }
            case 7: {
                return new ConstantPoolObject(type, this.decodeClassEntry(ref));
            }
            case 9: {
                return new ConstantPoolObject(type, this.getFieldRef(ref));
            }
            case 10: {
                return new ConstantPoolObject(type, this.getMethodRef(ref));
            }
            case 11: {
                return new ConstantPoolObject(type, this.getInterfaceMethodRef(ref));
            }
            case 1: {
                return new ConstantPoolObject(type, this.getUtf8(ref));
            }
        }
        throw new RuntimeException();
    }

    public TypeBinding getSignatureBinding(int ref, boolean useGenerics) {
        char[] typeName = this.getUtf8(ref);
        if (useGenerics) {
            return this._environment.getTypeFromTypeSignature(new SignatureWrapper(typeName), Binding.NO_TYPE_VARIABLES, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
        }
        return this._environment.getTypeFromSignature(typeName, 0, typeName.length - 1, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
    }

    private int getInteger(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 3);
        return this.i4At(start + 1);
    }

    private long getLong(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 5);
        return this.i8At(start + 1);
    }

    private float getFloat(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 4);
        return this.floatAt(start + 1);
    }

    private double getDouble(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 6);
        return this.doubleAt(start + 1);
    }

    char[] getUtf8(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 1);
        return this.utf8At(start + 3, this.u2At(start + 1));
    }

    private String getString(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 8);
        return new String(this.getUtf8(this.u2At(start + 1)));
    }

    private TypeBinding decodeClassEntry(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 7);
        int name_index = this.u2At(start + 1);
        char[] name_str = this.getUtf8(name_index);
        int dims = 0;
        while (name_str[dims] == '[') {
            ++dims;
        }
        if (dims == 0) {
            if (name_str[0] == 'L' || name_str[name_str.length - 1] == ';') {
                throw new IncompatibleBytecodeException(name_str, 0);
            }
            return this.getClassBinding(index);
        }
        TypeBinding typeBinding = this._environment.getTypeFromSignature(name_str, 0, -1, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
        if (!typeBinding.leafComponentType().isBaseType()) {
            char[] anchorPath;
            CPTypeAnchorAttribute typeAnchors;
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding.leafComponentType();
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                ReferenceBinding localType = this.findLocalType(CharOperation.subarray(name_str, dims, -1));
                referenceBinding = localType != null ? localType : (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this._environment, false);
            }
            if ((typeAnchors = this._srcModel.getTypeAnchors()) != null && (anchorPath = typeAnchors.getPath(index)) != null) {
                ReferenceBinding teamType = referenceBinding.enclosingType();
                FieldBinding anchor = new FieldBinding(anchorPath, teamType, 16, this._srcModel.getBinding(), Constant.NotAConstant);
                return anchor.getRoleTypeBinding(referenceBinding, dims);
            }
        }
        return typeBinding;
    }

    private MethodBinding getMethodRef(int index) {
        char[] type;
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 10);
        int class_index = this.u2At(start + 1);
        int name_index = this.u2At(start + 3);
        ReferenceBinding class_rb = this.getClassBinding(class_index);
        if (class_rb == null) {
            return null;
        }
        char[][] nameandtype = this.getNameAndType(name_index);
        char[] name = nameandtype[0];
        MethodBinding mb = this.findMethodBinding(class_rb, name, type = nameandtype[1]);
        if (mb == null && CharOperation.endsWith(name, IOTConstants._OT_TAG)) {
            return new MethodBinding(1, name, TypeBinding.SHORT, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, class_rb);
        }
        assert (mb != null);
        return mb;
    }

    private FieldBinding getFieldRef(int index) {
        ReferenceBinding class_rb;
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 9);
        int class_index = this.u2At(start + 1);
        int name_index = this.u2At(start + 3);
        ReferenceBinding actualReceiver = class_rb = this.getClassBinding(class_index);
        if (class_rb == null) {
            return null;
        }
        char[][] nameandtype = this.getNameAndType(name_index);
        char[] name = nameandtype[0];
        char[] type = nameandtype[1];
        FieldBinding fb = null;
        if (class_rb.erasure() instanceof SourceTypeBinding) {
            SourceTypeBinding sourceType = (SourceTypeBinding)class_rb.erasure();
            if (CharOperation.prefixEquals(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, name)) {
                return sourceType.getSyntheticOuterLocal(name);
            }
            if (CharOperation.prefixEquals(TypeConstants.SYNTHETIC_CLASS, name)) {
                return sourceType.getSyntheticClassLiteral(name);
            }
        }
        do {
            if ((fb = this.findFieldBinding(class_rb, name, type)) == null) continue;
            if (TypeBinding.notEquals(actualReceiver, class_rb)) {
                return new FieldBinding(fb, actualReceiver);
            }
            return fb;
        } while (!CharOperation.equals((class_rb = class_rb.superclass()).constantPoolName(), ConstantPool.JavaLangObjectConstantPoolName));
        return fb;
    }

    private MethodBinding getInterfaceMethodRef(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 11);
        int class_index = this.u2At(start + 1);
        int name_index = this.u2At(start + 3);
        ReferenceBinding class_rb = this.getClassBinding(class_index);
        if (class_rb == null) {
            return null;
        }
        char[][] nameandtype = this.getNameAndType(name_index);
        char[] name = nameandtype[0];
        char[] type = nameandtype[1];
        MethodBinding mb = this.findMethodBinding(class_rb, name, type);
        assert (mb != null);
        if (TypeBinding.notEquals(mb.declaringClass, class_rb)) {
            mb = new MethodBinding(mb, class_rb);
        }
        return mb;
    }

    private char[][] getNameAndType(int index) {
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 12);
        int name_index = this.u2At(start + 1);
        int descriptor_index = this.u2At(start + 3);
        char[] name = this.getUtf8(name_index);
        char[] descriptor = this.getUtf8(descriptor_index);
        char[][] result = new char[][]{name, descriptor};
        return result;
    }

    private ReferenceBinding getClassBinding(int index) {
        char[] anchorPath;
        CPTypeAnchorAttribute typeAnchors;
        int start = this.getConstantPoolStartPosition(index);
        assert (this.u1At(start) == 7);
        int name_index = this.u2At(start + 1);
        char[] name_str = this.getUtf8(name_index);
        ReferenceBinding referenceBinding = this._environment.getTypeFromConstantPoolName(name_str, 0, -1, false, null);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ReferenceBinding localType = this.findLocalType(name_str);
            if (localType != null) {
                return localType;
            }
            referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this._environment, false);
        }
        if ((typeAnchors = this._srcModel.getTypeAnchors()) != null && (anchorPath = typeAnchors.getPath(index)) != null) {
            ReferenceBinding teamType = referenceBinding.enclosingType();
            FieldBinding anchor = new FieldBinding(anchorPath, teamType, 16, this._srcModel.getBinding(), Constant.NotAConstant);
            referenceBinding = (ReferenceBinding)anchor.getRoleTypeBinding(referenceBinding, 0);
        }
        return referenceBinding;
    }

    private ReferenceBinding findLocalType(char[] name_str) {
        if (this._srcModel.getBinding().isLocalType() && CharOperation.equals(this._srcModel.getBinding().constantPoolName(), name_str)) {
            return this._srcModel.getBinding();
        }
        if (this._srcModel instanceof RoleModel) {
            Iterator<RoleModel> localTypes = ((RoleModel)this._srcModel).localTypes();
            while (localTypes.hasNext()) {
                RoleModel local = localTypes.next();
                if (!CharOperation.equals(local.getBinding().constantPoolName(), name_str)) continue;
                return local.getBinding();
            }
        }
        return null;
    }

    public MethodBinding findMethodBinding(ReferenceBinding class_rb, char[] name, char[] descriptor) {
        MethodBinding foundMethod;
        boolean isDecapsWrapper = false;
        if (CharOperation.prefixEquals(IOTConstants.OT_DECAPS, name)) {
            isDecapsWrapper = true;
            name = CharOperation.subarray(name, IOTConstants.OT_DECAPS.length, -1);
        }
        if ((foundMethod = this.doFindMethodBinding(class_rb, name, descriptor)) != null && isDecapsWrapper) {
            foundMethod = new MethodBinding(foundMethod, class_rb);
            foundMethod.selector = CharOperation.concat(IOTConstants.OT_DECAPS, name);
        }
        return foundMethod;
    }

    private MethodBinding doFindMethodBinding(ReferenceBinding class_rb, char[] name, char[] descriptor) {
        MethodBinding mb;
        int modifiers;
        MethodBinding[] mbs = class_rb.getMethods(name);
        if (mbs != Binding.NO_METHODS) {
            int i = 0;
            while (i < mbs.length) {
                MethodBinding binding = mbs[i];
                if (binding != null && this.isEqual(binding, name, descriptor)) {
                    return binding;
                }
                ++i;
            }
            if (this.isSynthMethodName(name)) {
                throw new InternalCompilerError("synthetic method " + new String(name) + " has unexpected signature");
            }
        }
        if (this.isSynthMethodName(name) || SyntheticBaseCallSurrogate.isBaseCallSurrogateName(name)) {
            if (class_rb.isBinaryBinding()) {
                if (SyntheticBaseCallSurrogate.isBaseCallSurrogateName(name)) {
                    while ((class_rb = class_rb.superclass()) != null) {
                        MethodBinding candidate = this.doFindMethodBinding(class_rb, name, descriptor);
                        if (candidate == null) continue;
                        return candidate;
                    }
                }
                return null;
            }
            SourceTypeBinding stb = (SourceTypeBinding)class_rb.erasure();
            SyntheticMethodBinding[] accessMethods = stb.syntheticMethods();
            if (accessMethods != null) {
                int i = 0;
                while (i < accessMethods.length) {
                    if (CharOperation.equals(accessMethods[i].selector, name)) {
                        return accessMethods[i];
                    }
                    ++i;
                }
            }
        }
        if (SyntheticRoleFieldAccess.isRoleFieldAccess(4096, name)) {
            if (class_rb.isBinaryBinding()) {
                return null;
            }
            SourceTypeBinding sourceType = (SourceTypeBinding)class_rb.erasure();
            SyntheticMethodBinding[] synthetics = sourceType.syntheticMethods();
            if (synthetics == null) {
                return null;
            }
            SyntheticMethodBinding[] syntheticMethodBindingArray = synthetics;
            int n = synthetics.length;
            int n2 = 0;
            while (n2 < n) {
                SyntheticMethodBinding methodBinding = syntheticMethodBindingArray[n2];
                if (CharOperation.equals(methodBinding.selector, name)) {
                    return methodBinding;
                }
                ++n2;
            }
        }
        if ((modifiers = ConstantPoolObjectReader.isFakedOTREMethod(name)) != 0) {
            MethodBinding fakedMethod = this.createMethodFromSignature(class_rb, modifiers, name, descriptor);
            class_rb.addMethod(fakedMethod);
            return fakedMethod;
        }
        ReferenceBinding currentType = class_rb.superclass();
        if (currentType != null && (mb = this.findMethodBinding(currentType, name, descriptor)) != null) {
            return mb;
        }
        ReferenceBinding[] superIfcs = class_rb.superInterfaces();
        if (superIfcs != null) {
            int i = 0;
            while (i < class_rb.superInterfaces().length) {
                MethodBinding mb2 = this.findMethodBinding(superIfcs[i], name, descriptor);
                if (mb2 != null) {
                    if (!class_rb.isInterface()) {
                        return new MethodBinding(mb2, class_rb);
                    }
                    return mb2;
                }
                ++i;
            }
        }
        return null;
    }

    boolean isSynthMethodName(char[] name) {
        return CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, name) || CharOperation.prefixEquals(TypeConstants.SYNTHETIC_SWITCH_ENUM_TABLE, name) || CharOperation.equals(CalloutImplementorDyn.OT_ACCESS, name) || CharOperation.equals(CalloutImplementorDyn.OT_ACCESS_STATIC, name);
    }

    static int isFakedOTREMethod(char[] name) {
        if (!CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, name)) {
            return 0;
        }
        if (CharOperation.prefixEquals(IOTConstants.OT_GETFIELD, name)) {
            return 9;
        }
        if (CharOperation.prefixEquals(IOTConstants.OT_SETFIELD, name)) {
            return 9;
        }
        if (CharOperation.prefixEquals(IOTConstants.ADD_ROLE, name)) {
            return 9;
        }
        if (CharOperation.equals(CallinImplementorDyn.OT_CALL_AFTER, name)) {
            return 1;
        }
        if (CharOperation.equals(CallinImplementorDyn.OT_CALL_BEFORE, name)) {
            return 1;
        }
        if (CharOperation.equals(CalloutImplementorDyn.OT_ACCESS, name)) {
            return 1;
        }
        if (CharOperation.equals(CalloutImplementorDyn.OT_ACCESS_STATIC, name)) {
            return 1;
        }
        return 0;
    }

    private MethodBinding createMethodFromSignature(ReferenceBinding declaringClass, int methodModifiers, char[] methodSelector, char[] methodSignature) {
        char nextChar;
        int numOfParams = 0;
        int index = 0;
        while ((nextChar = methodSignature[++index]) != ')') {
            if (nextChar == '[') continue;
            ++numOfParams;
            if (nextChar != 'L') continue;
            while ((nextChar = methodSignature[++index]) != ';') {
            }
        }
        int startIndex = 0;
        TypeBinding[] parameters = Binding.NO_PARAMETERS;
        int size = numOfParams - startIndex;
        if (size > 0) {
            parameters = new TypeBinding[size];
            index = 1;
            int end = 0;
            int i = 0;
            while (i < numOfParams) {
                while ((nextChar = methodSignature[++end]) == '[') {
                }
                if (nextChar == 'L') {
                    while ((nextChar = methodSignature[++end]) != ';') {
                    }
                }
                if (i >= startIndex) {
                    parameters[i - startIndex] = this._environment.getTypeFromSignature(methodSignature, index, end, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
                }
                index = end + 1;
                ++i;
            }
        }
        return new MethodBinding(methodModifiers, methodSelector, this._environment.getTypeFromSignature(methodSignature, index + 1, -1, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER), parameters, Binding.NO_EXCEPTIONS, declaringClass);
    }

    private FieldBinding findFieldBinding(TypeBinding class_tb, char[] name, char[] descriptor) {
        if (class_tb instanceof ReferenceBinding) {
            ReferenceBinding class_rb = (ReferenceBinding)class_tb;
            return this.findFieldByName(class_rb, name);
        }
        if (class_tb instanceof ArrayBinding) {
            if (!CharOperation.equals(name, TypeConstants.LENGTH)) assert (false);
            return ArrayBinding.ArrayLength;
        }
        assert (false);
        return null;
    }

    public FieldBinding findFieldByName(ReferenceBinding clazz, char[] name) {
        TypeBinding original;
        char[] prefix = TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX;
        if (CharOperation.prefixEquals(prefix, name) && (original = clazz.original()) instanceof NestedTypeBinding && (original.isMemberType() || original.isLocalType())) {
            NestedTypeBinding ntb = (NestedTypeBinding)original;
            SyntheticArgumentBinding[] sab = ntb.syntheticEnclosingInstances();
            int i = 0;
            while (i < sab.length) {
                if (CharOperation.equals(name, sab[i].name)) {
                    return sab[i].matchingField;
                }
                ++i;
            }
        }
        return clazz.getField(name, true);
    }

    public static FieldBinding findFieldByBinding(ReferenceBinding clazz, FieldBinding refField) {
        char[] thisPrefix = TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX;
        char[] classPrefix = TypeConstants.SYNTHETIC_CLASS;
        char[] name = refField.name;
        if (CharOperation.prefixEquals(thisPrefix, name)) {
            int distance = refField.declaringClass.depth() - ((ReferenceBinding)refField.type).depth();
            if (clazz instanceof NestedTypeBinding) {
                NestedTypeBinding mtb = (NestedTypeBinding)clazz;
                ReferenceBinding dstFieldType = clazz;
                while (distance-- > 0) {
                    dstFieldType = dstFieldType.enclosingType();
                }
                return mtb.addSyntheticFieldForInnerclass(dstFieldType);
            }
            int depth = clazz.depth() - distance;
            name = CharOperation.concat(thisPrefix, String.valueOf(depth).toCharArray());
        } else if (CharOperation.prefixEquals(classPrefix, name)) {
            return new FieldBinding(refField.name, refField.type, 0, clazz, null);
        }
        ReferenceBinding current = clazz;
        while (current != null) {
            FieldBinding f = current.getField(name, true);
            if (f != null) {
                return f;
            }
            current = current.superclass();
        }
        return null;
    }

    private boolean isEqual(MethodBinding binding, char[] name, char[] descriptor) {
        if (new String(binding.selector).compareTo(new String(name)) != 0) {
            return false;
        }
        char[] signature = binding.signature();
        if (CharOperation.equals(signature, descriptor)) {
            return true;
        }
        if (binding.isConstructor()) {
            int separatorPosMethod = CharOperation.indexOf('$', signature);
            int separatorPosDescriptor = CharOperation.indexOf('$', descriptor);
            if (separatorPosMethod == -1 && separatorPosDescriptor == -1) {
                separatorPosMethod = CharOperation.indexOf(';', signature);
                separatorPosDescriptor = CharOperation.indexOf(';', descriptor);
            }
            if (separatorPosMethod > 0 && separatorPosDescriptor > 0) {
                TypeBinding type1 = this._environment.getTypeFromSignature(signature, 1, separatorPosMethod, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
                TypeBinding type2 = this._environment.getTypeFromSignature(descriptor, 1, separatorPosDescriptor, false, this._srcModel.getBinding(), null, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
                if (!type1.isTeam() || !type2.isTeam()) {
                    return false;
                }
                if (!type1.isCompatibleWith(type2)) {
                    return false;
                }
                signature = CharOperation.subarray(signature, separatorPosMethod, -1);
                descriptor = CharOperation.subarray(descriptor, separatorPosDescriptor, -1);
            }
        }
        return false;
    }

    public Iterator<ConstantPoolObject> getNonWideConstantIterator(int nConstants) {
        return new Iterator<ConstantPoolObject>(nConstants){
            int cur;
            {
                this.cur = Math.min(256, n);
            }

            @Override
            public boolean hasNext() {
                while (--this.cur >= 0) {
                    int entryType = ConstantPoolObjectReader.this.getConstantPoolEntryType(this.cur);
                    switch (entryType) {
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: {
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public ConstantPoolObject next() {
                return ConstantPoolObjectReader.this.readConstantPoolObject(this.cur, 2);
            }

            @Override
            public void remove() {
                throw new InternalCompilerError("method not meant to be invoked.");
            }
        };
    }

    class IncompatibleBytecodeException
    extends RuntimeException {
        private static final long serialVersionUID = -7100113603999284971L;
        char[] _offendingName;
        int _problemId;

        IncompatibleBytecodeException(char[] offendingName, int problemId) {
            this._offendingName = offendingName;
            this._problemId = problemId;
        }
    }
}

