/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.Vector;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class TreeNode {
    public static final TreeNode ProblemNode = new TreeNode(null);
    private RoleModel typeModel;
    private TreeNode[] parents = null;
    private TreeNode[] children;

    public TreeNode(RoleModel typeModel) {
        this.typeModel = typeModel;
    }

    private void setParents(TreeNode r1, TreeNode r2) {
        this.parents = new TreeNode[]{r1, r2};
    }

    public RoleModel getTreeObject() {
        return this.typeModel;
    }

    public boolean isRoot() {
        return this.parents == null;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length != 0;
    }

    public TreeNode[] getChildren() {
        return this.children;
    }

    public void add(TreeNode child) {
        if (this.hasChildren()) {
            TreeNode[] newChildren = new TreeNode[this.children.length + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            newChildren[this.children.length] = child;
            this.children = newChildren;
        } else {
            this.children = new TreeNode[1];
            this.children[0] = child;
        }
        child.setParent(this);
    }

    private void setParent(TreeNode parent) {
        int len = this.parents == null ? 1 : this.parents.length + 1;
        TreeNode[] newParents = new TreeNode[len];
        if (this.parents != null) {
            System.arraycopy(this.parents, 0, newParents, 0, len - 1);
        }
        this.parents = newParents;
        this.parents[len - 1] = parent;
    }

    public boolean hasBoundParent(boolean interfaceAllowed) {
        if (this.parents == null) {
            return false;
        }
        int i = 0;
        while (i < this.parents.length) {
            TreeNode parent = this.parents[i];
            if (parent.getTreeObject().isBound() && (interfaceAllowed || !parent.getTreeObject().isRegularInterface())) {
                return true;
            }
            if (parent.hasBoundParent(interfaceAllowed)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreeNode getBoundParent(boolean interfaceAllowed) {
        if (this.parents == null) {
            return null;
        }
        int i = 0;
        while (i < this.parents.length) {
            TreeNode parent = this.parents[i];
            TreeNode lessSpecificParent = parent.getBoundParent(interfaceAllowed);
            if (lessSpecificParent != null) {
                return lessSpecificParent;
            }
            if (parent.getTreeObject().isBound() && (interfaceAllowed || !parent.getTreeObject().isRegularInterface())) {
                return parent;
            }
            ++i;
        }
        return null;
    }

    public TreeNode getTopmostBoundParent(boolean interfaceAllowed) {
        TreeNode found = null;
        if (this.parents != null) {
            int i = 0;
            while (i < this.parents.length) {
                TreeNode parent = this.parents[i];
                TreeNode current = parent.getTopmostBoundParent(interfaceAllowed);
                if (current != null) {
                    if (found == null) {
                        found = current;
                    } else if (found != current) {
                        ProblemNode.setParents(found, current);
                        return ProblemNode;
                    }
                }
                ++i;
            }
            if (found != null) {
                return found;
            }
        }
        if (this.getTreeObject().isBound() && (interfaceAllowed || !this.getTreeObject().isRegularInterface())) {
            return this;
        }
        return null;
    }

    public String toString() {
        if (this == ProblemNode) {
            return String.valueOf(new String(this.parents[0].getTreeObject().getBinding().sourceName())) + " and " + new String(this.parents[1].getTreeObject().getBinding().sourceName());
        }
        return this.toString(0);
    }

    public String toString(int tab) {
        String str = String.valueOf(TreeNode.tabString(tab)) + this.typeModel.toString() + "\n";
        if (!this.hasChildren()) {
            return str;
        }
        int i = 0;
        while (i < this.children.length) {
            TreeNode treeNode = this.children[i];
            str = String.valueOf(str) + treeNode.toString(tab + 1);
            ++i;
        }
        return str;
    }

    public static String tabString(int tab) {
        String s = "";
        int i = tab;
        while (i > 0) {
            s = String.valueOf(s) + "  ";
            --i;
        }
        return s;
    }

    public TreeNode[] elements() {
        Vector<TreeNode> treeNodes = new Vector<TreeNode>(0, 1);
        treeNodes.add(this);
        if (this.hasChildren()) {
            int i = 0;
            while (i < this.children.length) {
                TreeNode childNode = this.children[i];
                TreeNode[] nodes = childNode.elements();
                int j = 0;
                while (j < nodes.length) {
                    TreeNode node = nodes[j];
                    treeNodes.add(node);
                    ++j;
                }
                ++i;
            }
        }
        return treeNodes.toArray(new TreeNode[treeNodes.size()]);
    }

    public TreeNode find(ReferenceBinding binding) {
        if (TypeBinding.equalsEquals(this.getTreeObject().getBinding(), binding)) {
            return this;
        }
        if (this.hasChildren()) {
            int i = 0;
            while (i < this.children.length) {
                TreeNode childNode = this.children[i];
                TreeNode node = childNode.find(binding);
                if (node != null) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }
}

