/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class RoleLocalTypesAttribute
extends ListValueAttribute {
    private RoleModel _role;
    private ReferenceBinding[] _localTypes;
    private char[][] _names = new char[0][];

    public RoleLocalTypesAttribute(RoleModel type) {
        super(IOTConstants.ROLE_LOCAL_TYPES, 0, 2);
        this._role = type;
    }

    public RoleLocalTypesAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.ROLE_LOCAL_TYPES, 0, 2);
        this.readList(reader, readOffset, 0, constantPoolOffsets);
    }

    public boolean setupForWriting() {
        this._localTypes = this._role.getLocalTypes();
        this._count = this._localTypes.length;
        int k = 0;
        int i = 0;
        while (i < this._localTypes.length) {
            if (this._localTypes[i].constantPoolName() == null) {
                --this._count;
            } else {
                this._localTypes[k++] = this._localTypes[i];
            }
            ++i;
        }
        return this._count > 0;
    }

    protected void writeElementValue(int i) {
        ReferenceBinding typeBinding = this._localTypes[i];
        this.writeName(typeBinding.constantPoolName());
    }

    void read(int i) {
        if (i == 0) {
            this._names = new char[this._count][];
        }
        this._names[i] = this.consumeName();
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 0x1000000);
        this._localTypes = new ReferenceBinding[this._count];
        ReferenceBinding refBinding = (ReferenceBinding)binding;
        RoleModel role = refBinding.roleModel;
        if (role == null) {
            refBinding.roleModel = role = new RoleModel(refBinding);
        }
        int i = 0;
        while (i < this._names.length) {
            this._localTypes[i] = environment.getTypeFromConstantPoolName(this._names[i], 0, -1, false, missingTypeNames);
            if (this._localTypes[i] instanceof UnresolvedReferenceBinding) {
                this._localTypes[i] = this.resolveReferenceType(environment, (UnresolvedReferenceBinding)this._localTypes[i]);
            }
            role.addBinaryLocalType(this._localTypes[i]);
            ++i;
        }
    }

    protected String toString(int i) {
        return new String(this._localTypes[i].constantPoolName());
    }
}

