/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.util.CollectionsUtil;
import org.eclipse.nebula.widgets.xviewer.core.util.XViewerUtil;
import org.eclipse.nebula.widgets.xviewer.core.util.XmlUtil;

public class XViewerColumn {
    protected String id;
    protected String name = "";
    private String description;
    private boolean multiColumnEditable = false;
    private int width;
    private XViewerAlign align;
    private boolean sortForward = true;
    private boolean show = true;
    private SortDataType sortDataType = SortDataType.String;
    private String toolTip = "";
    protected Map<Long, String> preComputedValueMap = null;
    private Object xViewer;
    private Long elapsedTime = 0L;
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String WIDTH = "wdth";
    public static final String ALIGN = "algn";
    public static final String SORT_FORWARD = "srtFwd";
    public static final String SHOW = "show";
    public static final String XTREECOLUMN_TAG = "xCol";

    protected XViewerColumn() {
    }

    public XViewerColumn(String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        this.setId(id);
        this.setName(name);
        this.width = width;
        this.align = align;
        this.show = show;
        this.sortDataType = sortDataType;
        this.multiColumnEditable = multiColumnEditable;
        this.setDescription(description);
        this.setToolTip(this.name);
    }

    public XViewerColumn copy() {
        XViewerColumn newXCol = new XViewerColumn();
        this.copy(this, newXCol);
        return newXCol;
    }

    protected void copy(XViewerColumn fromXCol, XViewerColumn toXCol) {
        toXCol.setAlign(fromXCol.align);
        toXCol.setDescription(fromXCol.description);
        toXCol.setMultiColumnEditable(fromXCol.multiColumnEditable);
        toXCol.setName(fromXCol.name);
        toXCol.setSortDataType(fromXCol.sortDataType);
        toXCol.setSortForward(this.isSortForward());
        toXCol.setToolTip(fromXCol.toolTip);
        toXCol.setWidth(fromXCol.width);
        toXCol.setShow(fromXCol.show);
        toXCol.setId(fromXCol.id);
    }

    public XViewerColumn(Object xViewer, String xml) {
        this.setFromXml(xml);
        this.xViewer = xViewer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XViewerColumn) {
            return ((XViewerColumn)obj).getId().equals(this.id);
        }
        if (obj instanceof String) {
            return this.id.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder("<xCol>");
        sb.append(XmlUtil.addTagData(ID, this.id));
        sb.append(XmlUtil.addTagData(NAME, this.name));
        sb.append(XmlUtil.addTagData(WIDTH, "" + this.width));
        sb.append(XmlUtil.addTagData(ALIGN, this.getAlignStoreName(this.align)));
        sb.append(XmlUtil.addTagData(SORT_FORWARD, "" + this.sortForward));
        sb.append(XmlUtil.addTagData(SHOW, "" + this.show));
        sb.append("</xCol>");
        return sb.toString();
    }

    public void setFromXml(String xml) {
        this.setId(XmlUtil.getTagData(xml, ID));
        this.setName(XmlUtil.getTagData(xml, NAME));
        this.width = XmlUtil.getTagIntData(xml, WIDTH);
        this.align = this.getAlignStoreValue(XmlUtil.getTagData(xml, ALIGN));
        this.sortForward = XmlUtil.getTagBooleanData(xml, SORT_FORWARD);
        this.show = XmlUtil.getTagBooleanData(xml, SHOW);
    }

    public static String getColumnId(String xml) {
        return XmlUtil.getTagData(xml, ID);
    }

    public String getAlignStoreName(XViewerAlign align) {
        if (align == XViewerAlign.Center) {
            return "center";
        }
        if (align == XViewerAlign.Right) {
            return "right";
        }
        return "left";
    }

    public XViewerAlign getAlignStoreValue(String str) {
        if (str.equals("center")) {
            return XViewerAlign.Center;
        }
        if (str.equals("right")) {
            return XViewerAlign.Right;
        }
        return XViewerAlign.Left;
    }

    public String getDisplayName() {
        if (this.id != null && !this.id.equals(this.name)) {
            return this.name + " - " + this.id + " - width:" + this.width + " - show:" + this.show;
        }
        return this.name + " - width:" + this.width + " - show:" + this.show;
    }

    public XViewerAlign getAlign() {
        return this.align;
    }

    public void setAlign(XViewerAlign align) {
        this.align = align;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isSortForward() {
        return this.sortForward;
    }

    public void setSortForward(boolean sortForward) {
        this.sortForward = sortForward;
    }

    public void reverseSort() {
        this.setSortForward(!this.sortForward);
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public String getName() {
        return this.name;
    }

    public SortDataType getSortDataType() {
        return this.sortDataType;
    }

    public void setSortDataType(SortDataType sortDataType) {
        this.sortDataType = sortDataType;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        if (toolTip != null) {
            this.toolTip = XViewerUtil.intern(toolTip);
        }
    }

    public void setName(String name) {
        this.name = XViewerUtil.intern(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMultiColumnEditable() {
        return this.multiColumnEditable;
    }

    public void setMultiColumnEditable(boolean multiColumnEditable) {
        this.multiColumnEditable = multiColumnEditable;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public boolean isSummable() {
        return this.sortDataType == SortDataType.Float || this.sortDataType == SortDataType.Integer || this.sortDataType == SortDataType.Long || this.sortDataType == SortDataType.Percent;
    }

    public String sumValues(Collection<String> values) {
        if (this.sortDataType == SortDataType.Float) {
            double sum = 0.0;
            HashSet<String> exceptions = new HashSet<String>();
            sum = this.sumFloatValues(values, sum, exceptions);
            return "Sum: " + XViewerUtil.doubleToI18nString(sum) + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Integer || this.sortDataType == SortDataType.Percent) {
            int sum = 0;
            HashSet<String> exceptions = new HashSet<String>();
            sum = this.sumIntegerValues(values, sum, exceptions);
            return "Sum: " + sum + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Long) {
            long sum = 0L;
            HashSet<String> exceptions = new HashSet<String>();
            sum = this.sumLongValues(values, sum, exceptions);
            return "Sum: " + sum + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        return "Unhandled column type";
    }

    private double sumFloatValues(Collection<String> values, double sum, Set<String> exceptions) {
        for (String value : values) {
            if (value == null || value.equals("")) continue;
            try {
                sum += new Double(value).doubleValue();
            }
            catch (Exception ex) {
                exceptions.add(ex.getLocalizedMessage());
            }
        }
        return sum;
    }

    public String averageValues(Collection<String> values) {
        if (this.sortDataType == SortDataType.Float) {
            double sum = 0.0;
            HashSet<String> exceptions = new HashSet<String>();
            Double average = (sum = this.sumFloatValues(values, sum, exceptions)) == 0.0 || values.isEmpty() ? 0.0 : sum / (double)values.size();
            return "Average: " + XViewerUtil.doubleToI18nString(average) + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Integer || this.sortDataType == SortDataType.Percent) {
            int sum = 0;
            HashSet<String> exceptions = new HashSet<String>();
            Integer average = (sum = this.sumIntegerValues(values, sum, exceptions)) == 0 || values.isEmpty() ? 0 : sum / values.size();
            return "Average: " + String.valueOf(average) + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Long) {
            long sum = 0L;
            HashSet<String> exceptions = new HashSet<String>();
            Long average = (sum = this.sumLongValues(values, sum, exceptions)) == 0L || values.isEmpty() ? 0L : sum / Long.valueOf(values.size());
            return "Average: " + String.valueOf(average) + "\n\nNum Items: " + values.size() + (String)(exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        return "Unhandled column type";
    }

    private long sumLongValues(Collection<String> values, long sum, Set<String> exceptions) {
        for (String value : values) {
            if (value == null || value.equals("")) continue;
            try {
                sum += Long.valueOf(value).longValue();
            }
            catch (Exception ex) {
                exceptions.add(ex.getLocalizedMessage());
            }
        }
        return sum;
    }

    private int sumIntegerValues(Collection<String> values, int sum, Set<String> exceptions) {
        for (String value : values) {
            if (value == null || value.equals("")) continue;
            try {
                sum += Integer.valueOf(value).intValue();
            }
            catch (Exception ex) {
                exceptions.add(ex.getLocalizedMessage());
            }
        }
        return sum;
    }

    public void setId(String id) {
        this.id = XViewerUtil.intern(id);
    }

    public String getPreComputedValue(Long key) {
        String result = null;
        if (this.preComputedValueMap == null) {
            return result;
        }
        return this.preComputedValueMap.get(key);
    }

    public Object getXViewer() {
        return this.xViewer;
    }

    public void setXViewer(Object xViewer) {
        this.xViewer = xViewer;
    }

    public Map<Long, String> getPreComputedValueMap() {
        if (this.preComputedValueMap == null) {
            this.preComputedValueMap = new HashMap<Long, String>();
        }
        return this.preComputedValueMap;
    }

    public void setPreComputedValueMap(Map<Long, String> preComputedValueMap) {
        this.preComputedValueMap = preComputedValueMap;
    }

    public String toString() {
        return "XViewerColumn [id=" + this.id + ", name=" + this.name + ", sortDataType=" + String.valueOf((Object)this.sortDataType) + ", sortForward=" + this.isSortForward() + ", show=" + this.show + ", width=" + this.width + "]";
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public void addElapsedTime(Long elapsedTimeMs) {
        this.elapsedTime = this.elapsedTime + elapsedTimeMs;
    }

    public void setElapsedTime(Long elapsedTimeMs) {
        this.elapsedTime = elapsedTimeMs;
    }

    public void resetElapsedTime() {
        this.elapsedTime = 0L;
    }
}

