/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.borders;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;

public class RoundedRectangleBorder
extends LineBorder {
    private final int fArcWidth;
    private final int fArcHeight;

    public RoundedRectangleBorder(int arcWidth, int arcHeight) {
        this.fArcWidth = arcWidth;
        this.fArcHeight = arcHeight;
    }

    public RoundedRectangleBorder(int arc) {
        this(arc, arc);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoundedRectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedRectangleBorder.tempRect.width;
            --RoundedRectangleBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, this.fArcWidth, this.fArcHeight);
    }
}

