/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.segmentedbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.opal.commons.AdvancedPath;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.segmentedbar.SegmentedBar;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Segment {
    static final int CORNER_RADIUS = 10;
    private String text;
    private String tooltip;
    private Double value;
    private Font font;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private Object datum;
    private Color background;
    private Color foreground;
    private SegmentedBar parent;
    Rectangle drawingArea;

    public String getTooltip() {
        return this.tooltip;
    }

    public Segment setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public Segment setValue(Double value) {
        this.value = value;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public Object getData() {
        return this.datum;
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public String getText() {
        return this.text;
    }

    public Segment setBackground(Color background) {
        this.background = background;
        return this;
    }

    public Segment setFont(Font font) {
        this.font = font;
        return this;
    }

    public Segment setForeground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    public Segment setText(String text) {
        this.text = text;
        return this;
    }

    public Segment setData(Object data) {
        this.datum = data;
        return this;
    }

    public Segment setData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    int computeHeight() {
        if (this.text == null) {
            return 30;
        }
        return SWTGraphicUtil.computeSize((String)this.text, (Font)this.font).y + 4 + 20;
    }

    void setParent(SegmentedBar parent) {
        this.parent = parent;
    }

    void draw(int segmentSize) {
        GC gc = this.parent.gc;
        Color previousForeground = gc.getForeground();
        Color previousBackground = gc.getBackground();
        Font previousFont = gc.getFont();
        AdvancedPath path = new AdvancedPath((Device)this.parent.getDisplay());
        int height = this.parent.getSize().y;
        this.drawingArea = new Rectangle(this.parent.currentX, 0, segmentSize, height);
        if (this.parent.isFirstItem) {
            path.addRoundRectangleStraightRight((float)this.parent.currentX, 0.0f, (float)segmentSize, (float)height, 10.0f, 10.0f);
        } else if (this.parent.isLastItem) {
            path.addRoundRectangleStraightLeft((float)this.parent.currentX, 0.0f, (float)(segmentSize - 10), (float)height, 10.0f, 10.0f);
            this.drawingArea.width -= 10;
        } else {
            path.addRectangle((float)this.parent.currentX, 0.0f, (float)segmentSize, (float)height);
        }
        if (this.background == null) {
            gc.setBackground(this.parent.getDisplay().getSystemColor(15));
        } else {
            gc.setBackground(this.background);
        }
        gc.setClipping((Path)path);
        gc.fillRectangle(this.parent.currentX, 0, segmentSize, height);
        gc.setClipping(null);
        path.dispose();
        if (this.text != null && !this.text.trim().equals("")) {
            this.drawText(segmentSize);
        }
        gc.setBackground(previousBackground);
        gc.setForeground(previousForeground);
        gc.setFont(previousFont);
    }

    private void drawText(int segmentSize) {
        boolean tooHigh;
        GC gc = this.parent.gc;
        if (this.font != null) {
            gc.setFont(this.font);
        }
        Point textSize = gc.textExtent(this.text, 1);
        int height = this.parent.getSize().y;
        boolean tooLarge = textSize.x > segmentSize - 6;
        boolean bl = tooHigh = textSize.y > height - 2;
        if (tooLarge || tooHigh) {
            return;
        }
        if (this.foreground != null) {
            gc.setForeground(this.foreground);
        }
        gc.drawText(this.text, this.parent.currentX + 3, (height - textSize.y) / 2, true);
    }

    public static Segment create() {
        return new Segment();
    }
}

