/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.propertytable.AbstractPTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTStringEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PTWidgetTree
extends AbstractPTWidget {
    private Tree tree;

    @Override
    protected void buildWidget(Composite parent) {
        this.tree = new Tree(parent, 65536);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final TreeColumn propertyColumn = new TreeColumn(this.tree, 0);
        propertyColumn.setText(ResourceManager.getLabel((String)"property"));
        final TreeColumn valueColumn = new TreeColumn(this.tree, 0);
        valueColumn.setText(ResourceManager.getLabel((String)"value"));
        this.fillData();
        this.tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = PTWidgetTree.this.tree.getParent().getClientArea();
                Point size = PTWidgetTree.this.tree.computeSize(-1, -1);
                ScrollBar vBar = PTWidgetTree.this.tree.getVerticalBar();
                int width = area.width - PTWidgetTree.this.tree.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + PTWidgetTree.this.tree.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                propertyColumn.pack();
                valueColumn.setWidth(width - propertyColumn.getWidth());
                PTWidgetTree.this.tree.removeControlListener((ControlListener)this);
            }
        });
        this.tree.addListener(13, event -> {
            if (this.tree.getSelectionCount() == 0 || this.tree.getSelection()[0] == null) {
                return;
            }
            this.updateDescriptionPanel(this.tree.getSelection()[0].getData());
        });
    }

    private void fillData() {
        AbstractMap data = this.getParentPropertyTable().sorted ? new TreeMap() : new LinkedHashMap();
        for (PTProperty pTProperty : this.getParentPropertyTable().getPropertiesAsList()) {
            String category = StringUtil.safeToString((Object)pTProperty.getCategory());
            if (!data.containsKey(category)) {
                data.put(category, new ArrayList());
            }
            ((List)data.get(category)).add(pTProperty);
        }
        for (Map.Entry entry : data.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            TreeItem root = new TreeItem(this.tree, 0);
            root.setText(0, (String)entry.getKey());
            root.setBackground(root.getDisplay().getSystemColor(29));
            root.setForeground(root.getDisplay().getSystemColor(2));
            root.setExpanded(true);
            for (PTProperty p : (List)entry.getValue()) {
                TreeItem item = new TreeItem(root, 0);
                item.setData((Object)p);
                item.setText(0, StringUtil.safeToString((Object)p.getDisplayName()));
                if (p.getEditor() == null) {
                    p.setEditor(new PTStringEditor());
                }
                ControlEditor editor = p.getEditor().render(this, (Item)item, p);
                item.addListener(12, event -> {
                    if (editor.getEditor() != null) {
                        editor.getEditor().dispose();
                    }
                    editor.dispose();
                });
                if (!p.isEnabled()) {
                    item.setForeground(item.getDisplay().getSystemColor(15));
                }
                item.setExpanded(true);
                p.setAssociatedItem((Item)item);
            }
            root.setExpanded(true);
        }
    }

    @Override
    public void refillData() {
        try {
            if (this.tree != null) {
                this.tree.setRedraw(false);
                TreeItem[] treeItemArray = this.tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    treeItem.dispose();
                    ++n2;
                }
            }
            this.fillData();
        }
        finally {
            if (this.tree != null) {
                this.tree.setRedraw(true);
                this.tree.redraw();
                this.tree.update();
            }
        }
    }

    @Override
    public Composite getWidget() {
        return this.tree;
    }
}

