/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.figures.DAxis;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickLabels;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTicks2;

public class LinearScaleTickLabels2
extends LinearScaleTickLabels {
    public LinearScaleTickLabels2(DAxis linearScale) {
        super(linearScale, new LinearScaleTicks2(linearScale));
        this.setTicksIndexBased(linearScale.isTicksIndexBased());
    }

    @Override
    protected void drawXTick(Graphics graphics) {
        ITicksProvider ticks = this.getTicksProvider();
        int imax = this.getTicksProvider().getMajorCount();
        int i = 0;
        while (i < imax) {
            if (ticks.isVisible(i)) {
                graphics.drawText(ticks.getLabel(i), ticks.getLabelPosition(i), 0);
            }
            ++i;
        }
    }

    @Override
    protected void drawYTick(Graphics graphics) {
        ITicksProvider ticks = this.getTicksProvider();
        int imax = ticks.getMajorCount();
        if (imax < 1) {
            return;
        }
        boolean hasNegative = ticks.getLabel(0).startsWith("-");
        int minus = this.getScale().getDimension((Object)"-").width;
        int i = 0;
        while (i < imax) {
            if (ticks.isVisible(i)) {
                String text = ticks.getLabel(i);
                int x = hasNegative && !text.startsWith("-") ? minus : 0;
                graphics.drawText(text, x, ticks.getLabelPosition(i));
            }
            ++i;
        }
    }

    public void setTicksIndexBased(boolean isTicksIndexBased) {
        ((LinearScaleTicks2)this.getTicksProvider()).setTicksIndexBased(isTicksIndexBased);
    }
}

