/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figureparts.PolarPoint;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class RoundScaledRamp
extends Figure {
    private static final int OVERLAP_DEGREE = 2;
    private RoundScale scale;
    private ThresholdMarker lolo = new ThresholdMarker(10.0, XYGraphMediaFactory.COLOR_RED, true);
    private ThresholdMarker lo = new ThresholdMarker(25.0, XYGraphMediaFactory.COLOR_ORANGE, true);
    private ThresholdMarker hi = new ThresholdMarker(75.0, XYGraphMediaFactory.COLOR_ORANGE, true);
    private ThresholdMarker hihi = new ThresholdMarker(90.0, XYGraphMediaFactory.COLOR_RED, true);
    private ThresholdMarker normal = new ThresholdMarker(50.0, XYGraphMediaFactory.COLOR_GREEN, true);
    private ThresholdMarker min = new ThresholdMarker(0.0, null, true);
    private ThresholdMarker max = new ThresholdMarker(100.0, null, true);
    private int rampWidth = 20;
    private boolean gradient = true;
    private boolean dirty = true;

    public RoundScaledRamp(RoundScale scale) {
        this.scale = scale;
    }

    public void setBounds(Rectangle rect) {
        if (!this.bounds.equals((Object)rect)) {
            this.setDirty(true);
        }
        rect.height = rect.width = Math.min(rect.width, rect.height);
        super.setBounds(rect);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        hHint = wHint = Math.min(wHint, hHint);
        Dimension size = new Dimension(wHint, hHint);
        return size;
    }

    private void updateThresholdPosition() {
        if (this.dirty) {
            double lowLimit = this.lo.visible ? this.lo.value : (this.lolo.visible ? this.lolo.value : this.scale.getRange().getLower());
            double upLimit = this.hi.visible ? this.hi.value : (this.hihi.visible ? this.hihi.value : this.scale.getRange().getUpper());
            this.normal.value = (lowLimit + upLimit) / 2.0;
            this.normal.absolutePosition = (int)this.scale.getCoercedValuePosition(this.normal.value, false);
            this.normal.relativePosition = (int)this.scale.getCoercedValuePosition(this.normal.value, true);
            this.normal.rightPoint = new PolarPoint(this.bounds.width / 2, (double)(this.normal.absolutePosition - 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            this.normal.leftPoint = new PolarPoint(this.bounds.width / 2, (double)(this.normal.absolutePosition + 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            if (this.scale.getRange().isMinBigger()) {
                this.min.value = this.scale.getRange().getUpper();
                this.max.value = this.scale.getRange().getLower();
            } else {
                this.min.value = this.scale.getRange().getLower();
                this.max.value = this.scale.getRange().getUpper();
            }
            this.min.absolutePosition = (int)this.scale.getCoercedValuePosition(this.min.value, false);
            this.min.relativePosition = (int)this.scale.getCoercedValuePosition(this.min.value, true);
            this.max.absolutePosition = (int)this.scale.getCoercedValuePosition(this.max.value, false);
            this.max.relativePosition = (int)this.scale.getCoercedValuePosition(this.max.value, true);
            if (this.lolo.visible) {
                this.lolo.absolutePosition = (int)this.scale.getCoercedValuePosition(this.lolo.value, false);
                this.lolo.relativePosition = (int)this.scale.getCoercedValuePosition(this.lolo.value, true);
                this.lolo.rightPoint = new PolarPoint(this.bounds.width / 2, (double)(this.lolo.absolutePosition - 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
                this.lolo.leftPoint = new PolarPoint(this.bounds.width / 2, (double)(this.lolo.absolutePosition + 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            }
            if (this.lo.visible) {
                this.lo.absolutePosition = (int)this.scale.getCoercedValuePosition(this.lo.value, false);
                this.lo.relativePosition = (int)this.scale.getCoercedValuePosition(this.lo.value, true);
                this.lo.rightPoint = new PolarPoint(this.bounds.width / 2, (double)(this.lo.absolutePosition - 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
                this.lo.leftPoint = new PolarPoint(this.bounds.width / 2, (double)(this.lo.absolutePosition + 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            }
            if (this.hi.visible) {
                this.hi.absolutePosition = (int)this.scale.getCoercedValuePosition(this.hi.value, false);
                this.hi.relativePosition = (int)this.scale.getCoercedValuePosition(this.hi.value, true);
                this.hi.rightPoint = new PolarPoint(this.bounds.width / 2, (double)(this.hi.absolutePosition - 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
                this.hi.leftPoint = new PolarPoint(this.bounds.width / 2, (double)(this.hi.absolutePosition + 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            }
            if (this.hihi.visible) {
                this.hihi.absolutePosition = (int)this.scale.getCoercedValuePosition(this.hihi.value, false);
                this.hihi.relativePosition = (int)this.scale.getCoercedValuePosition(this.hihi.value, true);
                this.hihi.rightPoint = new PolarPoint(this.bounds.width / 2, (double)(this.hihi.absolutePosition - 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
                this.hihi.leftPoint = new PolarPoint(this.bounds.width / 2, (double)(this.hihi.absolutePosition + 2) * Math.PI / 180.0).toAbsolutePoint(this.bounds);
            }
            this.setDirty(false);
        }
    }

    protected void paintClientArea(Graphics graphics) {
        this.updateThresholdPosition();
        graphics.setAntialias(1);
        graphics.setLineWidth(this.rampWidth);
        graphics.pushState();
        int overlap = 0;
        Pattern pattern = null;
        boolean support3D = GraphicsUtil.testPatternSupported(graphics);
        if (this.lolo.visible) {
            graphics.setBackgroundColor(this.lolo.color);
            graphics.fillArc(this.bounds, this.lolo.absolutePosition, this.min.relativePosition - this.lolo.relativePosition);
        }
        if (this.lo.visible) {
            if (support3D && this.gradient && this.lolo.visible) {
                try {
                    pattern = new Pattern((Device)Display.getCurrent(), (float)this.lolo.leftPoint.x, (float)this.lolo.leftPoint.y, (float)this.lo.rightPoint.x, (float)this.lo.rightPoint.y, this.lolo.color, this.lo.color);
                    graphics.setBackgroundPattern(pattern);
                    overlap = 1;
                }
                catch (Exception e) {
                    support3D = false;
                    pattern.dispose();
                    graphics.setBackgroundColor(this.lo.color);
                    overlap = 0;
                }
            } else {
                graphics.setBackgroundColor(this.lo.color);
                overlap = 0;
            }
            if (this.lolo.visible) {
                graphics.fillArc(this.bounds, this.lo.absolutePosition, this.lolo.relativePosition - this.lo.relativePosition + overlap);
            } else {
                graphics.fillArc(this.bounds, this.lo.absolutePosition, this.min.relativePosition - this.lo.relativePosition);
            }
            if (this.gradient && this.lolo.visible && support3D) {
                pattern.dispose();
            }
        }
        boolean leftMarkerVisible = false;
        ThresholdMarker leftMarker = null;
        if (this.lo.visible) {
            leftMarkerVisible = true;
            leftMarker = this.lo;
        } else if (this.lolo.visible) {
            leftMarkerVisible = true;
            leftMarker = this.lolo;
        } else {
            leftMarkerVisible = false;
        }
        if (this.gradient && leftMarkerVisible && support3D) {
            pattern = new Pattern((Device)Display.getCurrent(), (float)leftMarker.leftPoint.x, (float)leftMarker.leftPoint.y, (float)this.normal.rightPoint.x, (float)this.normal.rightPoint.y, leftMarker.color, this.normal.color);
            graphics.setBackgroundPattern(pattern);
            overlap = 1;
        } else {
            graphics.setBackgroundColor(this.normal.color);
            overlap = 0;
        }
        if (leftMarkerVisible) {
            graphics.fillArc(this.bounds, this.normal.absolutePosition, leftMarker.relativePosition - this.normal.relativePosition + overlap);
        } else {
            graphics.fillArc(this.bounds, this.normal.absolutePosition, this.min.relativePosition - this.normal.relativePosition);
        }
        if (this.gradient && leftMarkerVisible && support3D) {
            pattern.dispose();
        }
        boolean rightMarkerVisible = false;
        ThresholdMarker rightMarker = null;
        if (this.hi.visible) {
            rightMarkerVisible = true;
            rightMarker = this.hi;
        } else if (this.hihi.visible) {
            rightMarkerVisible = true;
            rightMarker = this.hihi;
        } else {
            rightMarkerVisible = false;
        }
        if (this.gradient && rightMarkerVisible && support3D) {
            pattern = new Pattern((Device)Display.getCurrent(), (float)rightMarker.rightPoint.x, (float)rightMarker.rightPoint.y, (float)this.normal.leftPoint.x, (float)this.normal.leftPoint.y, rightMarker.color, this.normal.color);
            graphics.setBackgroundPattern(pattern);
            overlap = 1;
        } else {
            graphics.setBackgroundColor(this.normal.color);
            overlap = 0;
        }
        if (rightMarkerVisible) {
            graphics.fillArc(this.bounds, rightMarker.absolutePosition, this.normal.relativePosition - rightMarker.relativePosition + overlap + 1);
        } else {
            graphics.fillArc(this.bounds, this.max.absolutePosition, this.normal.relativePosition - this.max.relativePosition + 1);
        }
        if (this.gradient && rightMarkerVisible && support3D) {
            pattern.dispose();
        }
        if (this.hi.visible) {
            if (this.hihi.visible) {
                rightMarkerVisible = true;
                rightMarker = this.hihi;
            } else {
                rightMarkerVisible = false;
            }
            if (this.gradient && rightMarkerVisible && support3D) {
                pattern = new Pattern((Device)Display.getCurrent(), (float)rightMarker.rightPoint.x, (float)rightMarker.rightPoint.y, (float)this.hi.leftPoint.x, (float)this.hi.leftPoint.y, rightMarker.color, this.hi.color);
                graphics.setBackgroundPattern(pattern);
                overlap = 1;
            } else {
                graphics.setBackgroundColor(this.hi.color);
                overlap = 0;
            }
            if (rightMarkerVisible) {
                graphics.fillArc(this.bounds, rightMarker.absolutePosition, this.hi.relativePosition - rightMarker.relativePosition + overlap);
            } else {
                graphics.fillArc(this.bounds, this.max.absolutePosition, this.hi.relativePosition - this.max.relativePosition);
            }
            if (this.gradient && rightMarkerVisible && support3D) {
                pattern.dispose();
            }
        }
        if (this.hihi.visible) {
            overlap = this.gradient && support3D ? 1 : 0;
            graphics.setBackgroundColor(this.hihi.color);
            graphics.fillArc(this.bounds, this.max.absolutePosition, this.hihi.relativePosition - this.max.relativePosition + overlap);
        }
        graphics.popState();
        graphics.fillOval(this.bounds.x + this.rampWidth, this.bounds.y + this.rampWidth, this.bounds.width - 2 * this.rampWidth, this.bounds.height - 2 * this.rampWidth);
        super.paintClientArea(graphics);
    }

    public RoundScale getScale() {
        return this.scale;
    }

    public void setScale(RoundScale scale) {
        this.scale = scale;
        this.setDirty(true);
    }

    public int getRampWidth() {
        return this.rampWidth;
    }

    public void setRampWidth(int rampWidth) {
        this.rampWidth = rampWidth;
        this.setDirty(true);
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
        this.setDirty(true);
    }

    public void setThresholdValue(Threshold thresholdName, double value) {
        switch (thresholdName) {
            case HIHI: {
                this.hihi.value = value;
                break;
            }
            case HI: {
                this.hi.value = value;
                break;
            }
            case LO: {
                this.lo.value = value;
                break;
            }
            case LOLO: {
                this.lolo.value = value;
            }
        }
        this.setDirty(true);
    }

    public void setThresholdColor(Threshold thresholdName, RGB color) {
        switch (thresholdName) {
            case HIHI: {
                this.hihi.setColor(color);
                break;
            }
            case HI: {
                this.hi.setColor(color);
                break;
            }
            case LO: {
                this.lo.setColor(color);
                break;
            }
            case LOLO: {
                this.lolo.setColor(color);
            }
        }
    }

    public void setThresholdVisibility(Threshold thresholdName, boolean visible) {
        switch (thresholdName) {
            case HIHI: {
                this.hihi.visible = visible;
                break;
            }
            case HI: {
                this.hi.visible = visible;
                break;
            }
            case LO: {
                this.lo.visible = visible;
                break;
            }
            case LOLO: {
                this.lolo.visible = visible;
            }
        }
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public static enum Threshold {
        HIHI,
        HI,
        LO,
        LOLO;

    }

    static class ThresholdMarker {
        private double value;
        private Color color;
        private boolean visible;
        private int absolutePosition;
        private int relativePosition;
        private Point rightPoint;
        private Point leftPoint;

        public ThresholdMarker(double value, RGB color, boolean visible) {
            this.value = value;
            if (color != null) {
                this.color = XYGraphMediaFactory.getInstance().getColor(color);
            }
            this.visible = visible;
        }

        public void setColor(RGB color) {
            this.color = XYGraphMediaFactory.getInstance().getColor(color);
        }
    }
}

