/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.internal;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;

public final class RotatePiece
implements PrintPiece {
    private final Device device;
    private final PrintPiece target;
    private final int angle;
    private final Point size;
    private Transform oldTransform;
    private Transform transform;

    public RotatePiece(Device device, PrintPiece target, int angle, Point size) {
        Util.notNull(device, target, size);
        this.device = device;
        this.target = target;
        this.angle = angle;
        this.size = size;
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    private Transform getOldTransform() {
        if (this.oldTransform == null) {
            this.oldTransform = new Transform(this.device);
        }
        return this.oldTransform;
    }

    private Transform getTransform() {
        if (this.transform == null) {
            this.transform = new Transform(this.device);
        }
        return this.transform;
    }

    @Override
    public void paint(GC gc, int x, int y) {
        Transform oldTransform = this.getOldTransform();
        gc.getTransform(oldTransform);
        Transform transform = this.getTransform();
        gc.getTransform(transform);
        transform.translate((float)x, (float)y);
        this.rotateTransform(transform);
        gc.setTransform(transform);
        this.target.paint(gc, 0, 0);
        gc.setTransform(oldTransform);
    }

    private void rotateTransform(Transform transform) {
        switch (this.angle) {
            case 90: {
                transform.translate(0.0f, (float)this.size.y);
                break;
            }
            case 180: {
                transform.translate((float)this.size.x, (float)this.size.y);
                break;
            }
            case 270: {
                transform.translate((float)this.size.x, 0.0f);
                break;
            }
            default: {
                PaperClips.error(5, "Rotation angle must be 90, 180 or 270.");
            }
        }
        transform.rotate((float)(-this.angle));
    }

    @Override
    public void dispose() {
        if (this.oldTransform != null) {
            this.oldTransform.dispose();
            this.oldTransform = null;
        }
        if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
        }
        this.target.dispose();
    }
}

