/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.util.internal.PatternFilter;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.XFilteredTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class XCheckedFilteredTree
extends XFilteredTree {
    private final Set<Object> checked = new HashSet<Object>();

    public XCheckedFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
        this.setInitialText("");
    }

    @Override
    protected Control createTreeControl(Composite parent, int style) {
        Control control = super.createTreeControl(parent, style);
        this.getViewer().addSelectionChangedListener(even -> this.storeResults(this.treeViewer.getTree().getItems()));
        this.getFilterControl().addListener(24, e -> this.restoreChecked(this.treeViewer.getTree().getItems()));
        this.getViewer().getTree().addListener(9, e -> this.restoreChecked(this.treeViewer.getTree().getItems()));
        return control;
    }

    public void setInitalChecked(Collection<? extends Object> checked) {
        this.checked.addAll(checked);
        this.restoreChecked(this.treeViewer.getTree().getItems());
        for (Object object : checked) {
            this.treeViewer.reveal(object);
        }
    }

    public void clearChecked() {
        this.checked.clear();
        this.restoreChecked(this.treeViewer.getTree().getItems());
    }

    private void restoreChecked(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getChecked() && !this.checked.contains(treeItem.getData())) {
                treeItem.setChecked(false);
            } else if (!treeItem.getChecked() && this.checked.contains(treeItem.getData())) {
                treeItem.setChecked(true);
            }
            this.restoreChecked(treeItem.getItems());
            ++n2;
        }
    }

    public Object[] getResult() {
        return this.getChecked().toArray(new Object[this.getChecked().size()]);
    }

    private void storeResults(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getChecked() && !this.checked.contains(treeItem.getData())) {
                this.checked.add(treeItem.getData());
            } else if (!treeItem.getChecked() && this.checked.contains(treeItem.getData())) {
                this.checked.remove(treeItem.getData());
            }
            this.storeResults(treeItem.getItems());
            ++n2;
        }
    }

    public Set<Object> getChecked() {
        return this.checked;
    }
}

