/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.util;

import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;

public class GraphicsUtil {
    public static synchronized boolean testPatternSupported(Graphics graphics) {
        if (SWT.getPlatform().startsWith("rap")) {
            return false;
        }
        if (!Preferences.useAdvancedGraphics()) {
            return false;
        }
        String value = System.getProperty("prohibit_advanced_graphics");
        if (value != null && value.equals("true")) {
            return false;
        }
        boolean support3D = true;
        try {
            graphics.setBackgroundPattern(null);
        }
        catch (Exception e) {
            support3D = false;
        }
        return support3D;
    }

    public static RGB mixColors(RGB c1, RGB c2, double weight) {
        return new RGB((int)((double)c1.red * weight + (double)c2.red * (1.0 - weight)), (int)((double)c1.green * weight + (double)c2.green * (1.0 - weight)), (int)((double)c1.blue * weight + (double)c2.blue * (1.0 - weight)));
    }

    public static Pattern createScaledPattern(Graphics graphics, Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        double scale = graphics.getAbsoluteScale();
        return new Pattern(device, (float)((double)x1 * scale), (float)((double)y1 * scale), (float)((double)x2 * scale), (float)((double)y2 * scale), color1, alpha1, color2, alpha2);
    }

    public static Pattern createScaledPattern(Graphics graphics, Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        double scale = graphics.getAbsoluteScale();
        return new Pattern(device, (float)((double)x1 * scale), (float)((double)y1 * scale), (float)((double)x2 * scale), (float)((double)y2 * scale), color1, color2);
    }
}

