/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.eclipse.nebula.widgets.opal.propertytable.PropertyTable;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class PTProperty {
    private final String name;
    private final String displayName;
    private final String description;
    private Object value;
    private Object originalValue;
    private String category;
    private boolean enabled = true;
    private PTEditor editor;
    private PropertyTable parentTable;
    private Item associatedItem;

    public PTProperty(String name, String displayName, String description) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
    }

    public PTProperty(String name, String displayName, String description, Object value) {
        this(name, displayName, description);
        this.value = value;
        this.originalValue = this.clone(value);
    }

    private Object clone(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bis);
            return in.readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PTEditor getEditor() {
        return this.editor;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PTProperty setCategory(String category) {
        this.category = category;
        return this;
    }

    public PTProperty setEditor(PTEditor editor) {
        this.editor = editor;
        return this;
    }

    public PTProperty setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PTProperty setParentTable(PropertyTable parentTable) {
        this.parentTable = parentTable;
        return this;
    }

    void setAssociatedItem(Item item) {
        this.associatedItem = item;
    }

    public void changeFont(Font font) {
        if (font == null) {
            SWT.error((int)4);
        }
        if (font.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.associatedItem instanceof TableItem) {
            ((TableItem)this.associatedItem).setFont(0, font);
        } else {
            ((TreeItem)this.associatedItem).setFont(0, font);
        }
    }

    public void changeBackgroundColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        if (color.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.associatedItem instanceof TableItem) {
            ((TableItem)this.associatedItem).setBackground(0, color);
        } else {
            ((TreeItem)this.associatedItem).setBackground(0, color);
        }
    }

    public void changeForegroundColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        if (color.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.associatedItem instanceof TableItem) {
            ((TableItem)this.associatedItem).setForeground(0, color);
        } else {
            ((TreeItem)this.associatedItem).setForeground(0, color);
        }
    }

    public PTProperty setValue(Object value) {
        this.value = value;
        this.parentTable.firePTPropertyChangeListeners(this);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PTProperty other = (PTProperty)obj;
        return Objects.equals(this.name, other.name);
    }

    public void discardChange() {
        this.value = this.originalValue;
        this.parentTable.rebuild();
    }
}

