/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.promptsupport;

import org.eclipse.nebula.widgets.opal.promptsupport.BaseFocusControlListener;
import org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

class ComboFocusControlListener
extends BaseFocusControlListener<Combo>
implements ModifyListener {
    protected boolean updatingPropmpt = false;

    public ComboFocusControlListener(Combo control) {
        super(control);
    }

    @Override
    void hookControl() {
        super.hookControl();
        ((Combo)this.control).addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        if (this.updatingPropmpt) {
            return;
        }
        String trimmedText = ((Combo)this.control).getText().trim();
        this.applyInitialLook();
        if (!"".equals(trimmedText)) {
            PromptSupport.setPromptDisplayed(this.control, false);
            return;
        }
        if (!((Combo)this.control).isFocusControl()) {
            this.storeInitialLook();
            this.applyPromptLook();
            this.fillPromptText();
            PromptSupport.setPromptDisplayed(this.control, true);
            return;
        }
    }

    @Override
    protected void hidePrompt() {
        this.updatePrompt("");
    }

    @Override
    protected void highLightPrompt() {
    }

    @Override
    protected void fillPromptText() {
        String promptText = PromptSupport.getPrompt(this.control);
        if (promptText != null) {
            ((Combo)this.control).getDisplay().asyncExec(() -> {
                if (((Combo)this.control).isDisposed()) {
                    return;
                }
                if (PromptSupport.isPromptDisplayed(this.control)) {
                    this.updatePrompt(promptText);
                }
            });
        }
    }

    @Override
    protected boolean isFilled() {
        String promptText = PromptSupport.getPrompt(this.control);
        String trimmedText = ((Combo)this.control).getText().trim();
        if (promptText != null && promptText.equals(trimmedText) && PromptSupport.isPromptDisplayed(this.control)) {
            return false;
        }
        return !"".equals(trimmedText);
    }

    protected void updatePrompt(String prompt) {
        try {
            this.updatingPropmpt = true;
            ((Combo)this.control).setText(prompt);
        }
        finally {
            this.updatingPropmpt = false;
        }
    }
}

