/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWChooser;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Text;

public class PWFontChooser
extends PWChooser {
    private FontData fontData;

    public PWFontChooser(String label, String propertyKey) {
        super(label, propertyKey);
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else if (!(value instanceof FontData)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a FontData because it is associated to a font chooser");
        }
    }

    @Override
    protected void setButtonAction(Text text, Button button) {
        this.fontData = (FontData)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        button.addListener(13, event -> {
            FontDialog dialog = new FontDialog(text.getShell());
            FontData result = dialog.open();
            if (result != null && result.getName() != null && !"".equals(result.getName().trim())) {
                this.fontData = result;
                PreferenceWindow.getInstance().setValue(this.getPropertyKey(), result);
                text.setText(this.buildFontInformation());
            }
        });
        text.setText(this.buildFontInformation());
    }

    protected String buildFontInformation() {
        StringBuilder sb = new StringBuilder();
        if (this.fontData != null) {
            sb.append(this.fontData.getName()).append(",").append(this.fontData.getHeight()).append(" pt");
            if ((this.fontData.getStyle() & 1) == 1) {
                sb.append(", ").append(ResourceManager.getLabel((String)"bold"));
            }
            if ((this.fontData.getStyle() & 2) == 2) {
                sb.append(", ").append(ResourceManager.getLabel((String)"italic"));
            }
        }
        return sb.toString();
    }
}

