/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWWidget;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PWCombo
extends PWWidget {
    private final List<Object> data;
    private final boolean editable;

    public PWCombo(String label, String propertyKey, Object ... values) {
        this(label, propertyKey, false, values);
    }

    public PWCombo(String label, String propertyKey, boolean editable, Object ... values) {
        super(label, propertyKey, label == null ? 1 : 2, false);
        this.data = new ArrayList<Object>(Arrays.asList(values));
        this.editable = editable;
    }

    @Override
    public Control build(Composite parent) {
        this.buildLabel(parent, 2);
        Combo combo = new Combo(parent, 0x800 | (this.editable ? 0 : 8));
        this.addControl((Control)combo);
        int i = 0;
        while (i < this.data.size()) {
            Object datum = this.data.get(i);
            combo.add(datum.toString());
            if (datum.equals(PreferenceWindow.getInstance().getValueFor(this.getPropertyKey()))) {
                combo.select(i);
            }
            ++i;
        }
        combo.addListener(24, event -> PreferenceWindow.getInstance().setValue(this.getPropertyKey(), this.data.get(combo.getSelectionIndex())));
        return combo;
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else {
            if (this.editable && !(value instanceof String)) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a String because it is associated to an editable combo");
            }
            if (!this.data.isEmpty() && !value.getClass().equals(this.data.get(0).getClass())) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a " + String.valueOf(this.data.get(0).getClass()) + " because it is associated to a combo");
            }
        }
    }
}

