/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DateChooserTheme {
    public static final DateChooserTheme GRAY = new DateChooserTheme();
    public static final DateChooserTheme BLUE = DateChooserTheme.createBlueTheme();
    public static final DateChooserTheme YELLOW = DateChooserTheme.createYellowTheme();
    public static final DateChooserTheme CLASSIC = DateChooserTheme.createClassicTheme();
    public static final DateChooserTheme SYSTEM = DateChooserTheme.createSystemTheme();
    protected static DateChooserTheme defaultTheme = GRAY;
    Color borderBackground;
    Color headerBackground;
    Color headerForeground;
    Color gridHeaderBackground;
    Color gridHeaderForeground;
    Color gridLinesColor;
    Color dayCellBackground;
    Color dayCellForeground;
    Color selectedBackground;
    Color selectedForeground;
    Color todayBackground;
    Color todayForeground;
    Color extraMonthForeground;
    Color weekendForeground;
    Color focusColor;
    int borderSize = 0;
    int gridVisible = 2;
    int cellPadding = 2;
    Font font = null;
    private final Map<String, CustomCellProperty> customCellProperties = new HashMap<String, CustomCellProperty>();

    public DateChooserTheme() {
        Display display = Display.getCurrent();
        this.headerBackground = this.borderBackground = display.getSystemColor(22);
        this.headerForeground = display.getSystemColor(21);
        this.gridHeaderBackground = this.headerBackground;
        this.gridHeaderForeground = this.headerForeground;
        this.gridLinesColor = display.getSystemColor(15);
        this.dayCellBackground = display.getSystemColor(1);
        this.dayCellForeground = this.headerForeground;
        this.selectedBackground = display.getSystemColor(7);
        this.selectedForeground = this.headerForeground;
        this.todayBackground = this.headerBackground;
        this.todayForeground = this.headerForeground;
        this.extraMonthForeground = this.gridLinesColor;
        this.weekendForeground = new Color((Device)display, 180, 0, 0);
        this.focusColor = display.getSystemColor(3);
    }

    private static DateChooserTheme createBlueTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.gridHeaderBackground = theme.headerBackground = new Color((Device)display, 170, 190, 220);
        theme.dayCellBackground = new Color((Device)display, 190, 220, 240);
        theme.extraMonthForeground = display.getSystemColor(16);
        theme.weekendForeground = display.getSystemColor(3);
        theme.todayBackground = display.getSystemColor(1);
        return theme;
    }

    private static DateChooserTheme createClassicTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.gridHeaderBackground = theme.borderBackground = display.getSystemColor(1);
        theme.borderSize = 3;
        theme.cellPadding = 3;
        theme.gridVisible = 1;
        return theme;
    }

    private static DateChooserTheme createSystemTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.borderBackground = display.getSystemColor(25);
        theme.headerBackground = display.getSystemColor(22);
        theme.headerForeground = display.getSystemColor(21);
        theme.gridHeaderBackground = theme.borderBackground;
        theme.gridHeaderForeground = display.getSystemColor(24);
        theme.gridLinesColor = display.getSystemColor(18);
        theme.dayCellBackground = theme.borderBackground;
        theme.dayCellForeground = theme.gridHeaderForeground;
        theme.selectedBackground = display.getSystemColor(26);
        theme.selectedForeground = display.getSystemColor(27);
        theme.todayBackground = theme.borderBackground;
        theme.todayForeground = theme.gridHeaderForeground;
        theme.extraMonthForeground = theme.gridLinesColor;
        theme.weekendForeground = theme.dayCellForeground;
        theme.focusColor = display.getSystemColor(31);
        theme.borderSize = 3;
        theme.cellPadding = 3;
        theme.gridVisible = 1;
        return theme;
    }

    private static DateChooserTheme createYellowTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.gridHeaderBackground = theme.headerBackground = new Color((Device)display, 190, 180, 60);
        theme.dayCellBackground = new Color((Device)display, 255, 255, 170);
        theme.extraMonthForeground = display.getSystemColor(16);
        theme.weekendForeground = display.getSystemColor(3);
        theme.todayBackground = display.getSystemColor(15);
        theme.selectedBackground = display.getSystemColor(6);
        theme.selectedForeground = display.getSystemColor(1);
        return theme;
    }

    public static DateChooserTheme getDefaultTheme() {
        return defaultTheme;
    }

    public static void setDefaultTheme(DateChooserTheme defaultTheme) {
        if (defaultTheme == null) {
            SWT.error((int)4);
        }
        DateChooserTheme.defaultTheme = defaultTheme;
    }

    public void setBorderBackground(Color borderBackground) {
        this.borderBackground = borderBackground;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    public void setDayCellBackground(Color dayCellBackground) {
        this.dayCellBackground = dayCellBackground;
    }

    public void setDayCellBackground(int dayCellBackground) {
        this.dayCellBackground = Display.getCurrent().getSystemColor(dayCellBackground);
    }

    public void setDayCellForeground(Color dayCellForeground) {
        this.dayCellForeground = dayCellForeground;
    }

    public void setDayCellForeground(int dayCellForeground) {
        this.dayCellForeground = Display.getCurrent().getSystemColor(dayCellForeground);
    }

    public void setGridHeaderBackground(Color gridHeaderBackground) {
        this.gridHeaderBackground = gridHeaderBackground;
    }

    public void setGridHeaderBackground(int gridHeaderBackground) {
        this.gridHeaderBackground = Display.getCurrent().getSystemColor(gridHeaderBackground);
    }

    public void setGridHeaderForeground(Color gridHeaderForeground) {
        this.gridHeaderForeground = gridHeaderForeground;
    }

    public void setGridHeaderForeground(int gridHeaderForeground) {
        this.gridHeaderForeground = Display.getCurrent().getSystemColor(gridHeaderForeground);
    }

    public void setGridLinesColor(Color gridLinesColor) {
        this.gridLinesColor = gridLinesColor;
    }

    public void setGridLinesColor(int gridLinesColor) {
        this.gridLinesColor = Display.getCurrent().getSystemColor(gridLinesColor);
    }

    public void setHeaderBack(Color headerBackground) {
        this.headerBackground = headerBackground;
    }

    public void setHeaderBack(int headerBackground) {
        this.headerBackground = Display.getCurrent().getSystemColor(headerBackground);
    }

    public void setHeaderForg(Color headerForeground) {
        this.headerForeground = headerForeground;
    }

    public void setHeaderForg(int headerForeground) {
        this.headerForeground = Display.getCurrent().getSystemColor(headerForeground);
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackground = selectedBackground;
    }

    public void setSelectedBackground(int selectedBackground) {
        this.selectedBackground = Display.getCurrent().getSystemColor(selectedBackground);
    }

    public void setSelectedForeground(Color selectedForeground) {
        this.selectedForeground = selectedForeground;
    }

    public void setSelectedForeground(int selectedForeground) {
        this.selectedForeground = Display.getCurrent().getSystemColor(selectedForeground);
    }

    public void setTodayBackground(Color todayBackground) {
        this.todayBackground = todayBackground;
    }

    public void setTodayBackground(int todayBackground) {
        this.todayBackground = Display.getCurrent().getSystemColor(todayBackground);
    }

    public void setTodayForeground(Color todayForeground) {
        this.todayForeground = todayForeground;
    }

    public void setTodayForeground(int todayForeground) {
        this.todayForeground = Display.getCurrent().getSystemColor(todayForeground);
    }

    public void setExtraMonthForeground(Color extraMonthForeground) {
        this.extraMonthForeground = extraMonthForeground;
    }

    public void setAdjascentForeground(int extraMonthForeground) {
        this.extraMonthForeground = Display.getCurrent().getSystemColor(extraMonthForeground);
    }

    public void setWeekendForeground(Color weekendForeground) {
        this.weekendForeground = weekendForeground;
    }

    public void setWeekendForeground(int weekendForeground) {
        this.weekendForeground = Display.getCurrent().getSystemColor(weekendForeground);
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public void setFocusColor(int focusColor) {
        this.focusColor = Display.getCurrent().getSystemColor(focusColor);
    }

    @Deprecated
    public void setGridVisible(boolean gridVisible) {
        this.setGridVisible(gridVisible ? 2 : 0);
    }

    public void setGridVisible(int gridVisible) {
        this.gridVisible = gridVisible;
    }

    public void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    private CustomCellProperty getCellProperty(Date date) {
        if (date != null) {
            String strDate = new SimpleDateFormat("yyyy.MM.dd").format(date);
            return this.customCellProperties.get(strDate);
        }
        return this.customCellProperties.get(null);
    }

    private CustomCellProperty getCellPropertyOrDefault(Date date) {
        CustomCellProperty property = this.getCellProperty(date);
        if (property == null) {
            return this.customCellProperties.get(null);
        }
        return property;
    }

    private void setCellProperty(Date date, CustomCellProperty cellProperty) {
        String key = null;
        if (date != null) {
            key = new SimpleDateFormat("yyyy.MM.dd").format(date);
        }
        this.customCellProperties.put(key, cellProperty);
    }

    public void clearCustomColors() {
        Iterator<CustomCellProperty> valuesIt = this.customCellProperties.values().iterator();
        CustomCellProperty cellProperty = null;
        while (valuesIt.hasNext()) {
            cellProperty = valuesIt.next();
            cellProperty.bgColor = null;
        }
    }

    public void clearCustomTooltips() {
        Iterator<CustomCellProperty> valuesIt = this.customCellProperties.values().iterator();
        CustomCellProperty cellProperty = null;
        while (valuesIt.hasNext()) {
            cellProperty = valuesIt.next();
            cellProperty.tooltip = null;
        }
    }

    public void clearCustomStates() {
        Iterator<CustomCellProperty> valuesIt = this.customCellProperties.values().iterator();
        CustomCellProperty cellProperty = null;
        while (valuesIt.hasNext()) {
            cellProperty = valuesIt.next();
            cellProperty.enabledState = true;
        }
    }

    public void clearAllCustom() {
        this.customCellProperties.clear();
    }

    public boolean getCustomState(Date date) {
        CustomCellProperty cellProperty = this.getCellPropertyOrDefault(date);
        if (cellProperty == null) {
            return true;
        }
        return cellProperty.enabledState;
    }

    public void setCustomState(Date date, boolean enabled) {
        CustomCellProperty cellProperty = this.getCellProperty(date);
        if (cellProperty == null) {
            cellProperty = new CustomCellProperty();
            cellProperty.enabledState = enabled;
            this.setCellProperty(date, cellProperty);
        } else {
            cellProperty.enabledState = enabled;
        }
    }

    public Color getCustomColor(Date date) {
        CustomCellProperty cellProperty = this.getCellPropertyOrDefault(date);
        if (cellProperty == null) {
            return null;
        }
        return cellProperty.bgColor;
    }

    public void setCustomColor(Date date, Color color) {
        CustomCellProperty cellProperty = this.getCellProperty(date);
        if (cellProperty == null) {
            cellProperty = new CustomCellProperty();
            cellProperty.bgColor = color;
            this.setCellProperty(date, cellProperty);
        } else {
            cellProperty.bgColor = color;
        }
    }

    public String getCustomTootlip(Date date) {
        CustomCellProperty cellProperty = this.getCellPropertyOrDefault(date);
        if (cellProperty == null) {
            return null;
        }
        return cellProperty.tooltip;
    }

    public void setCustomTooltip(Date date, String tootlip) {
        CustomCellProperty cellProperty = this.getCellProperty(date);
        if (cellProperty == null) {
            cellProperty = new CustomCellProperty();
            cellProperty.tooltip = tootlip;
            this.setCellProperty(date, cellProperty);
        } else {
            cellProperty.tooltip = tootlip;
        }
    }

    public void setCustom(Date date, String tootlip, Color color, boolean enabled) {
        CustomCellProperty cellProperty = this.getCellProperty(date);
        if (cellProperty == null) {
            cellProperty = new CustomCellProperty();
            cellProperty.tooltip = tootlip;
            cellProperty.bgColor = color;
            cellProperty.enabledState = enabled;
            this.setCellProperty(date, cellProperty);
        } else {
            cellProperty.tooltip = tootlip;
            cellProperty.bgColor = color;
            cellProperty.enabledState = enabled;
        }
    }

    public Object clone() {
        DateChooserTheme theme = new DateChooserTheme();
        theme.borderBackground = this.borderBackground;
        theme.borderSize = this.borderSize;
        theme.cellPadding = this.cellPadding;
        theme.dayCellBackground = this.dayCellBackground;
        theme.dayCellForeground = this.dayCellForeground;
        theme.extraMonthForeground = this.extraMonthForeground;
        theme.focusColor = this.focusColor;
        theme.font = this.font;
        theme.gridHeaderBackground = this.gridHeaderBackground;
        theme.gridHeaderForeground = this.gridHeaderForeground;
        theme.gridLinesColor = this.gridLinesColor;
        theme.gridVisible = this.gridVisible;
        theme.headerBackground = this.headerBackground;
        theme.headerForeground = this.headerForeground;
        theme.selectedBackground = this.selectedBackground;
        theme.selectedForeground = this.selectedForeground;
        theme.todayBackground = this.todayBackground;
        theme.todayForeground = this.todayForeground;
        theme.weekendForeground = this.weekendForeground;
        return theme;
    }

    private class CustomCellProperty {
        public Color bgColor;
        public boolean enabledState = true;
        public String tooltip;

        private CustomCellProperty() {
        }
    }
}

