/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser.example;

import java.util.Locale;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.datechooser.DateChooserCombo;
import org.eclipse.nebula.widgets.datechooser.DateChooserTheme;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DateChooserComboExampleTab
extends AbstractExampleTab {
    public static final String GRAY_THEME = "GRAY (default)";
    public static final String BLUE_THEME = "BLUE";
    public static final String YELLOW_THEME = "YELLOW";
    private DateChooserCombo chooserCombo = null;
    private Button borderStyle;
    private Button readOnlyStyle;
    private Button flatStyle;
    private Combo themes;
    private Locale locale;
    private Button gridVisible;
    private Button footerVisible;
    private Listener recreateListener = new Listener(){

        public void handleEvent(Event event) {
            DateChooserComboExampleTab.this.recreateExample();
        }
    };

    private void applyTheme() {
        switch (this.themes.getSelectionIndex()) {
            case 0: {
                this.chooserCombo.setTheme(DateChooserTheme.GRAY);
                break;
            }
            case 1: {
                this.chooserCombo.setTheme(DateChooserTheme.BLUE);
                break;
            }
            case 2: {
                this.chooserCombo.setTheme(DateChooserTheme.YELLOW);
            }
        }
    }

    private Button createCheckBox2(Composite parent, String text, boolean selected) {
        Button cb = new Button(parent, 32);
        cb.setText(text);
        cb.setSelection(selected);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        cb.setLayoutData((Object)data);
        return cb;
    }

    public Control createControl(Composite parent) {
        int style = 0;
        if (this.borderStyle.getSelection()) {
            style |= 0x800;
        }
        if (this.readOnlyStyle.getSelection()) {
            style |= 8;
        }
        if (this.flatStyle.getSelection()) {
            style |= 0x800000;
        }
        this.chooserCombo = new DateChooserCombo(parent, style);
        this.applyTheme();
        this.chooserCombo.setGridVisible(this.gridVisible.getSelection());
        this.chooserCombo.setFooterVisible(this.footerVisible.getSelection());
        return this.chooserCombo;
    }

    public String[] createLinks() {
        return null;
    }

    private void createGUISettingsGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("GUI Settings");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)gp);
        gp.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label((Composite)gp, 0).setText("Themes:");
        this.themes = new Combo((Composite)gp, 2048);
        this.themes.setItems(new String[]{GRAY_THEME, BLUE_THEME, YELLOW_THEME});
        this.themes.select(0);
        this.themes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserComboExampleTab.this.applyTheme();
            }
        });
        new Label((Composite)gp, 0).setText("Locale:");
        final Combo localeCombo = new Combo((Composite)gp, 2048);
        final Locale[] locales = Locale.getAvailableLocales();
        Locale dl = Locale.getDefault();
        int i = 0;
        while (i < locales.length) {
            localeCombo.add(locales[i].getDisplayName());
            if (locales[i].equals(dl)) {
                localeCombo.select(i);
            }
            ++i;
        }
        localeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserComboExampleTab.this.locale = locales[localeCombo.getSelectionIndex()];
                DateChooserComboExampleTab.this.chooserCombo.setLocale(DateChooserComboExampleTab.this.locale);
            }
        });
        this.gridVisible = this.createCheckBox2((Composite)gp, "GridVisible", true);
        this.gridVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserComboExampleTab.this.chooserCombo.setGridVisible(DateChooserComboExampleTab.this.gridVisible.getSelection());
            }
        });
        this.footerVisible = this.createCheckBox2((Composite)gp, "FooterVisible", false);
        this.footerVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserComboExampleTab.this.chooserCombo.setFooterVisible(DateChooserComboExampleTab.this.footerVisible.getSelection());
                DateChooserComboExampleTab.this.chooserCombo.getParent().layout();
            }
        });
    }

    private void createStyleGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("Style");
        gp.setLayout((Layout)new RowLayout());
        GridData data = new GridData(4, 4, false, false);
        gp.setLayoutData((Object)data);
        this.borderStyle = new Button((Composite)gp, 32);
        this.borderStyle.setText("SWT.BORDER");
        this.borderStyle.addListener(13, this.recreateListener);
        this.readOnlyStyle = new Button((Composite)gp, 32);
        this.readOnlyStyle.setText("SWT.READ_ONLY");
        this.readOnlyStyle.addListener(13, this.recreateListener);
        this.flatStyle = new Button((Composite)gp, 32);
        this.flatStyle.setText("SWT.FLAT");
        this.flatStyle.addListener(13, this.recreateListener);
    }

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(1).applyTo(parent);
        this.createStyleGroup(parent);
        this.createGUISettingsGroup(parent);
    }
}

