/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IMetaData;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;

public class Sample
implements ISample,
IMetaData {
    private final double xValue;
    private final double yValue;
    private final double xPlusError;
    private final double yPlusError;
    private final double xMinusError;
    private final double yMinusError;
    private final String info;
    private Object fMetaData;
    private Map<String, Object> fMetaDataMap = new HashMap<String, Object>();

    public Sample(double xdata, double ydata) {
        this(xdata, ydata, 0.0, 0.0, 0.0, 0.0, "");
    }

    public Sample(double xValue, double yValue, double yPlusError, double yMinusError, double xPlusError, double xMinusError) {
        this(xValue, yValue, yPlusError, yMinusError, xPlusError, xMinusError, "");
    }

    public Sample(double xValue, double yValue, double yPlusError, double yMinusError, double xPlusError, double xMinusError, String info) {
        this.xValue = xValue;
        this.yValue = yValue;
        this.xPlusError = xPlusError;
        this.yPlusError = yPlusError;
        this.xMinusError = xMinusError;
        this.yMinusError = yMinusError;
        this.info = info;
    }

    @Override
    public double getXValue() {
        return this.xValue;
    }

    @Override
    public double getYValue() {
        return this.yValue;
    }

    @Override
    public double getXMinusError() {
        return this.xMinusError;
    }

    @Override
    public double getXPlusError() {
        return this.xPlusError;
    }

    @Override
    public double getYMinusError() {
        return this.yMinusError;
    }

    @Override
    public double getYPlusError() {
        return this.yPlusError;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        long temp = Double.doubleToLongBits(this.xMinusError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.xPlusError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.xValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yMinusError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yPlusError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xMinusError) != Double.doubleToLongBits(other.xMinusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xPlusError) != Double.doubleToLongBits(other.xPlusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xValue) != Double.doubleToLongBits(other.xValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.yMinusError) != Double.doubleToLongBits(other.yMinusError)) {
            return false;
        }
        if (Double.doubleToLongBits(this.yPlusError) != Double.doubleToLongBits(other.yPlusError)) {
            return false;
        }
        return Double.doubleToLongBits(this.yValue) == Double.doubleToLongBits(other.yValue);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        buf.append(this.xValue);
        if (this.xMinusError != 0.0 || this.xPlusError != 0.0) {
            buf.append(" [-" + this.xMinusError + " ... +" + this.xPlusError + "]");
        }
        buf.append(", ");
        buf.append(this.yValue);
        if (this.yMinusError != 0.0 || this.yPlusError != 0.0) {
            buf.append(" [-" + this.yMinusError + " ... +" + this.yPlusError + "]");
        }
        if (this.info != null && this.info.length() > 0) {
            buf.append(", '" + this.info + "'");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public void setData(Object metaData) {
        this.fMetaData = metaData;
    }

    @Override
    public Object getData() {
        return this.fMetaData;
    }

    @Override
    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        return this.fMetaDataMap.get(key);
    }

    @Override
    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        if (data == null && this.fMetaDataMap.containsKey(key)) {
            this.fMetaDataMap.remove(key);
        } else {
            this.fMetaDataMap.put(key, data);
        }
    }

    @Override
    public Map<String, Object> getDataCollection() {
        return Collections.unmodifiableMap(this.fMetaDataMap);
    }
}

