/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.exampleview;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.styleprovider.BasePointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.styleprovider.IPointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class XYGraphStyledDoubleExampleView
extends ViewPart {
    public void createPartControl(Composite parent) {
        LightweightSystem lws = new LightweightSystem(new Canvas(parent, 0));
        XYGraph xyGraph = new XYGraph();
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph((IXYGraph)xyGraph);
        xyGraph.setTitle("Simple Styled Example");
        lws.setContents((IFigure)toolbarArmedXYGraph);
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        traceDataProvider.setBufferSize(100);
        traceDataProvider.setCurrentXDataArray(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6});
        traceDataProvider.setCurrentYDataArray(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        Trace trace = new Trace("Trace-Styled XY Plot", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY));
        trace.setTraceType(Trace.TraceType.POINT);
        trace.setPointStyle(Trace.PointStyle.FILLED_SQUARE);
        trace.setPointSize(40);
        trace.setPointStyleProvider((IPointStyleProvider)new Rainbowstyle());
        xyGraph.addTrace(trace);
        xyGraph.performAutoScale();
    }

    public void setFocus() {
    }

    class Rainbowstyle
    extends BasePointStyleProvider {
        Rainbowstyle() {
        }

        public Color getPointColor(ISample sample, Trace trace) {
            if (sample == null) {
                return super.getPointColor(sample, trace);
            }
            if (sample.getXValue() < 0.1) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_PURPLE);
            }
            if (sample.getXValue() < 0.2) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE);
            }
            if (sample.getXValue() < 0.3) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GREEN);
            }
            if (sample.getXValue() < 0.4) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_YELLOW);
            }
            if (sample.getXValue() < 0.5) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_ORANGE);
            }
            if (sample.getXValue() < 0.6) {
                return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED);
            }
            return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
        }
    }
}

