/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.widgets;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;

class RotateClockwisePrintPiece
implements PrintPiece {
    private final Device device;
    private final PrintPiece target;
    private final Point size;

    RotateClockwisePrintPiece(Device device, PrintPiece target) {
        if (device == null || target == null) {
            PaperClips.error((int)4);
        }
        this.device = device;
        this.target = target;
        Point targetSize = target.getSize();
        this.size = new Point(targetSize.y, targetSize.x);
    }

    public void dispose() {
        this.target.dispose();
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    public void paint(GC gc, int x, int y) {
        Transform oldTransform = null;
        Transform newTransform = null;
        try {
            oldTransform = new Transform(this.device);
            gc.getTransform(oldTransform);
            newTransform = new Transform(this.device);
            gc.getTransform(newTransform);
            newTransform.translate((float)x, (float)y);
            newTransform.translate((float)this.size.x, 0.0f);
            newTransform.rotate(90.0f);
            gc.setTransform(newTransform);
            this.target.paint(gc, 0, 0);
            gc.setTransform(oldTransform);
        }
        finally {
            if (oldTransform != null) {
                oldTransform.dispose();
            }
            if (newTransform != null) {
                newTransform.dispose();
            }
        }
    }
}

