/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.text;

import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.piece.EmptyPiece;
import org.eclipse.nebula.paperclips.core.internal.util.ResourcePool;
import org.eclipse.nebula.paperclips.core.text.LineBreakPrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class LineBreakIterator
implements PrintIterator {
    private static final int MIN_HEIGHT = 0;
    private static final int MIN_WIDTH = 1;
    private final int lineHeight;
    private boolean hasNext = true;

    LineBreakIterator(LineBreakPrint print, Device device, GC gc) {
        this(LineBreakIterator.calculateLineHeight(print, device, gc));
    }

    private LineBreakIterator(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    private static int calculateLineHeight(LineBreakPrint print, Device device, GC gc) {
        Font oldFont = gc.getFont();
        gc.setFont(ResourcePool.forDevice(device).getFont(print.font));
        int result = gc.getFontMetrics().getHeight();
        gc.setFont(oldFont);
        return result;
    }

    @Override
    public Point minimumSize() {
        return new Point(1, 0);
    }

    @Override
    public Point preferredSize() {
        return new Point(1, this.lineHeight);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public PrintPiece next(int width, int height) {
        if (width < 1 || height < 0) {
            return null;
        }
        this.hasNext = false;
        return new EmptyPiece(new Point(width, Math.min(height, this.lineHeight)));
    }

    @Override
    public PrintIterator copy() {
        return this.hasNext ? new LineBreakIterator(this.lineHeight) : this;
    }
}

