/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.roundedswitch;

import java.util.EventListener;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.nebula.widgets.roundedswitch.RoundedSwitchConfiguration;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RoundedSwitch
extends Canvas {
    private int borderWidth = 2;
    private RoundedSwitchConfiguration checkedEnabledConfiguration = RoundedSwitchConfiguration.createCheckedEnabledConfiguration(this);
    private RoundedSwitchConfiguration uncheckedEnabledConfiguration = RoundedSwitchConfiguration.createUncheckedEnabledConfiguration(this);
    private RoundedSwitchConfiguration checkedDisabledConfiguration = RoundedSwitchConfiguration.createCheckedDisabledConfiguration(this);
    private RoundedSwitchConfiguration uncheckedDisabledConfiguration = RoundedSwitchConfiguration.createUncheckedDisabledConfiguration(this);
    private static final int DEFAULT_WIDTH = 45;
    private static final int DEFAULT_HEIGHT = 20;
    private boolean selected = false;
    private GC gc;

    public RoundedSwitch(Composite parent, int style) {
        super(parent, RoundedSwitch.checkStyle(style) | 0x20000000);
        this.addListener(9, e -> {
            this.gc = e.gc;
            this.drawWidget();
        });
        this.addListener(4, e -> this.onClick(e));
        this.addListener(2, e -> this.onKeyPress(e));
        this.addListener(6, e -> {
            if (!this.isEnabled()) {
                return;
            }
            this.setCursor(this.getDisplay().getSystemCursor(21));
        });
        this.addListener(7, e -> {
            if (!this.isEnabled()) {
                return;
            }
            this.setCursor(this.getDisplay().getSystemCursor(0));
        });
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private void drawWidget() {
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        Color previousForeground = this.gc.getForeground();
        Color previousBackground = this.gc.getBackground();
        if (this.isEnabled()) {
            if (this.selected) {
                this.drawCheckedEnabled();
            } else {
                this.drawUncheckedEnabled();
            }
        } else if (this.selected) {
            this.drawCheckedDisabled();
        } else {
            this.drawUncheckedDisabled();
        }
        this.gc.setBackground(previousBackground);
        this.gc.setForeground(previousForeground);
    }

    private void drawCheckedEnabled() {
        this.gc.setBackground(this.checkedEnabledConfiguration.backgroundColor);
        this.drawOuterRoundedRectangle();
        this.gc.setForeground(this.checkedEnabledConfiguration.borderColor);
        this.drawBorderRoundedRectangle();
        this.gc.setBackground(this.checkedEnabledConfiguration.circleColor);
        this.drawCircle();
    }

    private void drawOuterRoundedRectangle() {
        int width = this.getSize().x;
        int height = this.getSize().y;
        this.gc.fillRoundRectangle(2, 2, width - 4, height - 4, height - 4, height - 4);
    }

    private void drawBorderRoundedRectangle() {
        if (this.gc.getForeground().equals((Object)this.gc.getBackground())) {
            return;
        }
        int width = this.getSize().x;
        int height = this.getSize().y;
        this.gc.setLineWidth(this.borderWidth);
        this.gc.drawRoundRectangle(2, 2, width - 4, height - 4, height - 4, height - 4);
    }

    private void drawCircle() {
        int width = this.getSize().x;
        int height = this.getSize().y;
        int x = this.selected ? width - height + 4 : 6;
        this.gc.fillOval(x, 5, height - 10, height - 10);
    }

    private void drawUncheckedEnabled() {
        this.gc.setBackground(this.uncheckedEnabledConfiguration.backgroundColor);
        this.drawOuterRoundedRectangle();
        this.gc.setForeground(this.uncheckedEnabledConfiguration.borderColor);
        this.drawBorderRoundedRectangle();
        this.gc.setBackground(this.uncheckedEnabledConfiguration.circleColor);
        this.drawCircle();
    }

    private void drawCheckedDisabled() {
        this.gc.setBackground(this.checkedDisabledConfiguration.backgroundColor);
        this.drawOuterRoundedRectangle();
        this.gc.setForeground(this.checkedDisabledConfiguration.borderColor);
        this.drawBorderRoundedRectangle();
        this.gc.setBackground(this.checkedDisabledConfiguration.circleColor);
        this.drawCircle();
    }

    private void drawUncheckedDisabled() {
        this.gc.setBackground(this.uncheckedDisabledConfiguration.backgroundColor);
        this.drawOuterRoundedRectangle();
        this.gc.setForeground(this.uncheckedDisabledConfiguration.borderColor);
        this.drawOuterRoundedRectangle();
        this.gc.setBackground(this.uncheckedDisabledConfiguration.circleColor);
        this.drawCircle();
    }

    private void onClick(Event e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e)) {
            this.setSelection(!this.selected);
        }
    }

    private void onKeyPress(Event e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.character == ' ' || e.character == '+') {
            this.setSelection(!this.selected);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 45;
        int height = 20;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selected;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        this.selected = selected;
        this.redraw();
        this.update();
    }

    public int getBorderWidth() {
        this.checkWidget();
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.checkWidget();
        this.borderWidth = borderWidth;
    }

    public Color getBorderColorCheckedEnabled() {
        this.checkWidget();
        return this.checkedEnabledConfiguration.borderColor;
    }

    public void setBorderColorCheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedEnabledConfiguration(this);
            this.checkedEnabledConfiguration.borderColor = temp.borderColor;
        } else {
            this.checkedEnabledConfiguration.borderColor = color;
        }
    }

    public Color getBorderColorUncheckedEnabled() {
        this.checkWidget();
        return this.uncheckedEnabledConfiguration.borderColor;
    }

    public void setBorderColorUncheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedEnabledConfiguration(this);
            this.uncheckedEnabledConfiguration.borderColor = temp.borderColor;
        } else {
            this.uncheckedEnabledConfiguration.borderColor = color;
        }
    }

    public Color getBorderColorCheckedDisabled() {
        this.checkWidget();
        return this.checkedDisabledConfiguration.borderColor;
    }

    public void setBorderColorCheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedDisabledConfiguration(this);
            this.checkedDisabledConfiguration.borderColor = temp.borderColor;
        } else {
            this.checkedDisabledConfiguration.borderColor = color;
        }
    }

    public Color getBorderColorUncheckedDisabled() {
        this.checkWidget();
        return this.uncheckedDisabledConfiguration.borderColor;
    }

    public void setBorderColorUncheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedDisabledConfiguration(this);
            this.uncheckedDisabledConfiguration.borderColor = temp.borderColor;
        } else {
            this.uncheckedDisabledConfiguration.borderColor = color;
        }
    }

    public Color getCircleColorCheckedEnabled() {
        this.checkWidget();
        return this.checkedEnabledConfiguration.circleColor;
    }

    public void setCircleColorCheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedEnabledConfiguration(this);
            this.checkedEnabledConfiguration.circleColor = temp.circleColor;
        } else {
            this.checkedEnabledConfiguration.circleColor = color;
        }
    }

    public Color getCircleColorUncheckedEnabled() {
        this.checkWidget();
        return this.uncheckedEnabledConfiguration.circleColor;
    }

    public void setCircleColorUncheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedEnabledConfiguration(this);
            this.uncheckedEnabledConfiguration.circleColor = temp.circleColor;
        } else {
            this.uncheckedEnabledConfiguration.circleColor = color;
        }
    }

    public Color getCircleColorCheckedDisabled() {
        this.checkWidget();
        return this.checkedDisabledConfiguration.circleColor;
    }

    public void setCircleColorCheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedDisabledConfiguration(this);
            this.checkedDisabledConfiguration.circleColor = temp.circleColor;
        } else {
            this.checkedDisabledConfiguration.circleColor = color;
        }
    }

    public Color getCircleColorUncheckedDisabled() {
        this.checkWidget();
        return this.uncheckedDisabledConfiguration.circleColor;
    }

    public void setCircleColorUncheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedDisabledConfiguration(this);
            this.uncheckedDisabledConfiguration.circleColor = temp.circleColor;
        } else {
            this.uncheckedDisabledConfiguration.circleColor = color;
        }
    }

    public Color getBackgroundColorCheckedEnabled() {
        this.checkWidget();
        return this.checkedEnabledConfiguration.backgroundColor;
    }

    public void setBackgroundColorCheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedEnabledConfiguration(this);
            this.checkedEnabledConfiguration.backgroundColor = temp.backgroundColor;
        } else {
            this.checkedEnabledConfiguration.backgroundColor = color;
        }
    }

    public Color getBackgroundColorUncheckedEnabled() {
        this.checkWidget();
        return this.uncheckedEnabledConfiguration.backgroundColor;
    }

    public void setBackgroundColorUncheckedEnabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedEnabledConfiguration(this);
            this.uncheckedEnabledConfiguration.backgroundColor = temp.backgroundColor;
        } else {
            this.uncheckedEnabledConfiguration.backgroundColor = color;
        }
    }

    public Color getBackgroundColorCheckedDisabled() {
        this.checkWidget();
        return this.checkedDisabledConfiguration.backgroundColor;
    }

    public void setBackgroundColorCheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createCheckedDisabledConfiguration(this);
            this.checkedDisabledConfiguration.backgroundColor = temp.backgroundColor;
        } else {
            this.checkedDisabledConfiguration.backgroundColor = color;
        }
    }

    public Color getBackgroundColorUncheckedDisabled() {
        this.checkWidget();
        return this.uncheckedDisabledConfiguration.backgroundColor;
    }

    public void setBackgroundColorUncheckedDisabled(Color color) {
        this.checkWidget();
        if (color == null) {
            RoundedSwitchConfiguration temp = RoundedSwitchConfiguration.createUncheckedDisabledConfiguration(this);
            this.uncheckedDisabledConfiguration.backgroundColor = temp.backgroundColor;
        } else {
            this.uncheckedDisabledConfiguration.backgroundColor = color;
        }
    }
}

