/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import org.eclipse.nebula.widgets.formattedtext.DefaultFormatterFactory;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FormattedText {
    public static final String TEXT_DATA_KEY = "formattedText";
    protected Text text;
    protected ITextFormatter formatter = null;
    protected int caretPos;
    protected GridLayout layout;
    protected Listener modifyFilter;
    protected static boolean beepSound = true;
    protected static int count = 0;
    protected int id = ++count;

    public FormattedText(Composite parent) {
        this(parent, 2048);
    }

    public FormattedText(Composite parent, int style) {
        this(new Text(parent, style & 0xFFBFFFBD));
    }

    public FormattedText(Text t) {
        this.text = t;
        this.text.setData(TEXT_DATA_KEY, (Object)this);
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (FormattedText.this.formatter != null && FormattedText.this.text.getEditable()) {
                    FormattedText.this.formatter.setIgnore(true);
                    FormattedText.this.setText(FormattedText.this.formatter.getEditString());
                    FormattedText.this.text.setSelection(FormattedText.this.caretPos);
                    FormattedText.this.formatter.setIgnore(false);
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormattedText.this.formatter != null && FormattedText.this.text.getEditable()) {
                    FormattedText.this.formatter.setIgnore(true);
                    FormattedText.this.caretPos = FormattedText.this.text.getCaretPosition();
                    String editString = FormattedText.this.formatter.getEditString();
                    String displayString = FormattedText.this.formatter.getDisplayString();
                    if (!editString.equals(displayString)) {
                        FormattedText.this.formatter.setValue(FormattedText.this.formatter.getValue());
                    }
                    FormattedText.this.setText(displayString);
                    FormattedText.this.formatter.setIgnore(false);
                }
            }
        });
        this.modifyFilter = new Listener(){

            public void handleEvent(Event event) {
                event.type = 0;
            }
        };
        this.text.addListener(12, e -> {
            this.text = null;
            this.modifyFilter = null;
            this.formatter = null;
        });
    }

    public Text getControl() {
        return this.text;
    }

    public ITextFormatter getFormatter() {
        return this.formatter;
    }

    public Object getValue() {
        return this.formatter != null ? this.formatter.getValue() : this.text.getText();
    }

    public Class<?> getValueType() {
        return this.formatter != null ? this.formatter.getValueType() : String.class;
    }

    public static boolean isBeepSound() {
        return beepSound;
    }

    public boolean isEmpty() {
        return this.formatter != null ? this.formatter.isEmpty() : this.text.getText().length() == 0;
    }

    public boolean isValid() {
        return this.formatter != null ? this.formatter.isValid() : true;
    }

    public static void setBeepSound(boolean beepSound) {
        FormattedText.beepSound = beepSound;
    }

    public void setFormatter(ITextFormatter formatter) {
        if (formatter == null) {
            SWT.error((int)4);
        }
        if (this.formatter != null) {
            this.text.removeVerifyListener((VerifyListener)this.formatter);
            this.formatter.detach();
        }
        this.formatter = formatter;
        this.formatter.setText(this.text);
        this.text.addVerifyListener((VerifyListener)this.formatter);
        formatter.setIgnore(true);
        this.text.setText(formatter.getDisplayString());
        formatter.setIgnore(false);
    }

    private void setText(String value) {
        Display display = this.text.getDisplay();
        try {
            display.addFilter(24, this.modifyFilter);
            this.text.setText(value);
        }
        finally {
            display.removeFilter(24, this.modifyFilter);
        }
    }

    public void setValue(Object value) {
        if (this.formatter == null) {
            this.setFormatter(DefaultFormatterFactory.createFormatter(value));
        }
        this.formatter.setValue(value);
        this.formatter.setIgnore(true);
        this.text.setText(this.text.isFocusControl() ? this.formatter.getEditString() : this.formatter.getDisplayString());
        this.formatter.setIgnore(false);
    }
}

