/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.navigation;

import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class NavigationPageScaleRenderer
extends AbstractPageControllerComposite
implements SelectionListener {
    private Scale pageScale;

    public NavigationPageScaleRenderer(Composite parent, int style, PageableController controller) {
        super(parent, style, controller);
    }

    @Override
    public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller) {
        this.updateScaleRange(controller);
        this.pageScale.setSelection(newPageIndex);
    }

    @Override
    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
    }

    @Override
    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    @Override
    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController controller) {
        this.updateScaleRange(controller);
    }

    private void updateScaleRange(PageableController controller) {
        int totalPages = controller.getTotalPages();
        this.pageScale.setMinimum(0);
        if (totalPages > 1) {
            this.pageScale.setMaximum(totalPages - 1);
        } else {
            this.pageScale.setMaximum(1);
        }
        this.pageScale.setPageIncrement(1);
    }

    @Override
    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.pageScale = new Scale(parent, 8);
        this.pageScale.setLayoutData((Object)new GridData(768));
        this.pageScale.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void dispose() {
        this.pageScale.removeSelectionListener((SelectionListener)this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int newCurrentPage = this.pageScale.getSelection();
        super.setCurrentPage(newCurrentPage);
    }
}

