/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.listeners;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorTimingsLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.LaneFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewCursorLayer;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class CursorMover
extends MouseMotionListener.Stub
implements MouseListener,
MouseMotionListener {
    private static final int SNAP_TO_FIGURE_OFFSET = 10;
    private final CursorFigure fFigure;
    private Point fLocation = null;

    public CursorMover(CursorFigure figure) {
        this.fFigure = figure;
        figure.addMouseListener(this);
        figure.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent me) {
        this.fLocation = me.getLocation();
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (me.button == 3) {
            this.hideCursorTimings();
            ICursor cursor = (ICursor)this.fFigure.getParent().getLayoutManager().getConstraint((IFigure)this.fFigure);
            RootFigure.getRootFigure((IFigure)this.fFigure).deleteCursor(cursor);
        }
        if (this.fLocation != null) {
            this.fLocation = null;
            me.consume();
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this.fLocation != null) {
            Point targetLocation = me.getLocation();
            Long targetEventTime = this.snapToEvent(targetLocation);
            if (targetEventTime == null) {
                Dimension offset = targetLocation.getDifference(this.fLocation);
                if (offset.width() != 0) {
                    TimeBaseConverter timeDetails = RootFigure.getRootFigure((IFigure)this.fFigure).getTimeViewDetails();
                    targetEventTime = timeDetails.screenOffsetToEventTime(targetLocation.x());
                }
                this.fLocation = targetLocation;
            }
            if (targetEventTime != null) {
                ICursor cursor = (ICursor)this.fFigure.getParent().getLayoutManager().getConstraint((IFigure)this.fFigure);
                cursor.setTimestamp(targetEventTime);
                this.fFigure.getParent().revalidate();
                RootFigure.getFigure((IFigure)this.fFigure, CursorTimingsLayer.class).revalidate();
                RootFigure.getFigure((IFigure)this.fFigure, OverviewCursorLayer.class).revalidate();
            }
        }
        me.consume();
    }

    private Long snapToEvent(Point mouseCursorLocation) {
        int diffToEnd;
        Rectangle figureBounds;
        int diffToStart;
        IFigure figureUnderCursor = RootFigure.getFigure((IFigure)this.fFigure, TracksLayer.class).findFigureAt(mouseCursorLocation);
        if (figureUnderCursor instanceof LaneFigure) {
            int offset = 0;
            while (offset <= 10) {
                IFigure figure = figureUnderCursor.findFigureAt(mouseCursorLocation.x() - offset, mouseCursorLocation.y());
                if (figure instanceof EventFigure) {
                    figureUnderCursor = figure;
                    break;
                }
                figure = figureUnderCursor.findFigureAt(mouseCursorLocation.x() + offset, mouseCursorLocation.y());
                if (figure instanceof EventFigure) {
                    figureUnderCursor = figure;
                    break;
                }
                offset += 2;
            }
        }
        if (figureUnderCursor instanceof EventFigure && Math.min(diffToStart = Math.abs((figureBounds = figureUnderCursor.getBounds()).x() - mouseCursorLocation.x()), diffToEnd = Math.abs(figureBounds.x() + figureBounds.width() - mouseCursorLocation.x())) <= 10) {
            if (diffToStart <= diffToEnd) {
                return ((EventFigure)figureUnderCursor).getEvent().getStartTimestamp();
            }
            return ((EventFigure)figureUnderCursor).getEvent().getEndTimestamp();
        }
        return null;
    }

    public void mouseEntered(MouseEvent me) {
        ITimelineStyleProvider styleProvider = RootFigure.getRootFigure((IFigure)this.fFigure).getStyleProvider();
        this.fFigure.setForegroundColor(styleProvider.getSelectedCursorColor());
        this.fFigure.setBackgroundColor(styleProvider.getSelectedCursorColor());
        CursorTimingsLayer cursorTimingsLayer = RootFigure.getFigure((IFigure)this.fFigure, CursorTimingsLayer.class);
        cursorTimingsLayer.showTimingsFor(this.fFigure, me);
    }

    public void mouseExited(MouseEvent me) {
        ITimelineStyleProvider styleProvider = RootFigure.getRootFigure((IFigure)this.fFigure).getStyleProvider();
        this.fFigure.setForegroundColor(styleProvider.getCursorColor());
        this.fFigure.setBackgroundColor(styleProvider.getCursorColor());
        this.hideCursorTimings();
    }

    public void mouseMoved(MouseEvent me) {
        CursorTimingsLayer cursorTimingsLayer = RootFigure.getFigure((IFigure)this.fFigure, CursorTimingsLayer.class);
        cursorTimingsLayer.moveTimingsTo(me.getLocation());
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    private void hideCursorTimings() {
        CursorTimingsLayer cursorTimingsLayer = RootFigure.getFigure((IFigure)this.fFigure, CursorTimingsLayer.class);
        cursorTimingsLayer.hideTimings();
    }
}

