/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.EnumStringMultiSelectionDialog;
import org.eclipse.nebula.widgets.xviewer.util.EnumStringSingleSelectionDialog;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.DateSelectionDialog;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.DialogWithEntry;
import org.eclipse.swt.widgets.Display;

public class XPromptChange {
    private static final String VALID_FLOAT_REG_EX = "^[0-9\\.]+$";
    private static final String VALID_INTEGER_REG_EX = "^[0-9]+$";
    private static final String VALID_PERCENT_REG_EX = "^(0*100{1,1}\\.?((?<=\\.)0*)?%?$)|(^0*\\d{0,2}\\.?((?<=\\.)\\d*)?%?)$";

    public static Date promptChangeDate(String displayName, Date currDate) {
        DateSelectionDialog diag = new DateSelectionDialog(XViewerText.get("XPromptChange.dialog.date_selection") + " " + displayName, XViewerText.get("XPromptChange.dialog.date_selection") + " " + displayName, currDate != null ? currDate : null);
        if (diag.open() == 0) {
            return diag.getSelectedDate();
        }
        return null;
    }

    public static EnumStringSingleSelectionDialog promptChangeSingleSelectEnumeration(String displayName, Collection<String> enums, String currSelected) {
        EnumStringSingleSelectionDialog diag = new EnumStringSingleSelectionDialog(displayName, displayName, enums, currSelected);
        if (diag.open() == 0) {
            return diag;
        }
        return null;
    }

    public static EnumStringMultiSelectionDialog promptChangeMultiSelectEnumeration(String displayName, Collection<String> enums, Collection<String> currEnums) {
        EnumStringMultiSelectionDialog diag = new EnumStringMultiSelectionDialog(displayName, enums, currEnums);
        if (diag.open() == 0) {
            return diag;
        }
        return null;
    }

    public static String promptChangeInteger(String displayName, int currEntry) {
        return XPromptChange.promptChangeInteger(displayName, currEntry == 0 ? "" : String.valueOf(currEntry));
    }

    public static String promptChangeInteger(String displayName, String currEntry) {
        return XPromptChange.promptChangeString(displayName, currEntry, VALID_INTEGER_REG_EX);
    }

    public static String promptChangePercent(String displayName, String currEntry) {
        return XPromptChange.promptChangeString(displayName, currEntry, VALID_PERCENT_REG_EX);
    }

    public static String promptChangeFloat(String displayName, double currEntry) {
        return XPromptChange.promptChangeFloat(displayName, currEntry == 0.0 ? "" : String.valueOf(currEntry));
    }

    public static String promptChangeFloat(String displayName, String currEntry) {
        return XPromptChange.promptChangeString(displayName, currEntry, VALID_FLOAT_REG_EX);
    }

    public static String promptChangeString(String displayName, String currEntry, String validationRegEx) {
        return XPromptChange.promptChangeString(displayName, currEntry, validationRegEx, Option.SINGLE_LINE);
    }

    public static String promptChangeString(String displayName, String currEntry, String validationRegEx, Option option) {
        int result;
        DialogWithEntry ed = new DialogWithEntry(XViewerText.get("XPromptChange.dialog.entry") + " " + displayName, XViewerText.get("XPromptChange.dialog.entry") + " " + displayName);
        if (option == Option.MULTI_LINE) {
            ed.setFillVertically(true);
        }
        if (currEntry != null && !currEntry.equals("")) {
            ed.setEntry(currEntry);
        }
        if (validationRegEx != null) {
            ed.setValidationRegularExpression(validationRegEx);
        }
        if ((result = ed.open()) == 0) {
            return ed.getEntry();
        }
        return null;
    }

    public static Boolean promptChangeBoolean(String displayName, String toggleMessage, boolean currSelection) {
        MessageDialogWithToggle md = new MessageDialogWithToggle(Display.getCurrent().getActiveShell(), displayName, null, displayName, 3, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0, toggleMessage != null ? toggleMessage : displayName, currSelection);
        int result = md.open();
        if (result == 0) {
            return md.getToggleState();
        }
        return null;
    }

    public static enum Option {
        SINGLE_LINE,
        MULTI_LINE;

    }
}

