/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.impl.beans.BeanProperty;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTableSupport<E> {
    private JXTable table;
    private JXTableMemento tableMemento;
    private AdvancedTableModel<E> tableModel;
    private AdvancedListSelectionModel<E> selectionModel;
    private TableFormat<? super E> tableFormat;
    private TableComparatorChooser<E> tableComparatorChooser;

    public static <E> JXTableSupport<E> install(JXTable table, EventList<E> eventList, TableFormat<? super E> tableFormat, SortedList<E> sortedList, Object sortingStrategy) {
        Preconditions.checkNotNull(table, "JXTable must be defined.");
        Preconditions.checkNotNull(eventList, "EventList must be defined.");
        Preconditions.checkNotNull(tableFormat, "TableFormat must be defined.");
        Preconditions.checkNotNull(sortedList, "SortedList must be defined.");
        Preconditions.checkNotNull(sortingStrategy, "SortingStrategy must be defined.");
        JXTableSupport.checkAccessThread();
        return new JXTableSupport<E>(table, eventList, tableFormat, sortedList, sortingStrategy);
    }

    public JXTable getTable() {
        return this.table;
    }

    public AdvancedListSelectionModel<E> getTableSelectionModel() {
        return this.selectionModel;
    }

    public AdvancedTableModel<E> getTableModel() {
        return this.tableModel;
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public TableComparatorChooser<E> getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void uninstall() {
        JXTableSupport.checkAccessThread();
        this.tableComparatorChooser.dispose();
        this.tableMemento.restoreStateTo(this.table);
        this.tableModel.dispose();
        this.selectionModel.dispose();
        this.tableComparatorChooser = null;
        this.tableModel = null;
        this.selectionModel = null;
        this.tableFormat = null;
        this.table = null;
        this.tableMemento = null;
    }

    public boolean isInstalled() {
        return this.table != null;
    }

    private JXTableSupport(JXTable table, EventList<E> eventList, TableFormat<? super E> tableFormat, SortedList<E> sortedList, Object sortingStrategy) {
        this.table = table;
        this.tableFormat = tableFormat;
        this.tableMemento = JXTableMemento.create(table);
        this.tableMemento.storeStateFrom(table);
        this.tableMemento.configureStateForGlazedLists(table);
        this.tableModel = GlazedListsSwing.eventTableModelWithThreadProxyList(eventList, tableFormat);
        table.setModel(this.tableModel);
        this.selectionModel = GlazedListsSwing.eventSelectionModelWithThreadProxyList(eventList);
        table.setSelectionModel(this.selectionModel);
        this.tableComparatorChooser = TableComparatorChooser.install((JTable)table, sortedList, sortingStrategy, tableFormat);
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("JXTableSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static class JXTable10Memento
    extends JXTableMemento {
        private Boolean oldSelectionMapperEnabled;
        private final BeanProperty<JXTable> selectionMapperEnabledProperty = new BeanProperty<JXTable>(JXTable.class, "selectionMapper.enabled", true, true);

        private JXTable10Memento() {
        }

        public void storeStateFrom(JXTable table) {
            super.storeStateFrom(table);
            this.oldSelectionMapperEnabled = (Boolean)this.selectionMapperEnabledProperty.get(table);
        }

        public void restoreStateTo(JXTable table) {
            super.restoreStateTo(table);
            this.selectionMapperEnabledProperty.set(table, this.oldSelectionMapperEnabled);
        }

        public void configureStateForGlazedLists(JXTable table) {
            super.configureStateForGlazedLists(table);
            this.selectionMapperEnabledProperty.set(table, Boolean.FALSE);
        }
    }

    private static class JXTable16Memento
    extends JXTableMemento {
        private Boolean oldAutoCreateRowSorter;
        private final BeanProperty<JXTable> autoCreateRowSorterProperty = new BeanProperty<JXTable>(JXTable.class, "autoCreateRowSorter", true, true);
        private Object oldRowSorter;
        private final BeanProperty<JXTable> rowSorterProperty = new BeanProperty<JXTable>(JXTable.class, "rowSorter", true, true);

        private JXTable16Memento() {
        }

        public void storeStateFrom(JXTable table) {
            super.storeStateFrom(table);
            this.oldAutoCreateRowSorter = (Boolean)this.autoCreateRowSorterProperty.get(table);
            this.oldRowSorter = this.rowSorterProperty.get(table);
        }

        public void restoreStateTo(JXTable table) {
            super.restoreStateTo(table);
            this.autoCreateRowSorterProperty.set(table, this.oldAutoCreateRowSorter);
            this.rowSorterProperty.set(table, this.oldRowSorter);
        }

        public void configureStateForGlazedLists(JXTable table) {
            super.configureStateForGlazedLists(table);
            this.autoCreateRowSorterProperty.set(table, Boolean.FALSE);
            this.rowSorterProperty.set(table, null);
        }
    }

    private static abstract class JXTableMemento {
        private TableModel oldTableModel;
        private ListSelectionModel oldSelectionModel;
        private boolean oldSortable;
        private TableCellRenderer oldDefaultRenderer;

        private JXTableMemento() {
        }

        public void storeStateFrom(JXTable table) {
            this.oldTableModel = table.getModel();
            this.oldSelectionModel = table.getSelectionModel();
            this.oldSortable = table.isSortable();
            this.oldDefaultRenderer = table.getTableHeader().getDefaultRenderer();
        }

        public void restoreStateTo(JXTable table) {
            table.setModel(this.oldTableModel);
            table.setSelectionModel(this.oldSelectionModel);
            table.setSortable(this.oldSortable);
            table.getTableHeader().setDefaultRenderer(this.oldDefaultRenderer);
        }

        public void configureStateForGlazedLists(JXTable table) {
            table.setSortable(false);
            table.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        }

        public static JXTableMemento create(JXTable table) {
            if (JXTableMemento.isSwingX16(table)) {
                return new JXTable16Memento();
            }
            return new JXTable10Memento();
        }

        private static boolean isSwingX16(JXTable table) {
            boolean result = false;
            try {
                table.getClass().getMethod("getSelectionMapper", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                result = true;
            }
            return result;
        }
    }
}

