/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.IColumnGroupModelListener;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupsCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.config.DefaultColumnGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TransformedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ColumnGroupHeaderLayer
extends AbstractLayerTransform {
    private final SizeConfig rowHeightConfig = new SizeConfig(20);
    private final ColumnGroupModel model;
    private final ILayer columnHeaderLayer;
    private boolean calculateHeight = false;
    private IColumnGroupModelListener modelChangeListener;

    public ColumnGroupHeaderLayer(ILayer columnHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel) {
        this(columnHeaderLayer, selectionLayer, columnGroupModel, true);
    }

    public ColumnGroupHeaderLayer(final ILayer columnHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        super(columnHeaderLayer);
        this.columnHeaderLayer = columnHeaderLayer;
        this.model = columnGroupModel;
        this.registerCommandHandler(new ColumnGroupsCommandHandler(this.model, selectionLayer, this));
        this.registerCommandHandler(new ConfigureScalingCommandHandler(null, this.rowHeightConfig));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(columnGroupModel));
        }
        this.modelChangeListener = new IColumnGroupModelListener(){

            @Override
            public void columnGroupModelChanged() {
                ColumnGroupHeaderLayer.this.fireLayerEvent(new RowStructuralRefreshEvent(columnHeaderLayer));
            }
        };
        this.model.registerColumnGroupModelListener(this.modelChangeListener);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.model.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.model.loadState(prefix, properties);
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    @Override
    public int getRowCount() {
        if (!this.calculateHeight || this.model.getAllIndexesInGroups() != null && this.model.getAllIndexesInGroups().size() > 0) {
            return this.columnHeaderLayer.getRowCount() + 1;
        }
        return this.columnHeaderLayer.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.columnHeaderLayer.getPreferredRowCount() + 1;
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return rowPosition;
        }
        return this.columnHeaderLayer.getRowIndexByPosition(rowPosition - 1);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        if (localRowPosition == 0) {
            return localRowPosition;
        }
        return localRowPosition - 1;
    }

    @Override
    public int getHeight() {
        if (!this.calculateHeight || this.model.getAllIndexesInGroups() != null && this.model.getAllIndexesInGroups().size() > 0) {
            return this.rowHeightConfig.getAggregateSize(1) + this.columnHeaderLayer.getHeight();
        }
        return this.columnHeaderLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnHeaderLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getSize(rowPosition);
        }
        return this.columnHeaderLayer.getRowHeightByPosition(rowPosition - 1);
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeightConfig.setSize(0, rowHeight);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.columnHeaderLayer.isRowPositionResizable(rowPosition - 1);
    }

    @Override
    public int getRowPositionByY(int y) {
        int row0Height = this.getRowHeightByPosition(0);
        if (y < row0Height) {
            return 0;
        }
        return 1 + this.columnHeaderLayer.getRowPositionByY(y - row0Height);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getAggregateSize(rowPosition);
        }
        return this.getRowHeightByPosition(0) + this.columnHeaderLayer.getStartYOfRowPosition(rowPosition - 1);
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.model.isPartOfAGroup(bodyColumnIndex)) {
            if (rowPosition == 0) {
                return new LayerCell(this, this.getStartPositionOfGroup(columnPosition), rowPosition, columnPosition, rowPosition, this.getColumnSpan(columnPosition), 1);
            }
            return new LayerCell(this, columnPosition, rowPosition);
        }
        ILayerCell cell = this.columnHeaderLayer.getCellByPosition(columnPosition, 0);
        if (cell != null) {
            final int rowSpan = this.calculateHeight && this.model.size() == 0 ? 1 : 2;
            cell = new TransformedLayerCell(cell){

                @Override
                public ILayer getLayer() {
                    return ColumnGroupHeaderLayer.this;
                }

                @Override
                public int getRowSpan() {
                    return rowSpan;
                }
            };
        }
        return cell;
    }

    protected int getColumnSpan(int columnPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        int sizeOfGroup = columnGroup.getSize();
        if (columnGroup.isCollapsed()) {
            int sizeOfStaticColumns = columnGroup.getStaticColumnIndexes().size();
            if (sizeOfStaticColumns == 0) {
                return 1;
            }
            sizeOfGroup = sizeOfStaticColumns;
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(columnPosition);
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getColumnIndexByPosition(i);
            if (!columnIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return sizeOfGroup;
    }

    private int getStartPositionOfGroup(int columnPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(bodyColumnIndex);
        int leastPossibleStartPositionOfGroup = columnPosition - (columnGroup.getSize() - 1);
        int i = 0;
        i = leastPossibleStartPositionOfGroup;
        while (i < columnPosition) {
            if (ColumnGroupUtils.isInTheSameGroup(this.getColumnIndexByPosition(i), bodyColumnIndex, this.model)) break;
            ++i;
        }
        return i;
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return "NORMAL";
        }
        return this.columnHeaderLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            LabelStack stack = new LabelStack(new String[0]);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(stack, columnPosition, rowPosition);
            }
            stack.addLabel("COLUMN_GROUP_HEADER");
            if (this.model.isPartOfACollapseableGroup(columnIndex)) {
                ColumnGroupModel.ColumnGroup group = this.model.getColumnGroupByIndex(columnIndex);
                if (group.isCollapsed()) {
                    stack.addLabelOnTop("GROUP_COLLAPSED");
                } else {
                    stack.addLabelOnTop("GROUP_EXPANDED");
                }
            }
            return stack;
        }
        return this.columnHeaderLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return this.model.getColumnGroupByIndex(columnIndex).getName();
        }
        return this.columnHeaderLayer.getDataValueByPosition(columnPosition, 0);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        int columnIndex = this.getColumnIndexByPosition(this.getColumnPositionByX(x));
        if (this.model.isPartOfAGroup(columnIndex) && y < this.getRowHeightByPosition(0)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnHeaderLayer.getRegionLabelsByXY(x, y - this.getRowHeightByPosition(0));
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... colIndexes) {
        this.model.addColumnsIndexesToGroup(colGroupName, colIndexes);
    }

    public void clearAllGroups() {
        this.model.clear();
    }

    public void setStaticColumnIndexesByGroup(String colGroupName, int ... staticColumnIndexes) {
        this.model.setStaticColumnIndexesByGroup(colGroupName, staticColumnIndexes);
    }

    public boolean isColumnInGroup(int bodyColumnIndex) {
        return this.model.isPartOfAGroup(bodyColumnIndex);
    }

    public void setGroupUnbreakable(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setUnbreakable(true);
    }

    public void setGroupAsCollapsed(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setCollapsed(true);
    }

    public boolean isCalculateHeight() {
        return this.calculateHeight;
    }

    public void setCalculateHeight(boolean calculateHeight) {
        this.calculateHeight = calculateHeight;
        if (calculateHeight) {
            this.model.registerColumnGroupModelListener(this.modelChangeListener);
        } else {
            this.model.unregisterColumnGroupModelListener(this.modelChangeListener);
        }
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("COLUMN_GROUP_HEADER");
        labels.add("GROUP_COLLAPSED");
        labels.add("GROUP_EXPANDED");
        if (this.getConfigLabelAccumulator() != null && this.getConfigLabelAccumulator() instanceof IConfigLabelProvider) {
            labels.addAll(((IConfigLabelProvider)this.getConfigLabelAccumulator()).getProvidedLabels());
        }
        return labels;
    }
}

