/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import java.util.regex.Matcher;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;
import org.junit.Assert;
import org.junit.Test;

public class TracHyperlinkUtilStandaloneTest {
    @Test
    public void testWikiPattern2SinglePositiveMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"HyperLink");
        Assert.assertFalse((boolean)matcher.find());
    }

    @Test
    public void testWikiPattern2MultiplePositiveMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there and ThereIsAnother");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"HyperLink");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"ThereIsAnother");
        Assert.assertFalse((boolean)matcher.find());
    }

    @Test
    public void testWikiPattern2SingleNegativeMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("no !HyperLink there");
        Assert.assertFalse((boolean)matcher.find());
    }

    @Test
    public void testWikiPattern2SinglePositiveMatchAtStartOfLine() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("HyperLink there");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"HyperLink");
        Assert.assertFalse((boolean)matcher.find());
    }

    @Test
    public void testWikiPattern2SingleNegativeMatchAtStartOfLine() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("!HyperLink there");
        Assert.assertFalse((boolean)matcher.find());
    }

    @Test
    public void testWikiPattern2MixedPositiveNegativeMatch() {
        Matcher matcher = TracHyperlinkUtil.wikiPattern2.matcher("a HyperLink there and ThereIsAnother but !NotHere");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"HyperLink");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)matcher.group(0), (Object)"ThereIsAnother");
        Assert.assertFalse((boolean)matcher.find());
    }
}

