/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskInitializationData;

public class TaskInitializationDataTest
extends TestCase {
    private TaskInitializationData data;

    protected void setUp() throws Exception {
        this.data = new TaskInitializationData();
    }

    public void testNotSupported() {
        try {
            this.data.merge(null);
            TaskInitializationDataTest.fail((String)"Should not be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        TaskInitializationDataTest.assertNull((Object)this.data.getTaskStatus());
        TaskInitializationDataTest.assertNull((Object)this.data.getTaskData());
        TaskInitializationDataTest.assertNull((Object)this.data.getPriorityLevel());
        TaskInitializationDataTest.assertNull((Object)this.data.getModificationDate());
        TaskInitializationDataTest.assertNull((Object)this.data.getKeywords());
        TaskInitializationDataTest.assertNull((Object)this.data.getDueDate());
        TaskInitializationDataTest.assertNull((Object)this.data.getCreationDate());
        TaskInitializationDataTest.assertNull((Object)this.data.getCompletionDate());
        TaskInitializationDataTest.assertNull((Object)this.data.getCc());
    }

    public void testTaskKind() throws Exception {
        this.data.setTaskKind("foo");
        TaskInitializationDataTest.assertEquals((String)"foo", (String)this.data.getTaskKind());
        TaskInitializationDataTest.assertEquals((String)"foo", (String)this.data.getAttribute("task.common.kind"));
    }

    public void testProduct() throws Exception {
        this.data.setProduct("product");
        TaskInitializationDataTest.assertEquals((String)"product", (String)this.data.getProduct());
        TaskInitializationDataTest.assertEquals((String)"product", (String)this.data.getAttribute("task.common.product"));
    }

    public void testComponent() throws Exception {
        this.data.setComponent("component");
        TaskInitializationDataTest.assertEquals((String)"component", (String)this.data.getComponent());
        TaskInitializationDataTest.assertEquals((String)"component", (String)this.data.getAttribute("task.common.component"));
    }

    public void testSetAttributeComponent() throws Exception {
        this.data.setAttribute("task.common.component", "component");
        TaskInitializationDataTest.assertEquals((String)"component", (String)this.data.getComponent());
        TaskInitializationDataTest.assertEquals((String)"component", (String)this.data.getAttribute("task.common.component"));
    }

    public void testGetAttribute() throws Exception {
        TaskInitializationDataTest.assertNull((Object)this.data.getAttribute("custom"));
        this.data.setAttribute("custom", "value");
        TaskInitializationDataTest.assertEquals((String)"value", (String)this.data.getAttribute("custom"));
        this.data.setAttribute("custom", null);
        TaskInitializationDataTest.assertNull((Object)this.data.getAttribute("custom"));
    }
}

