/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataImportWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataImportWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.Workbench;

public class TaskDataImportTest
extends TestCase {
    private TaskDataImportWizard wizard = null;
    private TaskDataImportWizardPage wizardPage = null;
    private final String BACKUP_v1 = "testdata/taskdataimporttest/mylardata-2007-01-19.zip";
    private final String BACKUP_v3 = "testdata/taskdataimporttest/mylyn-v3-data-2009-12-09-171942.zip";
    private final String BACKUP_IMPORT_TEST = "testdata/taskdataimporttest/mylyn-v3-data-2010-02-28.zip";
    private final String BACKUP_OLD_v3 = "testdata/taskdataimporttest/mylyn-v3-data-2009-12-09-old-tasklist.zip";
    private TaskList taskList;

    protected void setUp() throws Exception {
        super.setUp();
        this.wizard = new TaskDataImportWizard();
        this.wizard.addPages();
        this.wizard.createPageControls((Composite)new Shell());
        this.wizardPage = (TaskDataImportWizardPage)this.wizard.getPage("org.eclipse.mylyn.tasklist.importPage");
        TaskDataImportTest.assertNotNull((Object)this.wizardPage);
        TaskTestUtil.resetTaskListAndRepositories();
        this.taskList = TasksUiPlugin.getTaskList();
    }

    protected void tearDown() throws Exception {
        this.wizard.dispose();
        this.wizardPage.dispose();
        TaskTestUtil.resetTaskListAndRepositories();
        super.tearDown();
    }

    public void testDisableWorkingSets() throws Exception {
        IWorkingSetManager workingSetManager = Workbench.getInstance().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("Task Working Set", new IAdaptable[0]);
        workingSet.setId(TaskWorkingSetUpdater.ID_TASK_WORKING_SET);
        TaskDataImportTest.assertEquals((int)0, (int)workingSet.getElements().length);
        workingSetManager.addWorkingSet(workingSet);
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        workingSets.add(workingSet);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(workingSets);
        TaskDataImportWizard.performFinish((File)TaskTestUtil.getLocalFile("testdata/taskdataimporttest/mylyn-v3-data-2010-02-28.zip"), null);
        TaskDataImportTest.assertEquals((int)2, (int)TasksUiPlugin.getTaskList().getCategories().size());
        TaskDataImportTest.assertEquals((int)0, (int)workingSet.getElements().length);
        workingSetManager.removeWorkingSet(workingSet);
    }

    public void testImportRepositoriesZip() {
        TaskDataImportTest.assertNotNull((Object)this.taskList);
        TaskDataImportTest.assertTrue((this.taskList.getAllTasks().size() == 0 ? 1 : 0) != 0);
        this.wizardPage.setSource(true, TaskTestUtil.getLocalFile("testdata/taskdataimporttest/mylardata-2007-01-19.zip").getAbsolutePath());
        this.wizard.performFinish();
        Collection tasks = this.taskList.getAllTasks();
        TaskDataImportTest.assertEquals((int)2, (int)tasks.size());
        if (TasksUi.getRepositoryConnector((String)"bugzilla") != null) {
            TaskDataImportTest.assertEquals((int)3, (int)TasksUiPlugin.getRepositoryManager().getAllRepositories().size());
        } else {
            TaskDataImportTest.assertEquals((int)1, (int)TasksUiPlugin.getRepositoryManager().getAllRepositories().size());
        }
    }

    public void testImportOverwritesAllTasks() {
        TaskDataImportTest.assertNotNull((Object)this.taskList);
        TaskDataImportTest.assertTrue((this.taskList.getAllTasks().size() == 0 ? 1 : 0) != 0);
        LocalTask task1 = new LocalTask("999", "label");
        this.taskList.addTask((ITask)task1);
        Collection tasks = this.taskList.getAllTasks();
        TaskDataImportTest.assertEquals((int)1, (int)tasks.size());
        this.wizardPage.setSource(true, TaskTestUtil.getLocalFile("testdata/taskdataimporttest/mylardata-2007-01-19.zip").getAbsolutePath());
        this.wizard.performFinish();
        tasks = this.taskList.getAllTasks();
        TaskDataImportTest.assertEquals((int)2, (int)tasks.size());
        TaskDataImportTest.assertTrue((!this.taskList.getAllTasks().contains(task1) ? 1 : 0) != 0);
        if (TasksUi.getRepositoryConnector((String)"bugzilla") != null) {
            TaskDataImportTest.assertEquals((int)3, (int)TasksUiPlugin.getRepositoryManager().getAllRepositories().size());
        } else {
            TaskDataImportTest.assertEquals((int)1, (int)TasksUiPlugin.getRepositoryManager().getAllRepositories().size());
        }
    }

    public void testImportBackupWithOldTaskList() {
        this.wizardPage.setSource(true, TaskTestUtil.getLocalFile("testdata/taskdataimporttest/mylyn-v3-data-2009-12-09-old-tasklist.zip").getAbsolutePath());
        this.wizard.performFinish();
        Collection tasks = this.taskList.getAllTasks();
        TaskDataImportTest.assertEquals((int)1, (int)tasks.size());
        TaskDataImportTest.assertEquals((String)"Task 3", (String)((AbstractTask)tasks.iterator().next()).getSummary());
    }

    public void testImportBackup() {
        this.wizardPage.setSource(true, TaskTestUtil.getLocalFile("testdata/taskdataimporttest/mylyn-v3-data-2009-12-09-171942.zip").getAbsolutePath());
        this.wizard.performFinish();
        Collection tasks = this.taskList.getAllTasks();
        TaskDataImportTest.assertEquals((int)1, (int)tasks.size());
        TaskDataImportTest.assertEquals((String)"Task 3", (String)((AbstractTask)tasks.iterator().next()).getSummary());
    }
}

