/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;

public class DateRangeTest
extends TestCase {
    private static final int HOUR = 3600000;

    public void testCompareInstant() {
        DateRange range1 = new DateRange(TaskActivityUtil.getCurrentWeek().getToday().previous().getStartDate());
        DateRange range2 = new DateRange(TaskActivityUtil.getCurrentWeek().getToday().getStartDate());
        DateRangeTest.assertEquals((int)-1, (int)range1.compareTo(range2));
        DateRangeTest.assertEquals((int)1, (int)range2.compareTo(range1));
    }

    public void testCompareRanges() {
        DayDateRange range1 = TaskActivityUtil.getCurrentWeek().getToday().previous();
        DayDateRange range2 = TaskActivityUtil.getCurrentWeek().getToday();
        DateRangeTest.assertEquals((int)-1, (int)range1.compareTo((DateRange)range2));
        DateRangeTest.assertEquals((int)1, (int)range2.compareTo((DateRange)range1));
    }

    public void testQueryDateRange() {
        SortedMap scheduledTasks = Collections.synchronizedSortedMap(new TreeMap());
        DayDateRange range1 = TaskActivityUtil.getCurrentWeek().getToday().previous();
        HashSet<LocalTask> tasks = new HashSet<LocalTask>();
        tasks.add(new LocalTask("1", "summaryForLocalTask"));
        scheduledTasks.put(range1, tasks);
        DateRangeTest.assertFalse((boolean)scheduledTasks.isEmpty());
        DateRangeTest.assertNotNull(scheduledTasks.get(range1));
        DayDateRange rangeTest = TaskActivityUtil.getCurrentWeek().getToday().previous();
        DateRangeTest.assertNotNull(scheduledTasks.get(rangeTest));
        DayDateRange range2 = TaskActivityUtil.getCurrentWeek().getToday();
        tasks = new HashSet();
        tasks.add(new LocalTask("2", "summaryForLocalTask2"));
        scheduledTasks.put(range2, tasks);
        SortedMap result = scheduledTasks.subMap(range1, range2);
        DateRangeTest.assertEquals((int)1, (int)result.size());
        DayDateRange range0 = TaskActivityUtil.getCurrentWeek().getToday().previous().previous();
        DayDateRange range3 = TaskActivityUtil.getCurrentWeek().getToday().next();
        result = scheduledTasks.subMap(range0, range3);
        DateRangeTest.assertEquals((int)2, (int)result.size());
    }

    public void testOverScheduled() {
        SortedMap scheduledTasks = Collections.synchronizedSortedMap(new TreeMap());
        DayDateRange range1 = TaskActivityUtil.getDayOf((Date)new Date(0L));
        HashSet<LocalTask> tasks = new HashSet<LocalTask>();
        tasks.add(new LocalTask("1", "summaryForLocalTask"));
        scheduledTasks.put(range1, tasks);
        DateRangeTest.assertFalse((boolean)scheduledTasks.isEmpty());
        DateRangeTest.assertNotNull(scheduledTasks.get(range1));
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(0L);
        Calendar end = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapStartOfDay((Calendar)end);
        DateRange startRange = new DateRange(start);
        Calendar endExclusive = TaskActivityUtil.getCalendar();
        endExclusive.setTimeInMillis(end.getTimeInMillis() + 1L);
        DateRange endRange = new DateRange(endExclusive);
        SortedMap result = scheduledTasks.subMap(startRange, endRange);
        DateRangeTest.assertEquals((int)1, (int)result.size());
    }

    public void testIsWeekRange() {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("PST"));
            Calendar time = TaskActivityUtil.getCalendar();
            time.set(2008, 9, 1);
            WeekDateRange range = TaskActivityUtil.getWeekOf((Date)time.getTime());
            DateRangeTest.assertTrue((boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() + 1L);
            DateRangeTest.assertTrue((String)"1 ms longer than a week, expected to be within legal interval", (boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertFalse((String)"only a day", (boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            time.set(2008, 2, 9);
            range = TaskActivityUtil.getWeekOf((Date)time.getTime());
            DateRangeTest.assertEquals((int)0, (int)range.getStartDate().get(16));
            DateRangeTest.assertEquals((int)3600000, (int)range.getEndDate().get(16));
            DateRangeTest.assertTrue((boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() + 1L);
            DateRangeTest.assertFalse((String)"1 ms too long", (boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertFalse((boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            time.set(2008, 10, 2);
            range = TaskActivityUtil.getWeekOf((Date)time.getTime());
            DateRangeTest.assertEquals((int)3600000, (int)range.getStartDate().get(16));
            DateRangeTest.assertEquals((int)0, (int)range.getEndDate().get(16));
            DateRangeTest.assertTrue((boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() - 1L);
            DateRangeTest.assertFalse((String)"1 ms too short", (boolean)WeekDateRange.isWeekRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    public void testIsDayRange() {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("PST"));
            Calendar time = TaskActivityUtil.getCalendar();
            time.set(2008, 9, 1);
            DayDateRange range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertTrue((boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() + 1L);
            DateRangeTest.assertTrue((String)"1 ms longer than a day, expected to be within legal interval", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() + 3600000L);
            DateRangeTest.assertFalse((String)"1 hour + 1 ms longer than a day", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() - 0x6DDD00L - 2L);
            DateRangeTest.assertFalse((String)"1 hour + 1 ms shorter than a day", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertTrue((String)"a week", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            time.set(2008, 2, 9);
            range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertEquals((int)0, (int)range.getStartDate().get(16));
            DateRangeTest.assertEquals((int)3600000, (int)range.getEndDate().get(16));
            DateRangeTest.assertTrue((boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() + 1L);
            DateRangeTest.assertFalse((String)"1 ms too long", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            time.set(2008, 10, 2);
            range = TaskActivityUtil.getDayOf((Date)time.getTime());
            DateRangeTest.assertEquals((int)3600000, (int)range.getStartDate().get(16));
            DateRangeTest.assertEquals((int)0, (int)range.getEndDate().get(16));
            DateRangeTest.assertTrue((boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
            range.getStartDate().setTimeInMillis(range.getStartDate().getTimeInMillis() - 1L);
            DateRangeTest.assertFalse((String)"1 ms too short", (boolean)DayDateRange.isDayRange((Calendar)range.getStartDate(), (Calendar)range.getEndDate()));
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    public void testNext() {
        Calendar time = TaskActivityUtil.getCalendar();
        time.set(2008, 11, 31);
        DayDateRange day = TaskActivityUtil.getDayOf((Date)time.getTime());
        DateRangeTest.assertEquals((int)2009, (int)day.next().getStartDate().get(1));
        DateRangeTest.assertEquals((int)2008, (int)day.getStartDate().get(1));
        DateRangeTest.assertEquals((Object)day, (Object)day.next().previous());
        WeekDateRange week = TaskActivityUtil.getWeekOf((Date)time.getTime());
        DateRangeTest.assertEquals((int)2009, (int)week.next().getStartDate().get(1));
        DateRangeTest.assertEquals((int)2008, (int)week.getStartDate().get(1));
        DateRangeTest.assertEquals((Object)week, (Object)week.next().previous());
    }
}

