/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.tests.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorWithTaskDataHandler;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class MockTestContext {
    private final TaskList taskList;
    private final TaskRepositoryManager repositoryManager;
    private final TaskDataManager dataManager;
    private final TaskDataStore dataStore;
    private final TaskActivityManager activityManager;
    private final SynchronizationManger synchronizationManger;
    private final RepositoryModel repositoryModel;
    private final TaskRepository mockRepository;
    private final TaskRepository localRepository;
    private final AtomicInteger idSeed = new AtomicInteger(1003);
    private final MockRepositoryConnectorWithTaskDataHandler mockRepositoryConnector;
    private final File dataDir;

    public MockTestContext() throws IOException {
        this.taskList = new TaskList();
        this.repositoryManager = new TaskRepositoryManager();
        this.mockRepositoryConnector = new MockRepositoryConnectorWithTaskDataHandler();
        this.repositoryManager.addRepositoryConnector((AbstractRepositoryConnector)this.mockRepositoryConnector);
        this.mockRepository = new TaskRepository("mock", "http://mockrepository.test");
        this.repositoryManager.addRepository(this.mockRepository);
        this.repositoryManager.addRepositoryConnector((AbstractRepositoryConnector)new LocalRepositoryConnector());
        this.localRepository = new TaskRepository("local", "local");
        this.repositoryManager.addRepository(this.localRepository);
        this.dataStore = new TaskDataStore((IRepositoryManager)this.repositoryManager);
        this.activityManager = new TaskActivityManager(this.repositoryManager, this.taskList);
        this.repositoryModel = new RepositoryModel(this.taskList, (IRepositoryManager)this.repositoryManager);
        this.synchronizationManger = new SynchronizationManger(this.repositoryModel);
        this.dataManager = new TaskDataManager(this.dataStore, (IRepositoryManager)this.repositoryManager, this.taskList, this.activityManager, this.synchronizationManger);
        this.dataDir = CommonTestUtil.createTempFolder((String)MockTestContext.class.getSimpleName());
        this.dataManager.setDataPath(this.dataDir.getAbsolutePath());
    }

    public TaskList getTaskList() {
        return this.taskList;
    }

    public TaskRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public TaskDataManager getDataManager() {
        return this.dataManager;
    }

    public TaskDataStore getDataStore() {
        return this.dataStore;
    }

    public TaskActivityManager getActivityManager() {
        return this.activityManager;
    }

    public SynchronizationManger getSynchronizationManger() {
        return this.synchronizationManger;
    }

    public RepositoryModel getRepositoryModel() {
        return this.repositoryModel;
    }

    public ITask createLocalTask() {
        LocalTask task = new LocalTask(Integer.toString(this.idSeed.incrementAndGet()), "summary");
        task.setNotes("description " + task.getTaskKey());
        this.taskList.addTask((ITask)task);
        return task;
    }

    public ITask createRepositoryTask() throws CoreException {
        MockTask task = new MockTask(Integer.toString(this.idSeed.incrementAndGet()));
        TaskData taskData = new TaskData(new TaskAttributeMapper(this.mockRepository), task.getConnectorKind(), task.getRepositoryUrl(), task.getTaskId());
        this.mockRepositoryConnector.getTaskDataHandler().initializeTaskData(this.mockRepository, taskData, (ITaskMapping)new TaskMapping(), (IProgressMonitor)new NullProgressMonitor());
        taskData.getRoot().getMappedAttribute("task.common.summary").setValue("summary");
        taskData.getRoot().getMappedAttribute("task.common.date.created").setValue(Long.toString(new Date().getTime()));
        taskData.getRoot().getMappedAttribute("task.common.user.reporter").setValue("reporter@example.com");
        taskData.getRoot().getMappedAttribute("task.common.user.assigned").setValue("assignee@example.com");
        taskData.getRoot().getMappedAttribute("task.common.description").setValue("task description " + task.getTaskKey());
        taskData.getRoot().getMappedAttribute("task.common.key").setValue(task.getTaskKey());
        this.mockRepositoryConnector.getTaskMapping(taskData).applyTo((ITask)task);
        this.dataManager.putSubmittedTaskData((ITask)task, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        this.taskList.addTask((ITask)task);
        return task;
    }

    public TaskRepository getMockRepository() {
        return this.mockRepository;
    }

    public MockRepositoryConnectorWithTaskDataHandler getMockRepositoryConnector() {
        return this.mockRepositoryConnector;
    }

    public void refactorMockRepositoryUrl(String newUrl) throws CoreException {
        String oldUrl = this.getMockRepository().getRepositoryUrl();
        for (ITask task : this.getTaskList().getAllTasks()) {
            if (oldUrl.equals(task.getAttribute("outgoingNewRepositoryUrl"))) {
                this.getDataManager().refactorRepositoryUrl(task, task.getRepositoryUrl(), newUrl);
            }
            if (!task.getRepositoryUrl().equals(oldUrl)) continue;
            this.getDataManager().refactorRepositoryUrl(task, newUrl, newUrl);
        }
        this.getTaskList().refactorRepositoryUrl(oldUrl, newUrl);
        this.getMockRepository().setRepositoryUrl(newUrl);
        this.getRepositoryManager().notifyRepositoryUrlChanged(this.getMockRepository(), oldUrl);
    }

    public void dispose() {
        CommonTestUtil.deleteFolderRecursively((File)this.dataDir);
    }
}

