/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.subclipse.core;

import java.net.MalformedURLException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.subclipse.core.SubclipseCorePlugin;
import org.eclipse.mylyn.internal.subclipse.core.SubclipseRepository;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubclipseArtifact
extends ScmArtifact {
    private final SubclipseRepository repository;
    private static final ILog logger = SubclipseCorePlugin.getDefault().getLog();
    private ISVNRemoteResource svnRemResource = null;

    public SubclipseArtifact(String id, String path, SubclipseRepository repository) {
        super(id, path);
        this.repository = repository;
    }

    public IFileRevision getFileRevision(IProgressMonitor monitor) {
        try {
            final IPath path = Path.fromPortableString((String)this.getPath());
            return new FileRevision(){

                public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                    return this;
                }

                public boolean isPropertyMissing() {
                    return false;
                }

                public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                    if (SubclipseArtifact.this.svnRemResource != null) {
                        return SubclipseArtifact.this.svnRemResource.getStorage(monitor);
                    }
                    Long revisionNum = Long.decode(SubclipseArtifact.this.getId());
                    return SubclipseArtifact.this.resolveStorage(monitor, revisionNum, SubclipseArtifact.this.repository.getLocation(), SubclipseArtifact.this.getPath());
                }

                public String getContentIdentifier() {
                    if (SubclipseArtifact.this.svnRemResource != null) {
                        return SubclipseArtifact.this.svnRemResource.getLastChangedRevision().toString();
                    }
                    return null;
                }

                public String getName() {
                    return path.lastSegment();
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IFileRevision[] getContributors(IProgressMonitor monitor) {
        if (this.svnRemResource == null) {
            return null;
        }
        SVNRevision.Number firstRevision = new SVNRevision.Number(1L);
        SVNRevision.Number previousRevision = new SVNRevision.Number(Long.parseLong(this.getId()));
        GetLogsCommand logCmd = new GetLogsCommand(this.svnRemResource, null, (SVNRevision)previousRevision, (SVNRevision)firstRevision, false, 2L, null, true);
        try {
            logCmd.run(monitor);
        }
        catch (SVNException e) {
            return null;
        }
        ILogEntry[] entries = logCmd.getLogEntries();
        if (entries.length < 2) {
            return null;
        }
        final ISVNRemoteResource remoteResource = entries[entries.length - 1].getRemoteResource();
        IFileRevision[] contributors = new IFileRevision[]{new FileRevision(){

            public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                return this;
            }

            public boolean isPropertyMissing() {
                return false;
            }

            public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                if (remoteResource != null) {
                    return remoteResource.getStorage(monitor);
                }
                return null;
            }

            public String getContentIdentifier() {
                if (remoteResource != null) {
                    return remoteResource.getLastChangedRevision().toString();
                }
                return null;
            }

            public String getName() {
                return remoteResource.getName();
            }
        }};
        return contributors;
    }

    public IFileRevision[] getTargets(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public SVNUrl getRepositoryURL() throws MalformedURLException {
        return new SVNUrl(this.appendToPath(this.repository.getLocation().getRepositoryRoot().toString(), this.getPath()));
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.svnRemResource = remoteResource;
    }

    private String appendToPath(String aBase, String aTail) {
        String dBase = aBase;
        String dTail = aTail;
        if (!aBase.endsWith("/")) {
            dBase = String.valueOf(aBase) + "/";
        }
        if (aTail.startsWith("/")) {
            dTail = aTail.substring(1);
        }
        return String.valueOf(dBase) + dTail;
    }

    private ISVNRemoteResource resolveRemoteResource(IProgressMonitor monitor, ISVNRepositoryLocation location, SVNRevision revision, SVNUrl url) throws CoreException {
        GetRemoteResourceCommand command = new GetRemoteResourceCommand(location, url, revision);
        command.run(monitor);
        ISVNRemoteResource resource = command.getRemoteResource();
        if (resource == null) {
            String msg = "Unable to resolve remote resource for: " + url.toString();
            Status status = new Status(4, "org.eclipse.mylyn.subclipse.core", msg);
            throw new CoreException((IStatus)status);
        }
        return resource;
    }

    private IStorage resolveStorage(IProgressMonitor monitor, Long revNo, ISVNRepositoryLocation location, String path) {
        try {
            SVNRevision.Number revision = new SVNRevision.Number(revNo.longValue());
            SVNUrl url = this.getRepositoryURL();
            ISVNRemoteResource resource = this.resolveRemoteResource(monitor, location, (SVNRevision)revision, url);
            if (resource.isFolder()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.subclipse.core", "The path refers to a folder not to a file: " + path));
            }
            RemoteFile file = new RemoteFile(null, location, url, (SVNRevision)revision, revision, null, null);
            file.setPegRevision((SVNRevision)revision);
            file.fetchContents(monitor);
            return file.getStorage(monitor);
        }
        catch (Exception e) {
            logger.log((IStatus)new Status(2, "org.eclipse.mylyn.subclipse.core", "Unable to resolve storage, " + revNo + ", " + path));
            return null;
        }
    }
}

