/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracHarness {
    private final TracFixture fixture;
    private TracXmlRpcClient priviledgedClient;
    private TaskRepository repository;

    public TracHarness(TracFixture fixture) {
        this.fixture = fixture;
    }

    public void attachFile(int ticketId, String name, String content) throws Exception {
        this.priviledgedClient().putAttachmentData(ticketId, name, "", (InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), null, true);
    }

    public TracRepositoryConnector connector() {
        return this.fixture.connector();
    }

    public void createMilestone(String milestone) throws Exception {
        new XmlRpcServer(this.priviledgedClient()).ticketMilestone(milestone).deleteAndCreate(new Object[0]);
    }

    public ITask createTask(String summary) throws Exception {
        TracTicket ticket = this.createTicket(summary);
        return this.getTask(ticket);
    }

    public TaskData createTaskData(String summary) throws Exception {
        TracTicket ticket = this.createTicket(summary);
        return this.fixture.connector().getTaskData(this.repository(), Integer.toString(ticket.getId()), null);
    }

    public TracTicket createTicket(String summary) throws Exception {
        TracTicket ticket = this.newTicket(summary);
        return this.createTicket(ticket);
    }

    public TracTicket createTicket(TracTicket ticket) throws TracException, Exception {
        int id = this.priviledgedClient().createTicket(ticket, null);
        return this.priviledgedClient().getTicket(id, null);
    }

    public TracTicket createTicketWithMilestone(String summary, String milestone) throws Exception {
        TracTicket ticket = this.newTicket(summary);
        ticket.putBuiltinValue(TracTicket.Key.MILESTONE, milestone);
        return this.createTicket(ticket);
    }

    public void createWikiPage(String pageName, String content) throws Exception {
        this.priviledgedClient().putWikipage(pageName, content, Collections.emptyMap(), null);
    }

    public void dispose() {
    }

    public TracFixture getFixture() {
        return this.fixture;
    }

    public ITask getTask(String taskId) throws Exception {
        TaskRepository repository = this.repository();
        TaskData taskData = this.fixture.connector().getTaskData(repository, taskId, null);
        ITask task = TasksUi.getRepositoryModel().createTask(repository, taskData.getTaskId());
        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(task, taskData, true);
        return task;
    }

    public ITask getTask(TracTicket ticket) throws Exception {
        return this.getTask(Integer.toString(ticket.getId()));
    }

    public boolean hasMilestone(String milestone) {
        try {
            new XmlRpcServer(this.priviledgedClient()).ticketMilestone(milestone).get();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isXmlRpc() {
        return ITracClient.Version.XML_RPC.name().equals(this.repository().getVersion());
    }

    public TracTicket newTicket(String summary) throws InvalidTicketException {
        TracTicket ticket = new TracTicket();
        ticket.putBuiltinValue(TracTicket.Key.SUMMARY, summary);
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "");
        return ticket;
    }

    public TaskRepository repository() {
        if (this.repository == null) {
            this.repository = this.fixture.singleRepository();
        }
        return this.repository;
    }

    public void udpateTicket(TracTicket ticket) throws Exception {
        this.priviledgedClient().updateTicket(ticket, "", null);
    }

    private TracXmlRpcClient priviledgedClient() throws Exception {
        if (this.priviledgedClient == null) {
            this.priviledgedClient = (TracXmlRpcClient)this.fixture.connectXmlRpc(CommonTestUtil.PrivilegeLevel.USER);
        }
        return this.priviledgedClient;
    }
}

