/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.ConnectorBrand;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TaskRepositoryLabelProviderTest {
    private final IBrandManager manager = (IBrandManager)Mockito.mock(IBrandManager.class);
    private final TaskRepositoryLabelProvider labelProvider = new TaskRepositoryLabelProvider(){

        protected IBrandManager getBrandManager() {
            return TaskRepositoryLabelProviderTest.this.manager;
        }
    };

    @Test
    public void testGetImage() {
        Image brandingImage = new Image((Device)Display.getCurrent(), 1, 1);
        Mockito.when((Object)this.manager.getBrandingIcon("mock", "a")).thenReturn((Object)brandingImage);
        Assert.assertEquals((Object)brandingImage, (Object)this.labelProvider.getImage((Object)new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), "a")));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY), (Object)this.labelProvider.getImage((Object)new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), "b")));
    }

    @Test
    public void testGetText() {
        Mockito.when((Object)this.manager.getConnectorLabel((AbstractRepositoryConnector)Matchers.any(AbstractRepositoryConnector.class), (String)Matchers.eq((Object)"a"))).thenReturn((Object)"Mock Brand");
        Mockito.when((Object)this.manager.getConnectorLabel((AbstractRepositoryConnector)Matchers.any(AbstractRepositoryConnector.class), (String)Matchers.eq((Object)"b"))).thenReturn((Object)"Mock Brand B");
        Assert.assertEquals((Object)"Mock Brand", (Object)this.labelProvider.getText((Object)new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), "a")));
        Assert.assertEquals((Object)"Mock Brand B", (Object)this.labelProvider.getText((Object)new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), "b")));
    }
}

