/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.migrator.CompleteConnectorMigrationWizard;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationUi;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.DefaultTasksState;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CompleteConnectorMigrationWizardTest {
    private CompleteConnectorMigrationWizard wizard;
    private ConnectorMigrator migrator;
    private ConnectorMigrationUi migrationUi;
    private DefaultTasksState tasksState;

    @Before
    public void setUp() {
        this.tasksState = new DefaultTasksState();
        this.migrationUi = (ConnectorMigrationUi)Mockito.spy((Object)new ConnectorMigrationUi(TaskListView.getFromActivePerspective(), TasksUiPlugin.getBackupManager(), (TasksState)this.tasksState));
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).warnOfValidationFailure((List)Matchers.any(List.class));
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).notifyMigrationComplete();
        this.migrator = this.createMigrator((ImmutableMap<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new"));
    }

    private ConnectorMigrator createMigrator(ImmutableMap<String, String> kinds) {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)new ConnectorMigrator(kinds, "", (TasksState)this.tasksState, this.migrationUi));
        Mockito.when((Object)migrator.allQueriesMigrated()).thenReturn((Object)false);
        return migrator;
    }

    @After
    public void tearDown() throws Exception {
        TestFixture.resetTaskList();
    }

    @Test
    public void addPages() {
        this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        Assert.assertEquals((long)2L, (long)this.wizard.getPageCount());
    }

    @Test
    public void firstPage() {
        IWizardContainer container = this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        Assert.assertEquals((Object)"Have You Recreated Your Queries?", (Object)firstPage.getTitle());
        Assert.assertEquals((Object)"Migration will remove your old queries. Please ensure you have created the new queries you want. Your old and new queries are shown below and you can edit them by double-clicking.", (Object)firstPage.getMessage());
        Assert.assertTrue((boolean)(firstPage.getControl() instanceof Composite));
        Composite control = (Composite)firstPage.getControl();
        Assert.assertEquals((long)4L, (long)control.getChildren().length);
        Assert.assertTrue((boolean)(control.getChildren()[0] instanceof Label));
        Assert.assertTrue((boolean)(control.getChildren()[1] instanceof Label));
        Assert.assertTrue((boolean)(control.getChildren()[2] instanceof Tree));
        Assert.assertTrue((boolean)(control.getChildren()[3] instanceof Tree));
    }

    @Test
    public void firstPageSomeQueriesMigrated() {
        Mockito.when((Object)this.migrator.anyQueriesMigrated()).thenReturn((Object)true);
        IWizardContainer container = this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        Assert.assertEquals((Object)"Have You Recreated Your Queries?", (Object)firstPage.getTitle());
        Assert.assertEquals((Object)"Migration will remove your old queries. Some queries could not be automatically migrated. Please review your old and new queries and edit or create new ones as needed. Your old and new queries are shown below and you can edit them by double-clicking.", (Object)firstPage.getMessage());
        Assert.assertTrue((boolean)(firstPage.getControl() instanceof Composite));
        Composite control = (Composite)firstPage.getControl();
        Assert.assertEquals((long)4L, (long)control.getChildren().length);
        Assert.assertTrue((boolean)(control.getChildren()[0] instanceof Label));
        Assert.assertTrue((boolean)(control.getChildren()[1] instanceof Label));
        Assert.assertTrue((boolean)(control.getChildren()[2] instanceof Tree));
        Assert.assertTrue((boolean)(control.getChildren()[3] instanceof Tree));
    }

    @Test
    public void firstPageAllQueriesMigrated() {
        Mockito.when((Object)this.migrator.allQueriesMigrated()).thenReturn((Object)true);
        IWizardContainer container = this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        Assert.assertEquals((Object)"Complete Migration", (Object)firstPage.getTitle());
        Assert.assertNull((Object)firstPage.getNextPage());
    }

    @Test
    public void queryTreeShowsOnlySelectedConnectors() {
        this.migrator = this.createMigrator((ImmutableMap<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new", (Object)"kind", (Object)"kind.new"));
        this.migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"kind"));
        this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        ArgumentCaptor captor = ArgumentCaptor.forClass(Collection.class);
        ((CompleteConnectorMigrationWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)2))).createRepositoryQueryMap((Collection)captor.capture());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"kind"), (Object)ImmutableSet.copyOf((Collection)((Collection)captor.getAllValues().get(0))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"kind.new"), (Object)ImmutableSet.copyOf((Collection)((Collection)captor.getAllValues().get(1))));
        this.migrator = this.createMigrator((ImmutableMap<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new", (Object)"kind", (Object)"kind.new"));
        this.migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"mock", (Object)"kind"));
        this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        captor = ArgumentCaptor.forClass(Collection.class);
        ((CompleteConnectorMigrationWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)2))).createRepositoryQueryMap((Collection)captor.capture());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"mock", (Object)"kind"), (Object)ImmutableSet.copyOf((Collection)((Collection)captor.getAllValues().get(0))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"mock.new", (Object)"kind.new"), (Object)ImmutableSet.copyOf((Collection)((Collection)captor.getAllValues().get(1))));
    }

    @Test
    public void secondPage() {
        IWizardContainer container = this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        IWizardPage secondPage = firstPage.getNextPage();
        Assert.assertEquals((Object)"Complete Migration", (Object)secondPage.getTitle());
        Assert.assertEquals((Object)"Clicking finish will migrate your tasks and private data. This may take a while.", (Object)secondPage.getMessage());
        Assert.assertTrue((boolean)(secondPage.getControl() instanceof Composite));
        Composite control = (Composite)secondPage.getControl();
        Assert.assertEquals((long)1L, (long)control.getChildren().length);
        Assert.assertTrue((boolean)(control.getChildren()[0] instanceof Text));
        String text = ((Text)control.getChildren()[0]).getText();
        Assert.assertTrue((boolean)text.contains("When you click finish, your context, scheduled dates, private notes and other data will be migrated to the new connectors. Any tasks in your task list that are not included in the new queries will be downloaded using the new connectors. The old tasks, queries, and repositories will be deleted."));
        Assert.assertTrue((boolean)text.contains("This may take a while. You should not use the task list or task editor while this is happening. You will be prompted when migration is complete."));
        Assert.assertTrue((boolean)text.contains("You will be able to undo the migration by selecting \"Restore Tasks from History\" in the Task List view menu and choosing the connector-migration-*.zip file stored in <workspace>/.metadata/.mylyn/backup. This will restore your task list and repositories to the state they were in before the migration, but any data stored by 3rd party plugins for Mylyn may be lost"));
    }

    @Test
    public void performFinish() throws InvocationTargetException, InterruptedException, IOException {
        this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        Assert.assertTrue((boolean)this.wizard.performFinish());
    }

    @Test
    public void isPageComplete() throws Exception {
        IWizardContainer container = this.createWizard(new CompleteConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        IWizardPage secondPage = firstPage.getNextPage();
        Assert.assertTrue((boolean)firstPage.isPageComplete());
        Assert.assertFalse((boolean)secondPage.isPageComplete());
        container.showPage(secondPage);
        Assert.assertTrue((boolean)firstPage.isPageComplete());
        Assert.assertTrue((boolean)secondPage.isPageComplete());
    }

    @Test
    public void createQueryTree() throws Exception {
        TaskRepository repository = this.createRepository("mock", "http://mock");
        ImmutableMap queries = ImmutableMap.of((Object)repository, (Object)ImmutableSet.of((Object)new RepositoryQuery("mock", "mock")));
        TreeViewer viewer = new CompleteConnectorMigrationWizard(this.migrator).createQueryTree((Composite)WorkbenchUtil.getShell(), (Map)queries);
        Assert.assertEquals((Object)queries, (Object)viewer.getInput());
        Assert.assertTrue((boolean)(viewer.getContentProvider() instanceof CompleteConnectorMigrationWizard.MapContentProvider));
        Assert.assertTrue((boolean)(viewer.getLabelProvider() instanceof TaskElementLabelProvider));
        Assert.assertNotNull((Object)((TaskElementLabelProvider)viewer.getLabelProvider()).getImage((Object)repository));
        Assert.assertEquals((Object)"http://mock", (Object)((TaskElementLabelProvider)viewer.getLabelProvider()).getText((Object)repository));
        Assert.assertEquals((long)0L, (long)viewer.getExpandedElements().length);
        this.spinEventLoop();
        Assert.assertEquals((long)1L, (long)viewer.getExpandedElements().length);
    }

    @Test
    public void createRepositoryQueryMap() throws Exception {
        TaskRepository repository1 = this.createRepository("mock", "http://mock");
        TaskRepository repository2 = this.createRepository("mock", "http://mock2");
        ImmutableSet repositories = ImmutableSet.of((Object)repository1, (Object)repository2);
        RepositoryQuery query1 = this.createQuery(repository1);
        RepositoryQuery query2 = this.createQuery(repository1);
        RepositoryQuery query3 = this.createQuery(repository2);
        RepositoryQuery query4 = this.createQuery(repository2);
        Map map = new CompleteConnectorMigrationWizard(this.migrator).createRepositoryQueryMap((Collection)ImmutableList.of((Object)"mock"));
        Assert.assertEquals((Object)repositories, map.keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)query1, (Object)query2), map.get(repository1));
        Assert.assertEquals((Object)ImmutableSet.of((Object)query3, (Object)query4), map.get(repository2));
    }

    @Test
    public void createRepositoryQueryMapExcludesRepositoryWithNoQueries() throws Exception {
        TaskRepository repository = this.createRepository("mock", "http://mock");
        this.createRepository("mock", "http://mock2");
        RepositoryQuery query = this.createQuery(repository);
        Map map = new CompleteConnectorMigrationWizard(this.migrator).createRepositoryQueryMap((Collection)ImmutableList.of((Object)"mock"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)repository), map.keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)query), map.get(repository));
    }

    @Test
    public void createRepositoryQueryMapMigratedQuery() throws Exception {
        TaskRepository repository = this.createRepository("mock", "http://mock");
        TaskRepository migratedRepository = this.createRepository("mock-new", "http://mock");
        RepositoryQuery query = this.createQuery(repository);
        RepositoryQuery migratedQuery = this.createQuery(migratedRepository);
        Map map = new CompleteConnectorMigrationWizard(this.migrator).createRepositoryQueryMap((Collection)ImmutableList.of((Object)"mock"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)repository), map.keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)query), map.get(repository));
        map = new CompleteConnectorMigrationWizard(this.migrator).createRepositoryQueryMap((Collection)ImmutableList.of((Object)"mock-new"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)migratedRepository), map.keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)migratedQuery), map.get(migratedRepository));
    }

    protected TaskRepository createRepository(String kind, String url) {
        TaskRepository repository = new TaskRepository(kind, url);
        this.migrator.getRepositoryManager().addRepository(repository);
        return repository;
    }

    protected RepositoryQuery createQuery(TaskRepository repository) {
        RepositoryQuery query = new RepositoryQuery(repository.getConnectorKind(), String.valueOf(repository.getConnectorKind()) + repository.getRepositoryUrl() + Math.random());
        query.setRepositoryUrl(repository.getRepositoryUrl());
        TasksUiPlugin.getTaskList().addQuery(query);
        return query;
    }

    private IWizardContainer createWizard(CompleteConnectorMigrationWizard wiz) {
        this.wizard = (CompleteConnectorMigrationWizard)Mockito.spy((Object)wiz);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)this.wizard);
        dialog.create();
        IWizardContainer container = (IWizardContainer)Mockito.spy((Object)this.wizard.getContainer());
        Mockito.when((Object)this.wizard.getContainer()).thenReturn((Object)container);
        return container;
    }

    private void spinEventLoop() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

