/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.utils.MarkerUtils;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.qvt.declarative.editor.AbstractLabelElement;
import org.eclipse.qvt.declarative.editor.EcoreLabelElement;
import org.eclipse.qvt.declarative.editor.JavaLabelElement;
import org.eclipse.qvt.declarative.editor.LabelBehavior;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonEditorDefinition;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.eclipse.qvt.declarative.parser.utils.ASTandCST;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonLabelProvider
implements ILabelProvider {
    private Set<ILabelProviderListener> fListeners = new HashSet<ILabelProviderListener>();
    protected ExtendedImageRegistry imageRegistry = new ExtendedImageRegistry();
    private Image errorImageOverlay = null;
    private Image warningImageOverlay = null;

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add(listener);
    }

    protected Object checkedGet(Object object, EStructuralFeature path) {
        if (path == null) {
            throw new NullPointerException("Null path element");
        }
        if (object == null) {
            throw new NullPointerException("Null path object");
        }
        if (!(object instanceof EObject)) {
            throw new ClassCastException("Non EObject");
        }
        EClass objectEClass = ((EObject)object).eClass();
        EClass pathEClass = path.getEContainingClass();
        if (!pathEClass.isSuperTypeOf(objectEClass)) {
            throw new IllegalArgumentException("Incompatible " + objectEClass.getName() + " for " + pathEClass.getName());
        }
        return ((EObject)object).eGet(path);
    }

    public void dispose() {
    }

    protected String formatCollection(Collection<?> objects, EcoreLabelElement labelElement) {
        StringBuffer s = new StringBuffer();
        for (Object object : objects) {
            if (s.length() > 0) {
                s.append(labelElement.getSeparator());
            }
            s.append(object instanceof String ? (String)object : this.formatObject(object));
        }
        String string = s.toString();
        return string;
    }

    protected String formatEcoreLabelElement(Object node, EcoreLabelElement labelElement) {
        Object object = node;
        for (EReference path : labelElement.getPath()) {
            object = this.checkedGet(object, (EStructuralFeature)path);
        }
        if (object instanceof EObject) {
            EStructuralFeature end = labelElement.getEnd();
            object = end == null ? "<" + ((EObject)object).eClass().getName() + ">" : this.checkedGet(object, end);
        }
        String string = object == null ? this.formatNull() : (object instanceof Collection ? this.formatCollection((Collection)object, labelElement) : (object instanceof Enum ? this.formatEnum((Enum)object) : (!(object instanceof String) ? this.formatObject(object) : (String)object)));
        return string;
    }

    protected String formatEnum(Enum<?> object) {
        return object.toString();
    }

    protected String formatException(Throwable e, Object node, int index) {
        return "<!" + e.getClass().getSimpleName() + "!>";
    }

    protected Object formatJavaLabelElement(Object node, JavaLabelElement labelElement) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String methodName = labelElement.getMethod();
        String className = labelElement.getClass_();
        if (className == null) {
            Class<?> methodClass = node.getClass();
            Method method = methodClass.getMethod(methodName, new Class[0]);
            return String.valueOf(method.invoke(node, new Object[0]));
        }
        Class<?> methodClass = Class.forName(className);
        Method method = methodClass.getMethod(methodName, node.getClass());
        return String.valueOf(method.invoke(null, node));
    }

    protected String formatNull() {
        return "";
    }

    protected String formatObject(Object node) {
        CommonEditorDefinition commonEditorDefinition = this.getPlugin().getEditorDefinition();
        LabelBehavior behavior = commonEditorDefinition.getBehavior(node, LabelBehavior.class);
        if (behavior == null) {
            return null;
        }
        String format = behavior.getFormat();
        EList labelElements = behavior.getElements();
        int iMax = labelElements.size();
        Object[] strings = new String[iMax];
        int i = 0;
        while (i < iMax) {
            try {
                AbstractLabelElement labelElement = (AbstractLabelElement)labelElements.get(i);
                strings[i] = labelElement instanceof EcoreLabelElement ? this.formatEcoreLabelElement(node, (EcoreLabelElement)labelElement) : (labelElement instanceof JavaLabelElement ? this.formatJavaLabelElement(node, (JavaLabelElement)labelElement) : "<?" + labelElement.getClass().getSimpleName() + "?>");
            }
            catch (Throwable e) {
                strings[i] = this.formatException(e, node, i);
            }
            ++i;
        }
        return MessageFormat.format(format, strings);
    }

    protected Object getASTorCSTNode(Object element) {
        if (element instanceof ModelTreeNode) {
            return ((ModelTreeNode)element).getASTNode();
        }
        if (element instanceof ASTandCST) {
            return ((ASTandCST)element).getCST();
        }
        return element;
    }

    protected Image getErrorImageOverlay() {
        if (this.errorImageOverlay == null) {
            this.errorImageOverlay = this.getImage(QVTEditorPlugin.getDefault().getBundle(), "icons/error_ovr.gif");
        }
        return this.errorImageOverlay;
    }

    public Image getImage(Object element) {
        Object node = this.getASTorCSTNode(element);
        CommonEditorDefinition commonEditorDefinition = this.getPlugin().getEditorDefinition();
        LabelBehavior behavior = commonEditorDefinition.getBehavior(node, LabelBehavior.class);
        if (behavior == null) {
            return null;
        }
        Image image = this.getImage(this.getPlugin().getBundle(), behavior.getImage());
        if (image == null) {
            return null;
        }
        Collection<Image> overlays = this.getOverlayImages(node);
        if (overlays == null || overlays.isEmpty()) {
            return image;
        }
        ArrayList<Image> images = new ArrayList<Image>(overlays.size() + 1);
        images.add(image);
        images.addAll(overlays);
        return this.imageRegistry.getImage((Object)new ComposedImage(images));
    }

    protected Image getImage(Bundle defaultBundle, String imagePath) {
        Path path;
        URL url;
        int index;
        Bundle bundle = defaultBundle;
        String imageFile = imagePath;
        if (imagePath.startsWith("/") && (index = imagePath.indexOf(47, 1)) > 1) {
            imageFile = imagePath.substring(index + 1);
            String bundlePath = imagePath.substring(1, index);
            bundle = Platform.getBundle((String)bundlePath);
            if (bundle == null) {
                this.getPlugin().logException("No such bundle '" + bundlePath + "'", null);
                return null;
            }
        }
        if ((url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(imageFile)), null)) == null) {
            return null;
        }
        Image image = this.imageRegistry.getImage((Object)url);
        return image;
    }

    protected Collection<Image> getOverlayImages(Object node) {
        if (node instanceof IFile) {
            IFile file = (IFile)node;
            int sev = MarkerUtils.getMaxProblemMarkerSeverity((IResource)file, (int)1);
            switch (sev) {
                case 2: {
                    return Collections.singletonList(this.getErrorImageOverlay());
                }
                case 1: {
                    return Collections.singletonList(this.getWarningImageOverlay());
                }
            }
        }
        return null;
    }

    protected Image getWarningImageOverlay() {
        if (this.warningImageOverlay == null) {
            this.warningImageOverlay = this.getImage(QVTEditorPlugin.getDefault().getBundle(), "icons/warn_ovr.gif");
        }
        return this.warningImageOverlay;
    }

    protected abstract ICommonPlugin getPlugin();

    public String getText(Object element) {
        Object node = this.getASTorCSTNode(element);
        String text = this.formatObject(node);
        return text != null ? text : "<!null!>";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove(listener);
    }
}

