/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.cst;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.editor.IMPOutlinePage;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.ui.cst.ICSTOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonTextEditor;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonTreeModelBuilder;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;

public abstract class CommonOutlinePage
extends IMPOutlinePage
implements ICSTOutlinePage,
ISelectionListener {
    protected final CommonTextEditor editor;
    protected final CommonTreeModelBuilder treeModelBuilder;
    private boolean changingSelection = false;

    public CommonOutlinePage(CommonTextEditor editor, CommonTreeModelBuilder treeModelBuilder) {
        super((IParseController)editor.getParseController(), (TreeModelBuilderBase)treeModelBuilder, editor.getLanguageServiceManager().getLabelProvider(), editor.getLanguageServiceManager().getImageProvider(), null);
        this.editor = editor;
        this.treeModelBuilder = treeModelBuilder;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
    }

    protected ISelection getItemSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object[] selections = ((IStructuredSelection)selection).toArray();
            Object[] unwrappedSelections = new Object[selections.length];
            int i = 0;
            while (i < selections.length) {
                unwrappedSelections[i] = this.treeModelBuilder.getItem(selections[i]);
                ++i;
            }
            selection = new StructuredSelection(unwrappedSelections);
        }
        return selection;
    }

    public void init(IPageSite pageSite) {
        this.editor.addModelListener((IModelListener)this);
        pageSite.getPage().addSelectionListener((ISelectionListener)this);
        super.init(pageSite);
    }

    protected boolean isChangingSelection() {
        return this.changingSelection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.changingSelection) {
            try {
                this.changingSelection = true;
                ISelection selection = event.getSelection();
                this.fireSelectionChanged(selection);
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                    Object object = ((IStructuredSelection)selection).getFirstElement();
                    CSTNode cstNode = this.editor.getParseController().getCSTNode(object);
                    if (cstNode != null) {
                        this.editor.selectAndReveal(cstNode.getStartOffset(), cstNode.getEndOffset() - cstNode.getStartOffset() + 1);
                    }
                }
            }
            finally {
                this.changingSelection = false;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isChangingSelection()) {
            this.setSelection(selection);
        }
    }

    public void setSelection(ISelection selection) {
        if (!this.changingSelection) {
            try {
                this.changingSelection = true;
                ISelection itemSelection = this.getItemSelection(selection);
                super.setSelection(itemSelection);
            }
            finally {
                this.changingSelection = false;
            }
        }
    }

    public void update(IParseController parseController, IProgressMonitor monitor) {
        if (this.getTreeViewer() != null && this.getTreeViewer().getContentProvider() != null) {
            super.update(parseController, monitor);
        }
    }
}

